/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Extent;
import nextapp.echo.app.StreamImageReference;
import pl.com.stream.echo.lib.graphic.GifEncoder;

public class StaticImageReference
extends StreamImageReference {
    private static final Map<String, String> extensionToContentType;
    private static final long serialVersionUID = 6088840817595505260L;
    private final String contentType;
    private final String extension;
    private Extent height;
    private final String id;
    private BufferedImage image;
    private final String resource;
    private Extent width;

    private static final String getContentType(String string) {
        String string2 = StaticImageReference.getExtension(string);
        String string3 = extensionToContentType.get(string2);
        if (string3 == null) {
            throw new IllegalArgumentException("Wrong file extension: " + string2);
        }
        return string3;
    }

    private static final String getExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(".");
        if (n == -1) {
            throw new IllegalArgumentException("Resource: " + string + " has no extension.");
        }
        string2 = string.substring(n + 1).toLowerCase();
        return string2;
    }

    public StaticImageReference(String string) {
        this.resource = string;
        this.id = ApplicationInstance.generateSystemId();
        this.contentType = StaticImageReference.getContentType(string);
        this.extension = StaticImageReference.getExtension(string);
    }

    public String getContentType() {
        return this.contentType;
    }

    public Extent getHeight() {
        return this.height;
    }

    public String getRenderId() {
        return this.id;
    }

    public Extent getWidth() {
        return this.width;
    }

    public void render(OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = this.prepareImage();
        if ("gif".equals(this.extension)) {
            GifEncoder gifEncoder = new GifEncoder();
            gifEncoder.encode(bufferedImage, outputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, this.extension, outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage prepareImage() throws IOException {
        if (this.image == null) {
            InputStream inputStream = null;
            try {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.resource);
                if (inputStream == null) {
                    throw new IllegalArgumentException("Specified resource does not exist: " + this.resource + ".");
                }
                this.image = ImageIO.read(inputStream);
                this.width = new Extent(this.image.getWidth());
                this.height = new Extent(this.image.getHeight());
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.image;
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("gif", "image/gif");
        hashMap.put("png", "image/png");
        hashMap.put("jpeg", "image/jpeg");
        hashMap.put("jpg", "image/jpg");
        hashMap.put("bmp", "image/bmp");
        extensionToContentType = Collections.unmodifiableMap(hashMap);
    }
}

