/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import nextapp.echo.app.Extent;
import nextapp.echo.app.StreamImageReference;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.graphic.GraphicUtil;

public abstract class ScalableImageReference
extends StreamImageReference {
    private static final Map<String, String> extensionToContentType;
    private static final Logger log;
    private static final long serialVersionUID = 1439684726349929168L;
    private String contentType;
    private String extension;
    private final GraphicUtil graphicUtil;
    private Integer height;
    private ImageIcon icon;
    private String id;
    private StreamImageReference imageNotFoundReference;
    private final Integer quality;
    private final boolean scaleImage;
    private boolean sizeReaded;
    private final Integer thumbHeight;
    private final Integer thumbWidth;
    private Integer width;

    public ScalableImageReference(Integer n, Integer n2, Integer n3) {
        this.thumbHeight = n2;
        this.thumbWidth = n;
        this.quality = n3 != null ? n3 : 80;
        this.scaleImage = this.isImageScaling(n, n2, n3);
        this.graphicUtil = new GraphicUtil(n != null ? n : 1, n2 != null ? n2 : 1, n3 != null ? n3 : 100);
    }

    public String getContentType() {
        return this.contentType == null ? extensionToContentType.get(this.getExtension()) : this.contentType;
    }

    public String getExtension() {
        return this.extension != null ? this.extension : GraphicUtil.DEFAULT_EXTENSION;
    }

    public Extent getHeight() {
        if (this.height != null) {
            return new Extent(this.height.intValue());
        }
        return null;
    }

    public String getRenderId() {
        if (this.id == null) {
            this.id = this.loadId();
        }
        return this.id;
    }

    public Extent getWidth() {
        if (this.width != null) {
            return new Extent(this.width.intValue());
        }
        return null;
    }

    public void render(OutputStream outputStream) throws IOException {
        if (this.isScaleImage()) {
            ImageIcon imageIcon = this.getImage();
            if (imageIcon != null) {
                this.getGraphicUtil().scaleImage(imageIcon, outputStream, this.getExtension());
            } else if (this.imageNotFoundReference != null) {
                this.imageNotFoundReference.render(outputStream);
            }
        } else {
            this.renderStream(outputStream);
        }
        this.icon = null;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setImageNotFoundReference(StreamImageReference streamImageReference) {
        this.imageNotFoundReference = streamImageReference;
    }

    private ImageIcon getImage() {
        if (this.icon == null) {
            this.icon = this.loadImageIcon();
        }
        return this.icon;
    }

    protected String getContentType(String string) {
        if (string == null) {
            string = GraphicUtil.DEFAULT_EXTENSION;
        }
        this.contentType = extensionToContentType.get(string);
        if (this.contentType == null) {
            log.debug((Object)("Unsupportet file extension: " + string + ". Getting default - " + GraphicUtil.DEFAULT_EXTENSION));
            this.contentType = extensionToContentType.get(GraphicUtil.DEFAULT_EXTENSION);
        }
        return this.contentType;
    }

    protected String getExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    protected GraphicUtil getGraphicUtil() {
        return this.graphicUtil;
    }

    protected Integer getQuality() {
        return this.quality;
    }

    protected Integer getReadedHeight() {
        return this.height;
    }

    protected Integer getReadedWidth() {
        return this.width;
    }

    protected Integer getThumbHeight() {
        return this.thumbHeight;
    }

    protected Integer getThumbWidth() {
        return this.thumbWidth;
    }

    protected boolean isImageScaling(Integer n, Integer n2, Integer n3) {
        return n != null && n > 0 && n2 != null && n2 > 0 && n3 != null && n3 >= 0;
    }

    protected boolean isScaleImage() {
        return this.scaleImage;
    }

    protected boolean isSizeReaded() {
        return this.sizeReaded;
    }

    protected abstract String loadId();

    protected abstract ImageIcon loadImageIcon();

    protected void readImageInfo() {
        ImageIcon imageIcon = this.getImage();
        if (imageIcon == null) {
            return;
        }
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        if (this.isScaleImage()) {
            double d;
            double d2;
            this.width = this.thumbWidth;
            this.height = this.thumbHeight;
            double d3 = this.width.intValue();
            double d4 = d3 / (d2 = (double)this.height.intValue());
            if (d4 < (d = (double)n / (double)n2)) {
                this.height = (int)(d3 / d);
            } else {
                this.width = (int)(d2 * d);
            }
        } else {
            this.width = n;
            this.height = n2;
        }
        this.sizeReaded = true;
    }

    protected abstract void renderStream(OutputStream var1);

    static {
        log = Logger.getLogger(ScalableImageReference.class);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(GraphicUtil.GIF_EXTENSION, "image/gif");
        hashMap.put(GraphicUtil.PNG_EXTENSION, "image/png");
        hashMap.put(GraphicUtil.JPEG_EXTENSION, "image/jpeg");
        hashMap.put(GraphicUtil.JPG_EXTENSION, "image/jpeg");
        hashMap.put(GraphicUtil.BMP_EXTENSION, "image/bmp");
        extensionToContentType = Collections.unmodifiableMap(hashMap);
    }
}

