/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.graphic.ScalableImageReference;

public class ResourceScalableImageReference
extends ScalableImageReference {
    private static final long serialVersionUID = 1597437252891353785L;
    private final String resource;
    private static final Logger log = Logger.getLogger(ResourceScalableImageReference.class);

    public ResourceScalableImageReference(String string) {
        this(string, null, null, null);
    }

    public ResourceScalableImageReference(String string, Integer n, Integer n2, Integer n3) {
        super(n, n2, n3);
        this.resource = string;
        String string2 = this.getExtension(string);
        String string3 = this.getContentType(string2);
        this.setExtension(string2);
        this.setContentType(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageIcon loadFromResource(OutputStream outputStream) {
        ImageIcon imageIcon = null;
        InputStream inputStream = null;
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.resource);
            if (inputStream == null) {
                throw new IllegalArgumentException("Specified resource does not exist: " + this.resource + ".");
            }
            if (outputStream != null) {
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            } else {
                imageIcon = this.getGraphicUtil().readImageIcon(inputStream);
            }
        }
        catch (IOException iOException) {
            log.error((Object)("Can not render image from resource: " + this.resource + " - " + iOException.getMessage()), (Throwable)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return imageIcon;
    }

    protected String loadId() {
        return this.resource;
    }

    protected ImageIcon loadImageIcon() {
        return this.loadFromResource(null);
    }

    protected void renderStream(OutputStream outputStream) {
        this.loadFromResource(outputStream);
    }
}

