/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.imageio.ImageIO;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Extent;
import nextapp.echo.app.StreamImageReference;

public class ProgressIconReference
extends StreamImageReference {
    private static final long serialVersionUID = 7701287258418965826L;
    private static final int emptyPixel = -1835037;
    private static final int filledPixel = -7423346;
    private final Extent width;
    private final Extent height;
    private final String id = ApplicationInstance.generateSystemId();
    private BufferedImage image;
    private final Integer progress;

    public ProgressIconReference(int n) {
        this(n, new Extent(12), new Extent(10));
    }

    public ProgressIconReference(int n, Extent extent, Extent extent2) {
        this.width = extent;
        this.height = extent2;
        this.progress = new BigDecimal(n).multiply(new BigDecimal(extent.getValue() - 2)).divide(new BigDecimal(100), RoundingMode.HALF_UP).intValue();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProgressIconReference)) {
            return false;
        }
        ProgressIconReference progressIconReference = (ProgressIconReference)((Object)object);
        if (!(this.width == progressIconReference.width || this.width != null && this.width.equals((Object)progressIconReference.width))) {
            return false;
        }
        return this.height == progressIconReference.height || this.height != null && this.height.equals((Object)progressIconReference.height);
    }

    public String getContentType() {
        return "image/png";
    }

    public Extent getHeight() {
        return this.height;
    }

    public String getRenderId() {
        return this.id;
    }

    public Extent getWidth() {
        return this.width;
    }

    public void render(OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = this.prepareImage();
        ImageIO.write((RenderedImage)bufferedImage, "PNG", outputStream);
    }

    private BufferedImage prepareImage() throws IOException {
        if (this.image == null) {
            int n;
            this.image = new BufferedImage(this.width.getValue(), this.height.getValue(), 6);
            int[] nArray = new int[this.width.getValue() * this.height.getValue()];
            for (n = 0; n < this.width.getValue(); ++n) {
                nArray[n] = -7423346;
            }
            for (n = this.width.getValue(); n < nArray.length - this.width.getValue(); ++n) {
                int n2 = n % this.width.getValue();
                nArray[n] = n2 == 0 || n2 == this.width.getValue() - 1 ? -7423346 : (n2 <= this.progress ? -7423346 : -1835037);
            }
            for (n = nArray.length - this.width.getValue(); n < nArray.length; ++n) {
                nArray[n] = -7423346;
            }
            this.image.setRGB(0, 0, this.width.getValue(), this.height.getValue(), nArray, 0, this.width.getValue());
        }
        return this.image;
    }
}

