/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.util.Dictionary;
import java.util.Enumeration;
import pl.com.stream.echo.lib.graphic.IntHashtableEntry;
import pl.com.stream.echo.lib.graphic.IntHashtableEnumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntHashtable
extends Dictionary<Object, Object>
implements Cloneable {
    private int count;
    private final float loadFactor;
    private IntHashtableEntry[] table;
    private int threshold;

    public IntHashtable() {
        this(101, 0.75f);
    }

    public IntHashtable(int n) {
        this(n, 0.75f);
    }

    public IntHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new IntHashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public synchronized void clear() {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n = intHashtableEntryArray.length;
        while (--n >= 0) {
            intHashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            IntHashtable intHashtable = (IntHashtable)super.clone();
            intHashtable.table = new IntHashtableEntry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                intHashtable.table[n] = this.table[n] != null ? (IntHashtableEntry)this.table[n].clone() : null;
            }
            return intHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n = intHashtableEntryArray.length;
        while (n-- > 0) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n];
            while (intHashtableEntry != null) {
                if (intHashtableEntry.value.equals(object)) {
                    return true;
                }
                intHashtableEntry = intHashtableEntry.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int n) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n2 && intHashtableEntry.key == n) {
                return true;
            }
            intHashtableEntry = intHashtableEntry.next;
        }
        return false;
    }

    @Override
    public synchronized Enumeration<Object> elements() {
        return new IntHashtableEnumerator(this.table, false);
    }

    public synchronized Object get(int n) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n2 && intHashtableEntry.key == n) {
                return intHashtableEntry.value;
            }
            intHashtableEntry = intHashtableEntry.next;
        }
        return null;
    }

    @Override
    public Object get(Object object) {
        if (!(object instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer n = (Integer)object;
        int n2 = n;
        return this.get(n2);
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return new IntHashtableEnumerator(this.table, true);
    }

    @Override
    public synchronized Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n2 && intHashtableEntry.key == n) {
                Object object2 = intHashtableEntry.value;
                intHashtableEntry.value = object;
                return object2;
            }
            intHashtableEntry = intHashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(n, object);
        }
        intHashtableEntry = new IntHashtableEntry();
        intHashtableEntry.hash = n2;
        intHashtableEntry.key = n;
        intHashtableEntry.value = object;
        intHashtableEntry.next = intHashtableEntryArray[n3];
        intHashtableEntryArray[n3] = intHashtableEntry;
        ++this.count;
        return null;
    }

    @Override
    public Object put(Object object, Object object2) {
        if (!(object instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer n = (Integer)object;
        int n2 = n;
        return this.put(n2, object2);
    }

    public synchronized Object remove(int n) {
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        IntHashtableEntry intHashtableEntry2 = null;
        while (intHashtableEntry != null) {
            if (intHashtableEntry.hash == n2 && intHashtableEntry.key == n) {
                if (intHashtableEntry2 != null) {
                    intHashtableEntry2.next = intHashtableEntry.next;
                } else {
                    intHashtableEntryArray[n3] = intHashtableEntry.next;
                }
                --this.count;
                return intHashtableEntry.value;
            }
            intHashtableEntry2 = intHashtableEntry;
            intHashtableEntry = intHashtableEntry.next;
        }
        return null;
    }

    @Override
    public Object remove(Object object) {
        if (!(object instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer n = (Integer)object;
        int n2 = n;
        return this.remove(n2);
    }

    @Override
    public int size() {
        return this.count;
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Object> enumeration = this.keys();
        Enumeration<Object> enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    protected void rehash() {
        int n = this.table.length;
        IntHashtableEntry[] intHashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        IntHashtableEntry[] intHashtableEntryArray2 = new IntHashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = intHashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
            while (intHashtableEntry != null) {
                IntHashtableEntry intHashtableEntry2 = intHashtableEntry;
                intHashtableEntry = intHashtableEntry.next;
                int n4 = (intHashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                intHashtableEntry2.next = intHashtableEntryArray2[n4];
                intHashtableEntryArray2[n4] = intHashtableEntry2;
            }
        }
    }
}

