/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.imageio.ImageIO;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Extent;
import nextapp.echo.app.StreamImageReference;
import pl.com.stream.echo.lib.graphic.GifEncoder;

public class ImageIconReference
extends StreamImageReference {
    private static final long serialVersionUID = -5775338177705734853L;
    private final Extent width;
    private final Extent height;
    private int imageNumber;
    private final String contentType;
    private String resource;
    private final String id;
    private BufferedImage image;

    private static final String getContentType(String string) {
        return "image/gif";
    }

    public ImageIconReference(String string, Extent extent, Extent extent2, int n) {
        this(string, null, extent, extent2, n);
    }

    public ImageIconReference(String string, String string2, Extent extent, Extent extent2, int n) {
        this.resource = string.charAt(0) == '/' ? string.substring(1) : string;
        this.contentType = string2 == null ? ImageIconReference.getContentType(string) : string2;
        this.width = extent;
        this.height = extent2;
        this.imageNumber = n;
        this.id = ApplicationInstance.generateSystemId();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImageIconReference)) {
            return false;
        }
        ImageIconReference imageIconReference = (ImageIconReference)((Object)object);
        if (!(this.resource == imageIconReference.resource || this.resource != null && this.resource.equals(imageIconReference.resource))) {
            return false;
        }
        if (!(this.contentType == imageIconReference.contentType || this.contentType != null && this.contentType.equals(imageIconReference.contentType))) {
            return false;
        }
        if (!(this.width == imageIconReference.width || this.width != null && this.width.equals((Object)imageIconReference.width))) {
            return false;
        }
        return this.height == imageIconReference.height || this.height != null && this.height.equals((Object)imageIconReference.height);
    }

    public String getContentType() {
        return this.contentType;
    }

    public Extent getHeight() {
        return this.height;
    }

    public String getRenderId() {
        return this.id;
    }

    public String getResource() {
        return this.resource;
    }

    public Extent getWidth() {
        return this.width;
    }

    public int hashCode() {
        return this.resource == null ? 0 : this.resource.hashCode();
    }

    public void render(OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = this.prepareImage();
        GifEncoder gifEncoder = new GifEncoder();
        gifEncoder.encode(bufferedImage, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage prepareImage() throws IOException {
        if (this.image == null) {
            InputStream inputStream = null;
            try {
                if (this.resource != null && this.resource.equals(String.valueOf(this.height.getValue()))) {
                    BufferedImage bufferedImage = new BufferedImage(1, this.height.getValue(), 2);
                    return bufferedImage;
                }
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.resource);
                if (inputStream == null) {
                    throw new IllegalArgumentException("Specified resource does not exist: " + this.resource + ".");
                }
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                int n = 0;
                int n2 = 0;
                n = this.width == null ? new BigDecimal(bufferedImage.getWidth()).divide(new BigDecimal(2), RoundingMode.HALF_UP).intValue() : this.width.getValue();
                n2 = this.height == null ? bufferedImage.getHeight() : this.height.getValue();
                this.image = new BufferedImage(n, n2, 2);
                int n3 = 2;
                if (bufferedImage.getWidth() == bufferedImage.getHeight()) {
                    this.imageNumber = 0;
                    n3 = 1;
                }
                int n4 = bufferedImage.getWidth() / n3;
                int n5 = bufferedImage.getHeight();
                int n6 = new BigDecimal(n).divide(new BigDecimal(2), RoundingMode.HALF_UP).subtract(new BigDecimal(n4).divide(new BigDecimal(2), RoundingMode.HALF_UP)).intValue();
                int n7 = new BigDecimal(n2).divide(new BigDecimal(2), RoundingMode.HALF_UP).subtract(new BigDecimal(n5).divide(new BigDecimal(2), RoundingMode.HALF_UP)).intValue();
                int n8 = this.imageNumber * n4;
                int[] nArray = new int[n * n2];
                bufferedImage.getRGB(n8, 0, n4, n5, nArray, 0, n5);
                this.image.setRGB(n6, n7, n4, n5, nArray, 0, n5);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.image;
    }
}

