/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class GraphicUtil
implements Serializable {
    public static String BMP_EXTENSION = "gif";
    public static String DEFAULT_EXTENSION = "jpg";
    public static String GIF_EXTENSION = "gif";
    public static String JPEG_EXTENSION = "jpeg";
    public static String JPG_EXTENSION = "jpg";
    public static String PNG_EXTENSION = "png";
    private static final Logger log = Logger.getLogger(GraphicUtil.class);
    private static final long serialVersionUID = -8039753573008431338L;
    @ResourceContainer
    private Res res;
    private int thumbHeight;
    private int thumbWidth;

    public GraphicUtil(int n, int n2, int n3) {
        ResourceManager.bind((Object)this, (Locale)ClientLocale.getCurrent());
        this.thumbWidth = n;
        this.thumbHeight = n2;
    }

    public BufferedImage createThumbImage(Image image, int n, int n2, int n3, int n4) {
        double d = (double)n3 / (double)n4;
        double d2 = (double)n / (double)n2;
        if (d < d2) {
            n4 = (int)((double)n3 / d2);
        } else {
            n3 = (int)((double)n4 * d2);
        }
        log.debug((Object)MessageFormat.format(this.res.scalingImage, n + "x" + n2, n3 + "x" + n4));
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, n3, n4, null);
        graphics2D.dispose();
        graphics2D = null;
        image = null;
        return bufferedImage;
    }

    public void encodeImage(BufferedImage bufferedImage, OutputStream outputStream, String string) {
        try {
            this.thumbHeight = bufferedImage.getHeight();
            this.thumbWidth = bufferedImage.getWidth();
            if (string == null) {
                string = JPG_EXTENSION;
            }
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
            bufferedImage = null;
        }
        catch (IOException iOException) {
            log.error((Object)MessageFormat.format(this.res.encodingImageFailed, iOException.getMessage()), (Throwable)iOException);
        }
    }

    public ImageIcon readImage(File file) {
        return new ImageIcon(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readImage(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            log.error((Object)MessageFormat.format(this.res.copyingImageStreamFailed, iOException.getMessage()), (Throwable)iOException);
        }
        finally {
            try {
                inputStream.close();
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return byteArrayOutputStream.toByteArray();
    }

    public ImageIcon readImageIcon(InputStream inputStream) {
        return new ImageIcon(this.readImage(inputStream));
    }

    public void scaleImage(ImageIcon imageIcon, OutputStream outputStream, String string) {
        BufferedImage bufferedImage = this.createThumbImage(imageIcon.getImage(), imageIcon.getIconWidth(), imageIcon.getIconHeight(), this.thumbWidth, this.thumbHeight);
        this.encodeImage(bufferedImage, outputStream, string);
    }

    private class Res {
        private String copyingImageStreamFailed;
        private String encodingImageFailed;
        private String scalingImage;

        private Res() {
        }
    }
}

