/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.awt.Image;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import pl.com.stream.echo.lib.graphic.BaseImageEncoder;
import pl.com.stream.echo.lib.graphic.GifEncoderHashItem;
import pl.com.stream.echo.lib.graphic.IntHashtable;

class GifEncoderInternal
extends BaseImageEncoder {
    static final int BITS = 12;
    static final int EOF = -1;
    static final int HSIZE = 5003;
    int a_count;
    byte[] accum = new byte[256];
    boolean clear_flg = false;
    int clearCode;
    int[] codetab = new int[5003];
    IntHashtable colorHash;
    int countDown;
    int cur_accum = 0;
    int cur_bits = 0;
    int curx;
    int cury;
    int encodeWidth;
    int encodeHeight;
    int eofCode;
    int free_ent = 0;
    int g_init_bits;
    int hsize = 5003;
    int[] htab = new int[5003];
    private boolean interlace = false;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int n_bits;
    int passCount = 0;
    int[][] rgbPixels;
    int width;
    int height;

    public GifEncoderInternal(Image image, OutputStream outputStream) {
        super(image, outputStream);
    }

    public GifEncoderInternal(Image image, OutputStream outputStream, boolean bl) {
        super(image, outputStream);
        this.interlace = bl;
    }

    public void encode() throws IOException {
        super.encode();
    }

    void bumpPixel() {
        ++this.curx;
        if (this.curx == this.encodeWidth) {
            this.curx = 0;
            if (!this.interlace) {
                ++this.cury;
            } else {
                switch (this.passCount) {
                    case 0: {
                        this.cury += 8;
                        if (this.cury < this.encodeHeight) break;
                        ++this.passCount;
                        this.cury = 4;
                        break;
                    }
                    case 1: {
                        this.cury += 8;
                        if (this.cury < this.encodeHeight) break;
                        ++this.passCount;
                        this.cury = 2;
                        break;
                    }
                    case 2: {
                        this.cury += 4;
                        if (this.cury < this.encodeHeight) break;
                        ++this.passCount;
                        this.cury = 1;
                        break;
                    }
                    case 3: {
                        this.cury += 2;
                    }
                }
            }
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte by, OutputStream outputStream) throws IOException {
        this.accum[this.a_count++] = by;
        if (this.a_count >= 254) {
            this.flush_char(outputStream);
        }
    }

    void cl_block(OutputStream outputStream) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.clearCode + 2;
        this.clear_flg = true;
        this.output(this.clearCode, outputStream);
    }

    void cl_hash(int n) {
        for (int i = 0; i < n; ++i) {
            this.htab[i] = -1;
        }
    }

    void compress(int n, OutputStream outputStream) throws IOException {
        int n2;
        int n3;
        this.g_init_bits = n;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.maxcode(this.n_bits);
        this.clearCode = 1 << n - 1;
        this.eofCode = this.clearCode + 1;
        this.free_ent = this.clearCode + 2;
        this.char_init();
        int n4 = this.nextPixel();
        int n5 = 0;
        for (n3 = this.hsize; n3 < 65536; n3 *= 2) {
            ++n5;
        }
        n5 = 8 - n5;
        int n6 = this.hsize;
        this.cl_hash(n6);
        this.output(this.clearCode, outputStream);
        block1: while ((n2 = this.nextPixel()) != -1) {
            int n7 = n2 << n5 ^ n4;
            n3 = (n2 << this.maxbits) + n4;
            if (this.htab[n7] == n3) {
                n4 = this.codetab[n7];
                continue;
            }
            if (this.htab[n7] >= 0) {
                int n8 = n6 - n7;
                if (n7 == 0) {
                    n8 = 1;
                }
                do {
                    if ((n7 -= n8) < 0) {
                        n7 += n6;
                    }
                    if (this.htab[n7] != n3) continue;
                    n4 = this.codetab[n7];
                    continue block1;
                } while (this.htab[n7] >= 0);
            }
            this.output(n4, outputStream);
            n4 = n2;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[n7] = n3;
                continue;
            }
            this.cl_block(outputStream);
        }
        this.output(n4, outputStream);
        this.output(this.eofCode, outputStream);
    }

    void encodeDone() throws IOException {
        Object object;
        int n;
        int n2;
        int n3 = -1;
        int n4 = -1;
        this.colorHash = new IntHashtable();
        int n5 = 0;
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                boolean bl;
                int n6 = this.rgbPixels[n2][n];
                boolean bl2 = bl = n6 >>> 24 < 128;
                if (bl) {
                    if (n3 < 0) {
                        n3 = n5;
                        n4 = n6;
                    } else if (n6 != n4) {
                        this.rgbPixels[n2][n] = n6 = n4;
                    }
                }
                if ((object = (Object)((GifEncoderHashItem)this.colorHash.get(n6))) == null) {
                    if (n5 >= 256) {
                        throw new IOException("too many colors for a GIF");
                    }
                    object = new GifEncoderHashItem(n6, 1, n5, bl);
                    ++n5;
                    this.colorHash.put(n6, object);
                    continue;
                }
                ++object.count;
            }
        }
        n2 = n5 <= 2 ? 1 : (n5 <= 4 ? 2 : (n5 <= 16 ? 4 : 8));
        n = 1 << n2;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        object = new byte[n];
        Enumeration<Object> enumeration = this.colorHash.elements();
        while (enumeration.hasMoreElements()) {
            GifEncoderHashItem gifEncoderHashItem = (GifEncoderHashItem)enumeration.nextElement();
            byArray[gifEncoderHashItem.index] = (byte)(gifEncoderHashItem.rgb >> 16 & 0xFF);
            byArray2[gifEncoderHashItem.index] = (byte)(gifEncoderHashItem.rgb >> 8 & 0xFF);
            object[gifEncoderHashItem.index] = (byte)(gifEncoderHashItem.rgb & 0xFF);
        }
        this.gifEncode(this.out, this.width, this.height, (byte)0, n3, n2, byArray, byArray2, (byte[])object);
    }

    void encodePixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws IOException {
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(nArray, i * n6 + n5, this.rgbPixels[n2 + i], n, n3);
        }
    }

    void encodeStart(int n, int n2) throws IOException {
        this.width = n;
        this.height = n2;
        this.rgbPixels = new int[n2][n];
    }

    void flush_char(OutputStream outputStream) throws IOException {
        if (this.a_count > 0) {
            outputStream.write(this.a_count);
            outputStream.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }

    byte getPixel(int n, int n2) throws IOException {
        GifEncoderHashItem gifEncoderHashItem = (GifEncoderHashItem)this.colorHash.get(this.rgbPixels[n2][n]);
        if (gifEncoderHashItem == null) {
            throw new IOException("color not found");
        }
        return (byte)gifEncoderHashItem.index;
    }

    void gifEncode(OutputStream outputStream, int n, int n2, byte by, int n3, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        this.encodeWidth = n;
        this.encodeHeight = n2;
        int n5 = 1 << n4;
        int n6 = 0;
        int n7 = 0;
        this.countDown = n * n2;
        this.passCount = 0;
        int n8 = n4 <= 1 ? 2 : n4;
        this.curx = 0;
        this.cury = 0;
        this.writeString(outputStream, "GIF89a");
        this.putWord(n, outputStream);
        this.putWord(n2, outputStream);
        byte by2 = -128;
        by2 = (byte)(by2 | 0x70);
        by2 = (byte)(by2 | (byte)(n4 - 1));
        this.putByte(by2, outputStream);
        this.putByte(by, outputStream);
        this.putByte((byte)0, outputStream);
        for (int i = 0; i < n5; ++i) {
            this.putByte(byArray[i], outputStream);
            this.putByte(byArray2[i], outputStream);
            this.putByte(byArray3[i], outputStream);
        }
        if (n3 != -1) {
            this.putByte((byte)33, outputStream);
            this.putByte((byte)-7, outputStream);
            this.putByte((byte)4, outputStream);
            this.putByte((byte)1, outputStream);
            this.putByte((byte)0, outputStream);
            this.putByte((byte)0, outputStream);
            this.putByte((byte)n3, outputStream);
            this.putByte((byte)0, outputStream);
        }
        this.putByte((byte)44, outputStream);
        this.putWord(n7, outputStream);
        this.putWord(n6, outputStream);
        this.putWord(n, outputStream);
        this.putWord(n2, outputStream);
        if (this.interlace) {
            this.putByte((byte)64, outputStream);
        } else {
            this.putByte((byte)0, outputStream);
        }
        this.putByte((byte)n8, outputStream);
        this.compress(n8 + 1, outputStream);
        this.putByte((byte)0, outputStream);
        this.putByte((byte)59, outputStream);
    }

    int maxcode(int n) {
        return (1 << n) - 1;
    }

    int nextPixel() throws IOException {
        if (this.countDown == 0) {
            return -1;
        }
        --this.countDown;
        byte by = this.getPixel(this.curx, this.cury);
        this.bumpPixel();
        return by & 0xFF;
    }

    void output(int n, OutputStream outputStream) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= n << this.cur_bits) : n;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.maxcode(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.maxcode(this.n_bits);
            }
        }
        if (n == this.eofCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outputStream);
        }
    }

    void putByte(byte by, OutputStream outputStream) throws IOException {
        outputStream.write(by);
    }

    void putWord(int n, OutputStream outputStream) throws IOException {
        this.putByte((byte)(n & 0xFF), outputStream);
        this.putByte((byte)(n >> 8 & 0xFF), outputStream);
    }

    void writeString(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = string.getBytes();
        outputStream.write(byArray);
    }
}

