/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.graphic.ScalableImageReference;
import pl.com.stream.echo.lib.util.filter.FileNameFilter;
import pl.com.stream.echo.lib.util.filter.FileNameFilterProvider;

public class FileImageReference
extends ScalableImageReference {
    private static final Logger log = Logger.getLogger(FileImageReference.class);
    private static final long serialVersionUID = 2624150053185950572L;
    private final File file;

    public FileImageReference(File file) {
        this(file, null, null, null);
    }

    public FileImageReference(File file, Integer n, Integer n2, Integer n3) {
        super(n, n2, n3);
        this.file = file;
        String string = this.getExtension(file.getAbsolutePath());
        String string2 = this.getContentType(string);
        this.setExtension(string);
        this.setContentType(string2);
    }

    public FileImageReference(String string) {
        this(new File(string), null, null, null);
    }

    public FileImageReference(String string, Integer n, Integer n2, Integer n3) {
        this(new File(string), n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageIcon readFromFile(OutputStream outputStream) {
        ImageIcon imageIcon = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.file);
            if (outputStream != null) {
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
            } else {
                imageIcon = this.getGraphicUtil().readImageIcon(fileInputStream);
            }
        }
        catch (IOException iOException) {
            log.error((Object)("Can not render image from file: " + this.file.getAbsolutePath() + " - " + iOException.getMessage()), (Throwable)iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return imageIcon;
    }

    protected String loadId() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getThumbWidth() != null && this.getThumbHeight() != null) {
            stringBuffer.append(this.getThumbWidth()).append("x").append(this.getThumbHeight()).append("_");
        }
        stringBuffer.append(this.file.getName());
        FileNameFilter fileNameFilter = FileNameFilterProvider.getInstance().getDefaultFilter();
        return fileNameFilter.filter(stringBuffer.toString());
    }

    protected ImageIcon loadImageIcon() {
        return this.readFromFile(null);
    }

    protected void renderStream(OutputStream outputStream) {
        this.readFromFile(outputStream);
    }
}

