/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import pl.com.stream.echo.lib.graphic.ScalableImageReference;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.echo.lib.util.filter.FileNameFilter;
import pl.com.stream.echo.lib.util.filter.FileNameFilterProvider;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateSessionProvider;

public class DatabaseImageReference
extends ScalableImageReference {
    private static final Logger log = Logger.getLogger(DatabaseImageReference.class);
    private static final long serialVersionUID = 6002457606430509824L;
    @ResourceContainer
    private Res res;
    private HibernateSessionProvider sessionProvider;
    private final String sqlIconQuery;
    private final String sqlNameQuery;

    public DatabaseImageReference(String string, String string2, Integer n, Integer n2, Integer n3) {
        super(n, n2, n3);
        ResourceManager.bind((Object)((Object)this), (Locale)ClientLocale.getCurrent());
        this.sqlIconQuery = string;
        this.sqlNameQuery = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageIcon readFromDatabase(OutputStream outputStream) {
        Session session = null;
        ImageIcon imageIcon = null;
        try {
            ResultSet resultSet;
            Statement statement;
            block25: {
                log.debug((Object)MessageFormat.format(this.res.gettingImage, this.sqlIconQuery));
                this.sessionProvider = new HibernateSessionProvider();
                session = this.sessionProvider.getSession();
                session.beginTransaction();
                statement = null;
                resultSet = null;
                statement = session.connection().createStatement();
                resultSet = statement.executeQuery(this.sqlIconQuery);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                if (!resultSet.next()) break block25;
                block17: for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    switch (resultSetMetaData.getColumnType(i)) {
                        case -4: 
                        case 2004: {
                            InputStream inputStream = resultSet.getBinaryStream(i);
                            if (inputStream == null) continue block17;
                            try {
                                if (outputStream != null) {
                                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                                } else {
                                    imageIcon = this.getGraphicUtil().readImageIcon(inputStream);
                                }
                            }
                            finally {
                                try {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                                catch (IOException iOException) {}
                            }
                            inputStream = null;
                            continue block17;
                        }
                    }
                }
            }
            resultSet.close();
            statement.close();
            if (session != null && session.isOpen() && session.getTransaction().isActive()) {
                session.getTransaction().commit();
            }
        }
        catch (HibernateException hibernateException) {
            log.error((Object)MessageFormat.format(this.res.gettingImageFailed, hibernateException.getMessage()), (Throwable)hibernateException);
            if (session != null && session.isOpen() && session.getTransaction().isActive()) {
                session.getTransaction().rollback();
            }
        }
        catch (Exception exception) {
            log.error((Object)exception);
            if (session != null && session.isOpen() && session.getTransaction().isActive()) {
                session.getTransaction().rollback();
            }
        }
        finally {
            this.sessionProvider.closeSession();
        }
        session = null;
        return imageIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readIdFromDatabase() {
        Session session = null;
        String string = null;
        try {
            log.debug((Object)MessageFormat.format(this.res.gettingName, this.sqlNameQuery));
            this.sessionProvider = new HibernateSessionProvider();
            session = this.sessionProvider.getSession();
            session.beginTransaction();
            Statement statement = null;
            ResultSet resultSet = null;
            statement = session.connection().createStatement();
            resultSet = statement.executeQuery(this.sqlNameQuery);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSet.next()) {
                block10: for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                    switch (resultSetMetaData.getColumnType(i)) {
                        case 12: {
                            String string2 = resultSet.getString(i);
                            String string3 = this.getExtension(string2);
                            String string4 = this.getContentType(string3);
                            this.setExtension(string3);
                            this.setContentType(string4);
                            StringBuffer stringBuffer = new StringBuffer();
                            if (this.getThumbWidth() != null && this.getThumbHeight() != null) {
                                stringBuffer.append(this.getThumbWidth()).append("x").append(this.getThumbHeight()).append("_");
                            }
                            stringBuffer.append(string2);
                            string = stringBuffer.toString();
                            continue block10;
                        }
                    }
                }
            }
            resultSet.close();
            statement.close();
            if (session != null && session.isOpen() && session.getTransaction().isActive()) {
                session.getTransaction().commit();
            }
        }
        catch (HibernateException hibernateException) {
            log.error((Object)MessageFormat.format(this.res.gettingNameFailed, hibernateException.getMessage()), (Throwable)hibernateException);
            if (session != null && session.isOpen() && session.getTransaction().isActive()) {
                session.getTransaction().rollback();
            }
        }
        catch (Exception exception) {
            log.error((Object)exception);
            if (session != null && session.isOpen() && session.getTransaction().isActive()) {
                session.getTransaction().rollback();
            }
        }
        finally {
            this.sessionProvider.closeSession();
        }
        session = null;
        return string;
    }

    protected String loadId() {
        FileNameFilter fileNameFilter = FileNameFilterProvider.getInstance().getDefaultFilter();
        return fileNameFilter.filter(this.readIdFromDatabase());
    }

    protected ImageIcon loadImageIcon() {
        return this.readFromDatabase(null);
    }

    protected void renderStream(OutputStream outputStream) {
        this.readFromDatabase(outputStream);
    }

    private class Res {
        private String gettingImage;
        private String gettingImageFailed;
        private String gettingName;
        private String gettingNameFailed;

        private Res() {
        }
    }
}

