/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ButtonImage
extends BufferedImage {
    private final ResizeType resizeType;
    private final BufferedImage simpleImage;

    public ButtonImage(BufferedImage bufferedImage, int n, int n2, BackgroundImageType backgroundImageType) {
        super(n, n2, 2);
        this.simpleImage = this.getSimpleSrcImage(bufferedImage, backgroundImageType);
        this.resizeType = this.getResizeType();
        this.prepareImage();
    }

    private ResizeType getResizeType() {
        int n = this.simpleImage.getHeight();
        int n2 = this.simpleImage.getWidth();
        if (this.getWidth() == n2 && this.getHeight() == n) {
            return ResizeType.none;
        }
        if (this.getWidth() > n2 && this.getHeight() == n) {
            return ResizeType.horizontal;
        }
        if (this.getWidth() == n2 && this.getHeight() > n) {
            return ResizeType.vertical;
        }
        if (this.getWidth() > n2 && this.getHeight() > n) {
            return ResizeType.both;
        }
        return ResizeType.horizontal;
    }

    private BufferedImage getSimpleSrcImage(BufferedImage bufferedImage, BackgroundImageType backgroundImageType) {
        int n = bufferedImage.getHeight();
        int n2 = new BigDecimal(bufferedImage.getWidth()).divide(new BigDecimal(4), RoundingMode.UP).intValue();
        BufferedImage bufferedImage2 = new BufferedImage(n2, n, 2);
        int[] nArray = new int[n2 * n];
        switch (backgroundImageType) {
            case normal: {
                bufferedImage.getRGB(0, 0, n2, n, nArray, 0, n2);
                bufferedImage2.setRGB(0, 0, n2, n, nArray, 0, n2);
                break;
            }
            case rollover: {
                bufferedImage.getRGB(n2, 0, n2, n, nArray, 0, n2);
                bufferedImage2.setRGB(0, 0, n2, n, nArray, 0, n2);
                break;
            }
            case pressed: {
                bufferedImage.getRGB(2 * n2, 0, n2, n, nArray, 0, n2);
                bufferedImage2.setRGB(0, 0, n2, n, nArray, 0, n2);
                break;
            }
            case disabled: {
                bufferedImage.getRGB(3 * n2, 0, n2, n, nArray, 0, n2);
                bufferedImage2.setRGB(0, 0, n2, n, nArray, 0, n2);
            }
        }
        return bufferedImage2;
    }

    private void prepareImage() {
        switch (this.resizeType) {
            case none: {
                int[] nArray = new int[this.simpleImage.getWidth() * this.simpleImage.getHeight()];
                this.simpleImage.getRGB(0, 0, this.simpleImage.getWidth(), this.simpleImage.getHeight(), nArray, 0, this.simpleImage.getWidth());
                this.setRGB(0, 0, this.simpleImage.getWidth(), this.simpleImage.getHeight(), nArray, 0, this.simpleImage.getWidth());
                break;
            }
            case horizontal: {
                this.resizeHorizontalyAndInsert(this.simpleImage);
                break;
            }
            case vertical: {
                this.resizeVerticalyAndInsert(this.simpleImage);
                break;
            }
            case both: {
                this.resizeVerticalyAndInsert(this.simpleImage);
                this.resizeHorizontalyAndInsert(this);
            }
        }
    }

    private void resizeHorizontalyAndInsert(BufferedImage bufferedImage) {
        int n = new BigDecimal(this.simpleImage.getWidth()).divide(new BigDecimal(2), RoundingMode.UP).intValue();
        int n2 = new BigDecimal(this.simpleImage.getWidth()).divide(new BigDecimal(4), RoundingMode.UP).intValue();
        int n3 = new BigDecimal(this.simpleImage.getWidth()).divide(new BigDecimal(2), RoundingMode.DOWN).intValue();
        int[] nArray = bufferedImage.getRGB(0, 0, n, bufferedImage.getHeight(), null, 0, n);
        int[] nArray2 = bufferedImage.getRGB(n2, 0, n, bufferedImage.getHeight(), null, 0, n);
        int[] nArray3 = bufferedImage.getRGB(n3, 0, n, bufferedImage.getHeight(), null, 0, n);
        this.setRGB(0, 0, n, bufferedImage.getHeight(), nArray, 0, n);
        for (int i = n; i < this.getWidth() - n; i += n) {
            this.setRGB(i, 0, n, bufferedImage.getHeight(), nArray2, 0, n);
        }
        this.setRGB(this.getWidth() - n, 0, n, bufferedImage.getHeight(), nArray3, 0, n);
    }

    private void resizeVerticalyAndInsert(BufferedImage bufferedImage) {
        int n = new BigDecimal(this.simpleImage.getHeight()).divide(new BigDecimal(2), RoundingMode.DOWN).intValue();
        int n2 = new BigDecimal(this.simpleImage.getHeight()).divide(new BigDecimal(2), RoundingMode.DOWN).subtract(new BigDecimal(2)).intValue();
        int[] nArray = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), n, null, 0, bufferedImage.getWidth());
        int[] nArray2 = bufferedImage.getRGB(0, n2, bufferedImage.getWidth(), 2, null, 0, bufferedImage.getWidth());
        int[] nArray3 = bufferedImage.getRGB(0, n, bufferedImage.getWidth(), n, null, 0, bufferedImage.getWidth());
        this.setRGB(0, 0, bufferedImage.getWidth(), n, nArray, 0, bufferedImage.getWidth());
        for (int i = n2; i < this.getHeight() - n; i += 2) {
            this.setRGB(0, i, bufferedImage.getWidth(), 2, nArray2, 0, bufferedImage.getWidth());
        }
        this.setRGB(0, this.getHeight() - n, bufferedImage.getWidth(), n, nArray3, 0, bufferedImage.getWidth());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ResizeType {
        both,
        horizontal,
        none,
        vertical;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BackgroundImageType {
        disabled,
        normal,
        pressed,
        rollover;

    }
}

