/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Extent;
import nextapp.echo.app.StreamImageReference;
import pl.com.stream.echo.lib.graphic.ButtonImage;

public class ButtonBackgroundImagesReference
extends StreamImageReference {
    private static final long serialVersionUID = 5395537198871197415L;
    private final String id;
    private ButtonImage image;
    private final ButtonImage.BackgroundImageType imageType;
    private final Extent newHeight;
    private final Extent newWidth;
    private final String resource;

    public ButtonBackgroundImagesReference(String string, int n, int n2, ButtonImage.BackgroundImageType backgroundImageType) {
        this.resource = string;
        this.newWidth = new Extent(n);
        this.newHeight = new Extent(n2);
        this.imageType = backgroundImageType;
        this.id = ApplicationInstance.generateSystemId();
    }

    public String getContentType() {
        return "image/png";
    }

    public Extent getHeight() {
        return this.newHeight;
    }

    public String getRenderId() {
        return this.id;
    }

    public Extent getWidth() {
        return this.newWidth;
    }

    public void render(OutputStream outputStream) throws IOException {
        ImageIO.write((RenderedImage)this.prepareImage(), "PNG", outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage prepareImage() throws IOException {
        if (this.image == null) {
            InputStream inputStream = null;
            try {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.resource);
                if (inputStream == null) {
                    throw new IllegalArgumentException("Specified resource does not exist: " + this.resource + ".");
                }
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                this.image = new ButtonImage(bufferedImage, this.newWidth.getValue(), this.newHeight.getValue(), this.imageType);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.image;
    }
}

