/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Extent;
import nextapp.echo.app.StreamImageReference;
import nextapp.echo.webcontainer.ContentType;

public class BufferedImageReference
extends StreamImageReference {
    private static final long serialVersionUID = 5943787209878552281L;
    private final BufferedImage bi;
    private final String id;

    public BufferedImageReference(BufferedImage bufferedImage) {
        this.bi = bufferedImage;
        this.id = ApplicationInstance.generateSystemId();
    }

    public String getContentType() {
        return ContentType.IMAGE_PNG.getMimeType();
    }

    public Extent getHeight() {
        return new Extent(this.bi.getHeight());
    }

    public String getRenderId() {
        return this.id;
    }

    public Extent getWidth() {
        return new Extent(this.bi.getWidth());
    }

    public void render(OutputStream outputStream) throws IOException {
        ImageIO.write((RenderedImage)this.bi, "PNG", outputStream);
    }
}

