/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.graphic;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Extent;
import nextapp.echo.app.StreamImageReference;

public class BorderImageReference
extends StreamImageReference {
    private static final long serialVersionUID = -2280333724842140807L;
    private final String id;
    private final BufferedImage image;

    public BorderImageReference(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.id = ApplicationInstance.generateSystemId();
    }

    public String getContentType() {
        return "image/png";
    }

    public Extent getHeight() {
        return new Extent(this.image.getHeight());
    }

    public String getRenderId() {
        return this.id;
    }

    public Extent getWidth() {
        return new Extent(this.image.getWidth());
    }

    public void render(OutputStream outputStream) throws IOException {
        ImageIO.write((RenderedImage)this.image, "PNG", outputStream);
    }
}

