/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.exception;

import java.sql.SQLException;
import org.apache.commons.mail.EmailException;
import org.hibernate.HibernateException;
import org.hibernate.exception.GenericJDBCException;

public class MessageException
extends Exception {
    private static final long serialVersionUID = 3363569445427796285L;
    private String title;
    private String message;

    public MessageException(String string, String string2) {
        this.title = string;
        this.message = string2;
    }

    public MessageException(String string, Throwable throwable) {
        super(string, throwable);
        this.message = string;
        if (throwable instanceof EmailException) {
            EmailException emailException = (EmailException)throwable;
            this.title = "B\u0142\u0105d EmailException";
            this.message = emailException.getMessage();
        } else if (throwable instanceof GenericJDBCException) {
            GenericJDBCException genericJDBCException = (GenericJDBCException)throwable;
            String string2 = genericJDBCException.getCause().getMessage();
            switch (genericJDBCException.getErrorCode()) {
                case 335544721: {
                    this.title = "B\u0142\u0105d podczas \u0142\u0105czenia z baz\u0105";
                    this.message = "Nie mo\u017cna po\u0142\u0105czy\u0107 si\u0119 ze zdalnym serwerem.";
                    break;
                }
                case 335544344: {
                    this.title = "B\u0142\u0105d podczas \u0142\u0105czenia z baz\u0105";
                    this.message = "Nie mo\u017cna odczyta\u0107 pliku bazy danych.";
                    break;
                }
                case 335544472: {
                    this.title = "B\u0142\u0105d podczas \u0142\u0105czenia z baz\u0105";
                    this.message = "B\u0142\u0119dny login lub has\u0142o.";
                    break;
                }
                case 0x14000010: {
                    this.title = "B\u0142\u0105d bazy danych: ";
                    this.message = "Blokada deadlock. W tym samym momencie inna osoba aktualizowa\u0142a ten sam wiersz w bazie danych. Spr\u00f3buj ponownie zapisa\u0107 dane.";
                    break;
                }
                default: {
                    this.title = "B\u0142\u0105d bazy danych";
                    this.message = string2;
                    break;
                }
            }
        } else if (throwable instanceof HibernateException) {
            HibernateException hibernateException = (HibernateException)throwable;
            this.title = "B\u0142\u0105d HibernateException";
            this.message = hibernateException.getMessage().equals("Illegal attempt to associate a collection with two open sessions") ? "Pr\u00f3ba skojarzenia kolekcji z dwoma otwartymi sesjami" : hibernateException.getMessage();
        } else if (throwable instanceof MessageException) {
            MessageException messageException = (MessageException)throwable;
            this.title = messageException.getTitle();
            this.message = messageException.getMessage();
        } else if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            switch (sQLException.getErrorCode()) {
                case 335544721: {
                    this.title = "B\u0142\u0105d podczas \u0142\u0105czenia z baz\u0105";
                    this.message = "Nie mo\u017cna po\u0142\u0105czy\u0107 si\u0119 ze zdalnym serwerem.";
                    break;
                }
                case 335544344: {
                    this.title = "B\u0142\u0105d podczas \u0142\u0105czenia z baz\u0105";
                    this.message = "Nie mo\u017cna odczyta\u0107 pliku bazy danych.";
                    break;
                }
                case 335544472: {
                    this.title = "B\u0142\u0105d podczas \u0142\u0105czenia z baz\u0105";
                    this.message = "B\u0142\u0119dny login lub has\u0142o.";
                    break;
                }
                default: {
                    this.title = "B\u0142\u0105d bazy danych";
                    this.message = sQLException.getMessage();
                    break;
                }
            }
        } else {
            this.title = "B\u0142\u0105d \"" + throwable.getClass().getSimpleName() + "\"";
        }
    }

    public MessageException(Throwable throwable) {
        this(throwable.getMessage(), throwable);
    }

    public String getMessage() {
        return this.message;
    }

    public String getTitle() {
        return this.title;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }
}

