/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.database.criterion;

import java.util.ArrayList;
import java.util.HashMap;
import pl.com.stream.echo.lib.database.criterion.SimpleExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Criterion {
    private ArrayList<SimpleExpression> expressList;
    private HashMap<SimpleExpression, ExpressionOperator> expressionMap;
    private ArrayList<Criterion> criterionList;
    private HashMap<Criterion, ExpressionOperator> criterionMap;

    public Criterion(Criterion criterion) {
        if (criterion != null) {
            this.getCriterionList().add(criterion);
        }
    }

    public Criterion(SimpleExpression simpleExpression) {
        this.getExpressionList().add(simpleExpression);
    }

    public Criterion and(SimpleExpression simpleExpression) {
        this.addExpression(simpleExpression, ExpressionOperator.AND);
        return this;
    }

    public Criterion andCriterion(Criterion criterion) {
        this.addCriterion(criterion, ExpressionOperator.AND);
        return this;
    }

    public Criterion or(SimpleExpression simpleExpression) {
        this.addExpression(simpleExpression, ExpressionOperator.OR);
        return this;
    }

    public Criterion orCriterion(Criterion criterion) {
        this.addCriterion(criterion, ExpressionOperator.OR);
        return this;
    }

    public String toSqlString() {
        return this.toSqlString(false, true, 0);
    }

    public String toSqlString(boolean bl, boolean bl2, int n) {
        ExpressionOperator expressionOperator;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getExpressionList().size() > 0) {
            stringBuffer.append("(");
        }
        for (int i = 0; i < this.getExpressionList().size(); ++i) {
            SimpleExpression object = this.getExpressionList().get(i);
            expressionOperator = this.getExpressionMap().get(object);
            if (expressionOperator != null) {
                stringBuffer.append(" ").append((Object)expressionOperator).append(" ");
            }
            if (object == null) continue;
            stringBuffer.append(object.toSqlString());
        }
        if (this.getExpressionList().size() > 0) {
            stringBuffer.append(")");
        }
        for (Criterion criterion : this.getCriterionList()) {
            expressionOperator = this.getCriterionMap().get(criterion);
            if (expressionOperator != null) {
                stringBuffer.append(" ").append((Object)expressionOperator).append(" ");
            }
            if (bl) {
                stringBuffer.append("\n\t");
            }
            stringBuffer.append(criterion.toSqlString(bl, false, n));
        }
        return stringBuffer.toString();
    }

    private void addCriterion(Criterion criterion, ExpressionOperator expressionOperator) {
        if (criterion != null) {
            this.getCriterionList().add(criterion);
            this.getCriterionMap().put(criterion, expressionOperator);
        }
    }

    private void addExpression(SimpleExpression simpleExpression, ExpressionOperator expressionOperator) {
        if (simpleExpression != null) {
            this.getExpressionList().add(simpleExpression);
            this.getExpressionMap().put(simpleExpression, expressionOperator);
        }
    }

    private ArrayList<Criterion> getCriterionList() {
        if (this.criterionList == null) {
            this.criterionList = new ArrayList();
        }
        return this.criterionList;
    }

    private HashMap<Criterion, ExpressionOperator> getCriterionMap() {
        if (this.criterionMap == null) {
            this.criterionMap = new HashMap();
        }
        return this.criterionMap;
    }

    private ArrayList<SimpleExpression> getExpressionList() {
        if (this.expressList == null) {
            this.expressList = new ArrayList();
        }
        return this.expressList;
    }

    private HashMap<SimpleExpression, ExpressionOperator> getExpressionMap() {
        if (this.expressionMap == null) {
            this.expressionMap = new HashMap();
        }
        return this.expressionMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpressionOperator {
        AND,
        OR;

    }
}

