/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.window.content;

import java.util.List;
import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.FillImageBorder;
import nextapp.echo.app.Insets;
import nextapp.echo.app.Row;
import nextapp.echo.app.SplitPane;
import nextapp.echo.app.button.ButtonGroup;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.extras.app.BorderPane;
import pl.com.stream.echo.lib.component.Panel;
import pl.com.stream.echo.lib.component.StrCheckBox;
import pl.com.stream.echo.lib.component.StrRadioButton;
import pl.com.stream.echo.lib.component.model.SortButtonColumnsModel;
import pl.com.stream.echo.lib.component.window.content.model.SortButtonsColumn;
import pl.com.stream.echo.lib.type.TSelectedTableColumnOrder;
import pl.com.stream.echo.lib.type.TSelectedTableColumnOrderList;
import pl.com.stream.echo.lib.type.sql.TSqlOrderByObject;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortPane
extends Panel {
    private static final long serialVersionUID = 8010988944372301749L;
    private final ActionListener actionProcessor = new ActionListener(){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() != null) {
                if (actionEvent.getActionCommand().equals("simpleColumn")) {
                    SortPane.this.sortButtonsColumn.setSingleColumn(SortPane.this.simpleColumnCheckBox.isSelected());
                }
                if (actionEvent.getActionCommand().equals("orderType")) {
                    SortPane.this.orderType = SortPane.this.ascRadioButton.isSelected() ? TSqlOrderByObject.OrderTypes.ASC : TSqlOrderByObject.OrderTypes.DESC;
                    SortPane.this.sortButtonsColumn.setOrderType(SortPane.this.orderType);
                }
            }
        }
    };
    private StrRadioButton ascRadioButton;
    private StrRadioButton descRadioButton;
    private TSqlOrderByObject.OrderTypes orderType;
    private final ButtonGroup orderTypeButtonGroup;
    @ResourceContainer
    private Res res;
    private StrCheckBox simpleColumnCheckBox;
    private final boolean singleColumn = false;
    private SortButtonsColumn sortButtonsColumn;

    public SortPane() {
        this.initComponents();
        this.initResources();
        this.initListeners();
        this.orderTypeButtonGroup = new ButtonGroup();
        this.ascRadioButton.setGroup(this.orderTypeButtonGroup);
        this.descRadioButton.setGroup(this.orderTypeButtonGroup);
    }

    public TSelectedTableColumnOrderList getSelectedColumnsOrder() {
        return this.sortButtonsColumn.getSelectedColumnsOrder();
    }

    public void setColumns(List<?> list, TSelectedTableColumnOrderList tSelectedTableColumnOrderList) {
        this.sortButtonsColumn.setModel(new SortButtonColumnsModel(list, tSelectedTableColumnOrderList));
        this.sortButtonsColumn.setSingleColumn(false);
        this.orderType = tSelectedTableColumnOrderList.size() > 0 ? ((TSelectedTableColumnOrder)tSelectedTableColumnOrderList.get(0)).getOrderType() : TSqlOrderByObject.OrderTypes.ASC;
        this.sortButtonsColumn.setOrderType(this.orderType);
        switch (this.orderType) {
            case ASC: {
                this.ascRadioButton.setSelected(true);
                break;
            }
            case DESC: {
                this.descRadioButton.setSelected(true);
            }
        }
    }

    private void initComponents() {
        SplitPane splitPane = new SplitPane();
        splitPane.setSeparatorPosition(new Extent(23, 1));
        splitPane.setOrientation(5);
        this.add((Component)splitPane);
        Row row = new Row();
        row.setCellSpacing(new Extent(4, 1));
        splitPane.add((Component)row);
        this.ascRadioButton = new StrRadioButton();
        this.ascRadioButton.setStyleName("RadioButtonStyle");
        this.ascRadioButton.setLineWrap(false);
        this.ascRadioButton.setText("ascending");
        this.ascRadioButton.setSelected(true);
        this.ascRadioButton.setActionCommand("orderType");
        row.add((Component)this.ascRadioButton);
        this.descRadioButton = new StrRadioButton();
        this.descRadioButton.setStyleName("RadioButtonStyle");
        this.descRadioButton.setLineWrap(false);
        this.descRadioButton.setText("descending");
        this.descRadioButton.setActionCommand("orderType");
        row.add((Component)this.descRadioButton);
        this.simpleColumnCheckBox = new StrCheckBox();
        this.simpleColumnCheckBox.setStyleName("CheckBoxStyle");
        this.simpleColumnCheckBox.setText("simpleColumn");
        this.simpleColumnCheckBox.setActionCommand("simpleColumn");
        row.add((Component)this.simpleColumnCheckBox);
        BorderPane borderPane = new BorderPane();
        FillImageBorder fillImageBorder = new FillImageBorder(null, new Insets(new Extent(2, 1)), new Insets(new Extent(2, 1)));
        borderPane.setBorder(fillImageBorder);
        splitPane.add((Component)borderPane);
        BorderPane borderPane2 = new BorderPane();
        borderPane2.setStyleName("BorderPaneStyle");
        borderPane2.setBackground(new Color(16184818));
        FillImageBorder fillImageBorder2 = new FillImageBorder(new Color(0xC0C0C0), new Insets(new Extent(1, 1)), new Insets(new Extent(1, 1)));
        borderPane2.setBorder(fillImageBorder2);
        borderPane.add((Component)borderPane2);
        this.sortButtonsColumn = new SortButtonsColumn();
        this.sortButtonsColumn.setInsets(new Insets(new Extent(20, 1), new Extent(25, 1), new Extent(0, 1), new Extent(0, 1)));
        borderPane2.add((Component)this.sortButtonsColumn);
    }

    private void initListeners() {
        this.simpleColumnCheckBox.addActionListener(this.actionProcessor);
        this.ascRadioButton.addActionListener(this.actionProcessor);
        this.descRadioButton.addActionListener(this.actionProcessor);
    }

    private void initResources() {
        this.ascRadioButton.setText(this.res.ascRadioButtonText);
        this.descRadioButton.setText(this.res.descRadioButtonText);
        this.simpleColumnCheckBox.setText(this.res.simpleColumnCheckBoxText);
    }

    private class Res {
        private String ascRadioButtonText;
        private String descRadioButtonText;
        private String simpleColumnCheckBoxText;

        private Res() {
        }
    }
}

