/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.window.content;

import java.util.BitSet;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.extras.app.menu.DefaultMenuModel;
import nextapp.echo.extras.app.menu.DefaultMenuStateModel;
import nextapp.echo.extras.app.menu.DefaultOptionModel;
import nextapp.echo.extras.app.menu.DefaultRadioOptionModel;
import nextapp.echo.extras.app.menu.DefaultToggleOptionModel;
import nextapp.echo.extras.app.menu.ItemModel;
import nextapp.echo.extras.app.menu.MenuModel;
import nextapp.echo.extras.app.menu.MenuStateModel;
import nextapp.echo.extras.app.menu.SeparatorModel;
import pl.com.stream.echo.lib.component.DetailsTable;
import pl.com.stream.echo.lib.component.SortTable;
import pl.com.stream.echo.lib.component.StrSplitPane;
import pl.com.stream.echo.lib.component.button.group.OperationButtonGroup;
import pl.com.stream.echo.lib.component.button.group.PageNavigatorButtonGroup;
import pl.com.stream.echo.lib.component.button.group.RefreshButtonGroup;
import pl.com.stream.echo.lib.component.button.group.SortFilterButtonGroup;
import pl.com.stream.echo.lib.component.button.group.StrButtonGroupRow;
import pl.com.stream.echo.lib.component.button.group.WindowButtonGroup;
import pl.com.stream.echo.lib.component.table.SortableTableColumn;
import pl.com.stream.echo.lib.component.window.content.AbstractBrowserPane;
import pl.com.stream.echo.lib.component.window.content.SearchBrowserWindowPane;
import pl.com.stream.echo.lib.event.ComponentOrientationEvent;
import pl.com.stream.echo.lib.event.ComponentOrientationListener;
import pl.com.stream.echo.lib.event.DetailsTableEvent;
import pl.com.stream.echo.lib.event.DetailsTableListener;
import pl.com.stream.echo.lib.event.MouseEvent;
import pl.com.stream.echo.lib.event.MouseListener;
import pl.com.stream.echo.lib.event.PageIndexChangeEvent;
import pl.com.stream.echo.lib.event.PageIndexChangeListener;
import pl.com.stream.echo.lib.event.PageNavigatorChangeEvent;
import pl.com.stream.echo.lib.event.PageNavigatorChangeListener;
import pl.com.stream.echo.lib.event.SearchEvent;
import pl.com.stream.echo.lib.event.SearchListener;
import pl.com.stream.echo.lib.event.SortEvent;
import pl.com.stream.echo.lib.event.SortListener;
import pl.com.stream.echo.lib.event.SortTableEvent;
import pl.com.stream.echo.lib.event.SortTableListener;
import pl.com.stream.echo.lib.event.StatusEvent;
import pl.com.stream.echo.lib.event.StatusListener;
import pl.com.stream.echo.lib.type.SplitPaneOrientationProperties;
import pl.com.stream.echo.lib.type.TSelectedTableColumnOrderList;
import pl.com.stream.echo.lib.type.TTableRowObject;
import pl.com.stream.echo.lib.type.annotanion.LoadProperty;
import pl.com.stream.echo.lib.type.annotanion.SaveProperty;
import pl.com.stream.echo.lib.type.column.ITableColumn;
import pl.com.stream.echo.lib.type.sql.TSqlOrderByObject;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class SearchBrowserPane
extends AbstractBrowserPane {
    private static final long serialVersionUID = -4280533612577140393L;
    private SplitPaneOrientationProperties detailsOrientationProperties;
    private SearchBrowserWindowPane searchBrowserPane;
    private SplitPaneOrientationProperties treeOrientationProperties;
    @ResourceContainer
    protected Res res;

    public SearchBrowserPane() {
        this.initComponents();
        this.initSearchBrowserWindowPane();
        this.initToolBar();
        this.initListeners();
        this.initSortTable();
        this.prepareMenuStateModel();
    }

    public MenuModel getMenuBarModel() {
        DefaultMenuModel defaultMenuModel = new DefaultMenuModel();
        DefaultMenuModel defaultMenuModel2 = new DefaultMenuModel("", this.res.operationsMenuText);
        defaultMenuModel2.addItem(this.createMenuItem("show", this.res.showMenuItemText, this.res.showMenuItemIcon));
        defaultMenuModel2.addItem(this.createMenuItem("add", this.res.addMenuItemText, this.res.addMenuItemIcon));
        defaultMenuModel2.addItem(this.createMenuItem("edit", this.res.editMenuItemText, this.res.editMenuItemIcon));
        defaultMenuModel2.addItem(this.createMenuItem("delete", this.res.removeMenuItemText, this.res.removeMenuItemIcon));
        DefaultMenuModel defaultMenuModel3 = new DefaultMenuModel("", this.res.sortMenuText);
        defaultMenuModel3.addItem(this.createMenuItem("sort", this.res.sortMenuItemText, this.res.sortMenuItemIcon));
        defaultMenuModel3.addItem(this.createMenuItem("filter", this.res.filterMenuItemText, this.res.filterMenuItemIcon));
        defaultMenuModel3.addItem(this.createMenuItem("filterOn", this.res.filterOnMenuItemText, this.res.filterOnMenuItemIcon));
        DefaultMenuModel defaultMenuModel4 = new DefaultMenuModel("", this.res.viewMenuText);
        defaultMenuModel4.addItem(this.createCheckBoxItem("toolBarVisible", this.res.showToolBarMenuItemText));
        defaultMenuModel4.addItem(this.createCheckBoxItem("statusBarVisible", this.res.showStatusBarMenuItemText));
        defaultMenuModel4.addItem(this.createSeparatorMenuItem());
        defaultMenuModel4.addItem(this.createRadioMenuItem("detailsRight", "szczegoly", this.res.detailsRightMenuItemText));
        defaultMenuModel4.addItem(this.createRadioMenuItem("detailsDown", "szczegoly", this.res.detailsBottomMenuItemText));
        defaultMenuModel4.addItem(this.createRadioMenuItem("detailsNone", "szczegoly", this.res.detailsHiddenMenuItemText));
        defaultMenuModel4.addItem(this.createSeparatorMenuItem());
        defaultMenuModel4.addItem(this.createRadioMenuItem("treeLeft", "drzewo", this.res.searchPanelLeftMenuItemText));
        defaultMenuModel4.addItem(this.createRadioMenuItem("treeRight", "drzewo", this.res.searchPanelRightMenuItemText));
        defaultMenuModel4.addItem(this.createRadioMenuItem("treeNone", "drzewo", this.res.searchPanelHiddenMenuItemText));
        defaultMenuModel4.addItem(this.createSeparatorMenuItem());
        defaultMenuModel4.addItem(this.createMenuItem("tableColumns", this.res.tableColumnsMenuItemText, this.res.tableColumnsMenuItemIcon));
        defaultMenuModel4.addItem(this.createMenuItem("detailsColumns", this.res.detailsColumnsMenuItemText, this.res.detailsColumnsMenuItemIcon));
        defaultMenuModel4.addItem(this.createSeparatorMenuItem());
        defaultMenuModel4.addItem(this.createMenuItem("rowsPerPage", this.res.rowsPerPageMenuItemText, this.res.rowsPerPageMenuItemIcon));
        defaultMenuModel4.addItem(this.createSeparatorMenuItem());
        defaultMenuModel4.addItem(this.createMenuItem("styleSheet", this.res.styleSheetMenuItemText, null));
        defaultMenuModel.addItem((ItemModel)defaultMenuModel2);
        defaultMenuModel.addItem((ItemModel)defaultMenuModel3);
        defaultMenuModel.addItem((ItemModel)defaultMenuModel4);
        return defaultMenuModel;
    }

    @SaveProperty(propertyName="detailsPanel")
    public SplitPaneOrientationProperties getResDetailsPanelProperties() {
        return this.searchBrowserPane.getDetailsPanelOrientationProperties();
    }

    @SaveProperty(propertyName="treePanel")
    public SplitPaneOrientationProperties getResTreePanelProperties() {
        return this.searchBrowserPane.getTreePanelOrientationProperties();
    }

    public SearchBrowserWindowPane getSearchBrowserWindowPane() {
        return this.searchBrowserPane;
    }

    public TTableRowObject getSelectedRow() {
        Object object = this.getSortTable().getSelectedRow();
        if (object instanceof TTableRowObject) {
            TTableRowObject tTableRowObject = (TTableRowObject)object;
            return tTableRowObject;
        }
        return null;
    }

    public void open(Component component) {
        super.open(component);
        this.initSortTable();
    }

    public void setCloseable(boolean bl) {
        this.getTitleBar().setCloseButtonVisible(false);
        StrButtonGroupRow strButtonGroupRow = this.getToolBar().getButtonGroupOnRightSide(WindowButtonGroup.class);
        if (strButtonGroupRow instanceof WindowButtonGroup) {
            WindowButtonGroup windowButtonGroup = (WindowButtonGroup)strButtonGroupRow;
            windowButtonGroup.setCloseButtonVisible(false);
        }
    }

    @LoadProperty(propertyName="detailsPanel")
    public void setResDetailsPanelProperties(SplitPaneOrientationProperties splitPaneOrientationProperties) {
        this.detailsOrientationProperties = splitPaneOrientationProperties;
    }

    @LoadProperty(propertyName="treePanel")
    public void setResTreePanelProperties(SplitPaneOrientationProperties splitPaneOrientationProperties) {
        this.treeOrientationProperties = splitPaneOrientationProperties;
    }

    private void initComponents() {
        this.setStyleName("BrowserPaneStyle");
        this.searchBrowserPane = new SearchBrowserWindowPane();
        this.add((Component)this.searchBrowserPane);
    }

    protected ItemModel createCheckBoxItem(String string, String string2) {
        return new DefaultToggleOptionModel(string, string2);
    }

    protected ItemModel createMenuItem(String string, String string2, ImageReference imageReference) {
        return new DefaultOptionModel(string, string2, imageReference);
    }

    protected ItemModel createRadioMenuItem(String string, String string2, String string3) {
        return new DefaultRadioOptionModel(string, string2, string3);
    }

    protected ItemModel createSeparatorMenuItem() {
        return new SeparatorModel();
    }

    protected SplitPaneOrientationProperties getDefDetailsOrientationProperties() {
        return new SplitPaneOrientationProperties(StrSplitPane.SplitPaneFirstComponentOrientation.down, new Extent(150), new Extent(150));
    }

    protected SplitPaneOrientationProperties getDefTreeOrientationProperties() {
        return new SplitPaneOrientationProperties(StrSplitPane.SplitPaneFirstComponentOrientation.right, new Extent(210), new Extent(210));
    }

    protected SplitPaneOrientationProperties getDetailsOrientationProperties() {
        if (this.detailsOrientationProperties == null) {
            this.detailsOrientationProperties = this.getDefDetailsOrientationProperties();
        }
        return this.detailsOrientationProperties;
    }

    protected DetailsTable getDetailsTable() {
        return this.searchBrowserPane.getDetailsTable();
    }

    protected SortTable getSortTable() {
        return this.searchBrowserPane.getSortTable();
    }

    protected SplitPaneOrientationProperties getTreeOrientationProperties() {
        if (this.treeOrientationProperties == null) {
            this.treeOrientationProperties = this.getDefTreeOrientationProperties();
        }
        return this.treeOrientationProperties;
    }

    protected void initListeners() {
        this.getDataManager().addDetailsTableListener(new DetailsTableListener(){

            public void detailsChanged(DetailsTableEvent detailsTableEvent) {
                SearchBrowserPane.this.getDetailsTable().removeAllRows();
                SearchBrowserPane.this.getDetailsTable().setTableObject(detailsTableEvent.getRowId(), detailsTableEvent.getDetails());
            }
        });
        this.getDataManager().addPageNavigatorChangeListener(new PageNavigatorChangeListener(){
            private static final long serialVersionUID = 1L;

            public void pageIndexChanged(PageNavigatorChangeEvent pageNavigatorChangeEvent) {
                PageNavigatorButtonGroup pageNavigatorButtonGroup = (PageNavigatorButtonGroup)SearchBrowserPane.this.getToolBar().getButtonGroupOnRightSide(PageNavigatorButtonGroup.class);
                if (pageNavigatorButtonGroup != null) {
                    pageNavigatorButtonGroup.setPageIndex(pageNavigatorChangeEvent.getNewPageIndex());
                    pageNavigatorButtonGroup.setTotalPages(pageNavigatorChangeEvent.getTotalPages());
                    pageNavigatorButtonGroup.setNextPageAvailable(pageNavigatorChangeEvent.isNextPageAvailable());
                    pageNavigatorButtonGroup.setPageCountingEnabled(pageNavigatorChangeEvent.isPageCountingEnalbed());
                }
            }
        });
        this.getDataManager().addStatusListener(new StatusListener(){
            private static final long serialVersionUID = 1L;

            public void statusChanged(StatusEvent statusEvent) {
                if (statusEvent.getStatusType() != null) {
                    switch (statusEvent.getStatusType()) {
                        case statusDrzewa: {
                            SearchBrowserPane.this.setStatusDrzewa(statusEvent.getStatusMessage());
                            break;
                        }
                        case statusUrzadzenia: {
                            SearchBrowserPane.this.setStatusUrzadzenia(statusEvent.getStatusMessage());
                            break;
                        }
                        case statusFiltru: {
                            SearchBrowserPane.this.setStatusFiltru(statusEvent.getStatusMessage());
                            break;
                        }
                        case statusSzybkiegoFiltru: {
                            SearchBrowserPane.this.setStatusSzybkiegoFiltru(statusEvent.getStatusMessage());
                        }
                    }
                }
            }
        });
        this.getDataManager().addSortTableListener(new SortTableListener(){

            public void columnOrderChanged(SortTableEvent sortTableEvent) {
                SearchBrowserPane.this.getSortTable().setColumnsOrder(sortTableEvent.getColumnOrderList());
            }

            public void tableObjectChanged(SortTableEvent sortTableEvent) {
                SearchBrowserPane.this.getSortTable().setTableObject(sortTableEvent.getTableObject());
                TTableRowObject tTableRowObject = SearchBrowserPane.this.getSelectedRow();
                if (tTableRowObject != null) {
                    SearchBrowserPane.this.getDataManager().setSelectedRowId(tTableRowObject.getId());
                } else {
                    SearchBrowserPane.this.getDataManager().setSelectedRowId(null);
                }
                SortFilterButtonGroup sortFilterButtonGroup = (SortFilterButtonGroup)SearchBrowserPane.this.getToolBar().getButtonGroupOnLeftSide(SortFilterButtonGroup.class);
                if (sortFilterButtonGroup != null) {
                    sortFilterButtonGroup.setWindowFilterActive(SearchBrowserPane.this.getDataManager().isWindowFilterActive());
                }
                SearchBrowserPane.this.refreshOperationButtons();
            }

            public void tableVisibleColumnsChanged(SortTableEvent sortTableEvent) {
                SearchBrowserPane.this.getSortTable().setColumnModelFromTVisibleColumns(sortTableEvent.getVisibleColumnList());
                SearchBrowserPane.this.searchBrowserPane.getSearchPane().setColumnList(sortTableEvent.getVisibleColumnList());
            }
        });
        this.addButtonsActionListener(new ActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() != null) {
                    if (actionEvent.getActionCommand().equals("show")) {
                        // empty if block
                    }
                    if (actionEvent.getActionCommand().equals("add")) {
                        // empty if block
                    }
                    if (actionEvent.getActionCommand().equals("edit")) {
                        // empty if block
                    }
                    if (actionEvent.getActionCommand().equals("delete")) {
                        // empty if block
                    }
                    if (actionEvent.getActionCommand().equals("sort")) {
                        SearchBrowserPane.this.openSortWindow();
                    }
                    if (actionEvent.getActionCommand().equals("filter")) {
                        SearchBrowserPane.this.openFilterWindow();
                    }
                    if (actionEvent.getActionCommand().equals("filterOn")) {
                        SearchBrowserPane.this.getDataManager().setWindowFilter(null);
                    }
                    if ("refresh".equals(actionEvent.getActionCommand())) {
                        SearchBrowserPane.this.refresh();
                    }
                    if (actionEvent.getActionCommand().equals("details")) {
                        SearchBrowserPane.this.searchBrowserPane.rotateDetailsOrientation();
                    }
                    if (actionEvent.getActionCommand().equals("search")) {
                        SearchBrowserPane.this.searchBrowserPane.rotateTreeOrientation();
                    }
                    if (actionEvent.getActionCommand().equals("close")) {
                        SearchBrowserPane.this.close();
                    }
                }
            }
        });
        this.addMenuActionListener(new ActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() != null) {
                    if (actionEvent.getActionCommand().equals("show")) {
                        // empty if block
                    }
                    if (actionEvent.getActionCommand().equals("add")) {
                        // empty if block
                    }
                    if (actionEvent.getActionCommand().equals("edit")) {
                        // empty if block
                    }
                    if (actionEvent.getActionCommand().equals("delete")) {
                        // empty if block
                    }
                    if (actionEvent.getActionCommand().equals("sort")) {
                        SearchBrowserPane.this.openSortWindow();
                    }
                    if (actionEvent.getActionCommand().equals("filter")) {
                        SearchBrowserPane.this.openFilterWindow();
                    }
                    if (actionEvent.getActionCommand().equals("filterOn")) {
                        SearchBrowserPane.this.getDataManager().setWindowFilter(null);
                    }
                    if (actionEvent.getActionCommand().equals("toolBarVisible")) {
                        SearchBrowserPane.this.setToolBarVisible(!SearchBrowserPane.this.isToolBarVisible());
                    }
                    if (actionEvent.getActionCommand().equals("statusBarVisible")) {
                        SearchBrowserPane.this.setStatusBarVisible(!SearchBrowserPane.this.isStatusBarVisible());
                    }
                    if (actionEvent.getActionCommand().equals("detailsRight")) {
                        SearchBrowserPane.this.searchBrowserPane.setDetailsOrientation(StrSplitPane.SplitPaneFirstComponentOrientation.right);
                        SearchBrowserPane.this.getDetailsTable().setColumnsCount(DetailsTable.ColumnsCount.two);
                    }
                    if (actionEvent.getActionCommand().equals("detailsDown")) {
                        SearchBrowserPane.this.searchBrowserPane.setDetailsOrientation(StrSplitPane.SplitPaneFirstComponentOrientation.down);
                        SearchBrowserPane.this.getDetailsTable().setColumnsCount(DetailsTable.ColumnsCount.four);
                    }
                    if (actionEvent.getActionCommand().equals("detailsNone")) {
                        SearchBrowserPane.this.searchBrowserPane.setDetailsOrientation(StrSplitPane.SplitPaneFirstComponentOrientation.none);
                    }
                    if (actionEvent.getActionCommand().equals("treeRight")) {
                        SearchBrowserPane.this.searchBrowserPane.setTreeOrientation(StrSplitPane.SplitPaneFirstComponentOrientation.right);
                    }
                    if (actionEvent.getActionCommand().equals("treeLeft")) {
                        SearchBrowserPane.this.searchBrowserPane.setTreeOrientation(StrSplitPane.SplitPaneFirstComponentOrientation.left);
                    }
                    if (actionEvent.getActionCommand().equals("treeNone")) {
                        SearchBrowserPane.this.searchBrowserPane.setTreeOrientation(StrSplitPane.SplitPaneFirstComponentOrientation.none);
                    }
                    if (actionEvent.getActionCommand().equals("tableColumns")) {
                        SearchBrowserPane.this.openTableColumnsWindow();
                    }
                    if (actionEvent.getActionCommand().equals("detailsColumns")) {
                        SearchBrowserPane.this.openDetailsColumnsWindow();
                    }
                    if (actionEvent.getActionCommand().equals("rowsPerPage")) {
                        SearchBrowserPane.this.openRowPerPageWindowContent();
                    }
                    if (actionEvent.getActionCommand().equals("styleSheet")) {
                        SearchBrowserPane.this.openStyleSheetWindow();
                    }
                    if (actionEvent.getActionCommand().equals("close")) {
                        SearchBrowserPane.this.close();
                    }
                }
            }
        });
        this.getSortTable().addSortListener(new SortListener(){

            public void sortPerformed(SortEvent sortEvent) {
                SortableTableColumn sortableTableColumn = (SortableTableColumn)SearchBrowserPane.this.getSortTable().getColumnModel().getColumn(sortEvent.getColumnNumber());
                if (sortableTableColumn.getIdentifier() instanceof ITableColumn) {
                    ITableColumn iTableColumn = (ITableColumn)sortableTableColumn.getIdentifier();
                    TSelectedTableColumnOrderList tSelectedTableColumnOrderList = new TSelectedTableColumnOrderList();
                    tSelectedTableColumnOrderList.addColumn(iTableColumn.getTableAlias(), iTableColumn.getName(), sortEvent.isAscending() ? TSqlOrderByObject.OrderTypes.ASC : TSqlOrderByObject.OrderTypes.DESC);
                    SearchBrowserPane.this.getDataManager().setSelectedColumnOrderList(tSelectedTableColumnOrderList);
                    if (!SearchBrowserPane.this.getDataManager().isFaseSearchFilterActive()) {
                        SearchBrowserPane.this.searchBrowserPane.setSelectedColumn(iTableColumn);
                    }
                }
            }
        });
        this.getSortTable().addMouseListener(new MouseListener(){
            private static final long serialVersionUID = 1L;

            public void mouseClicked(MouseEvent mouseEvent) {
                switch (mouseEvent.getEventType()) {
                    case singleClick: 
                    case doubleClick: {
                        TTableRowObject tTableRowObject = SearchBrowserPane.this.getSelectedRow();
                        if (tTableRowObject != null) {
                            SearchBrowserPane.this.getDataManager().setSelectedRowId(tTableRowObject.getId());
                            break;
                        }
                        SearchBrowserPane.this.getDataManager().setSelectedRowId(null);
                    }
                }
            }
        });
        this.searchBrowserPane.addDetailsOrientationListener(new ComponentOrientationListener(){
            private static final long serialVersionUID = 1L;

            public void orientationChanged(ComponentOrientationEvent componentOrientationEvent) {
                SearchBrowserPane.this.prepareMenuStateModel();
            }
        });
        this.searchBrowserPane.addTreeOrientationListener(new ComponentOrientationListener(){
            private static final long serialVersionUID = 1L;

            public void orientationChanged(ComponentOrientationEvent componentOrientationEvent) {
                SearchBrowserPane.this.prepareMenuStateModel();
            }
        });
        this.searchBrowserPane.addSearchListener(new SearchListener(){
            private static final long serialVersionUID = 1L;

            public void searchCanceled() {
                SearchBrowserPane.this.getDataManager().setFastSearchFilter(null, null);
            }

            public void searchPerformed(SearchEvent searchEvent) {
                SearchBrowserPane.this.getDataManager().setFastSearchFilter(searchEvent.getSqlWhere(), searchEvent.getStatusMessage());
            }
        });
    }

    protected void initSearchBrowserWindowPane() {
        this.searchBrowserPane.setDetailsPanelOrientationProperties(this.getDetailsOrientationProperties());
        this.searchBrowserPane.setTreePanelOrientationProperties(this.getTreeOrientationProperties());
        this.searchBrowserPane.getSearchPane().setColumnList(this.getDataManager().getVisibleColumnList());
        StrSplitPane.SplitPaneFirstComponentOrientation splitPaneFirstComponentOrientation = this.getDetailsOrientationProperties().getFirstComponentOrientation();
        switch (splitPaneFirstComponentOrientation) {
            case down: {
                this.getDetailsTable().setColumnsCount(DetailsTable.ColumnsCount.four);
                break;
            }
            case right: {
                this.getDetailsTable().setColumnsCount(DetailsTable.ColumnsCount.two);
            }
        }
    }

    protected void initSortTable() {
        this.getSortTable().setColumnModelFromTVisibleColumns(this.getDataManager().getVisibleColumnList());
        this.getSortTable().setColumnsOrder(this.getDataManager().getSelectedColumnOrderList());
    }

    protected void initToolBar() {
        this.getToolBar().addButtonGroupOnLeftSide(new OperationButtonGroup());
        this.getToolBar().addButtonGroupOnLeftSide(new SortFilterButtonGroup());
        this.getToolBar().addButtonGroupOnLeftSide(new RefreshButtonGroup());
        PageNavigatorButtonGroup pageNavigatorButtonGroup = new PageNavigatorButtonGroup();
        pageNavigatorButtonGroup.addPageIndexChangeListener(new PageIndexChangeListener(){
            private static final long serialVersionUID = 1L;

            public void pageIndexChanged(PageIndexChangeEvent pageIndexChangeEvent) {
                SearchBrowserPane.this.getDataManager().changeCurrentPage(pageIndexChangeEvent.getNewPageIndex());
            }
        });
        this.getToolBar().addButtonGroupOnRightSide(pageNavigatorButtonGroup);
        WindowButtonGroup windowButtonGroup = new WindowButtonGroup();
        this.getToolBar().addButtonGroupOnRightSide(windowButtonGroup);
    }

    protected void prepareMenuStateModel() {
        DefaultMenuStateModel defaultMenuStateModel = new DefaultMenuStateModel();
        defaultMenuStateModel.setSelected("toolBarVisible", this.isToolBarVisible());
        defaultMenuStateModel.setSelected("statusBarVisible", this.isStatusBarVisible());
        switch (this.searchBrowserPane.getDetailsOrientation()) {
            case none: {
                defaultMenuStateModel.setSelected("detailsNone", true);
                break;
            }
            case right: {
                defaultMenuStateModel.setSelected("detailsRight", true);
                break;
            }
            case down: {
                defaultMenuStateModel.setSelected("detailsDown", true);
            }
        }
        switch (this.searchBrowserPane.getTreeOrientation()) {
            case none: {
                defaultMenuStateModel.setSelected("treeNone", true);
                break;
            }
            case left: {
                defaultMenuStateModel.setSelected("treeLeft", true);
                break;
            }
            case right: {
                defaultMenuStateModel.setSelected("treeRight", true);
            }
        }
        this.getMenuBarPane().setStateModel((MenuStateModel)defaultMenuStateModel);
    }

    protected void refreshOperationButtons() {
        OperationButtonGroup operationButtonGroup = (OperationButtonGroup)this.getToolBar().getButtonGroupOnLeftSide(OperationButtonGroup.class);
        if (operationButtonGroup != null) {
            TTableRowObject tTableRowObject = this.getSelectedRow();
            BitSet bitSet = new BitSet(4);
            if (tTableRowObject != null || this.getSortTable().getSelectionModel().getMinSelectedIndex() != -1) {
                bitSet.set(0);
                bitSet.set(1);
                bitSet.set(2);
                bitSet.set(3);
            } else {
                bitSet.set(1);
            }
            operationButtonGroup.setEnabledButtonsBitSet(bitSet);
        }
    }

    protected class Res {
        public ImageReference addMenuItemIcon;
        public String addMenuItemText;
        public String detailsBottomMenuItemText;
        public ImageReference detailsColumnsMenuItemIcon;
        public String detailsColumnsMenuItemText;
        public String detailsHiddenMenuItemText;
        public String detailsRightMenuItemText;
        public ImageReference editMenuItemIcon;
        public String editMenuItemText;
        public ImageReference filterMenuItemIcon;
        public String filterMenuItemText;
        public ImageReference filterOnMenuItemIcon;
        public String filterOnMenuItemText;
        public String operationsMenuText;
        public ImageReference removeMenuItemIcon;
        public String removeMenuItemText;
        public ImageReference rowsPerPageMenuItemIcon;
        public String rowsPerPageMenuItemText;
        public String searchPanelHiddenMenuItemText;
        public String searchPanelLeftMenuItemText;
        public String searchPanelRightMenuItemText;
        public ImageReference showMenuItemIcon;
        public String showMenuItemText;
        public String showStatusBarMenuItemText;
        public String showToolBarMenuItemText;
        public ImageReference sortMenuItemIcon;
        public String sortMenuItemText;
        public String sortMenuText;
        public String styleSheetMenuItemText;
        public ImageReference tableColumnsMenuItemIcon;
        public String tableColumnsMenuItemText;
        public String viewMenuText;

        protected Res() {
        }
    }
}

