/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.window.content;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import nextapp.echo.app.Column;
import nextapp.echo.app.Component;
import nextapp.echo.app.ContentPane;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Insets;
import nextapp.echo.app.Label;
import nextapp.echo.app.LayoutData;
import nextapp.echo.app.Table;
import nextapp.echo.app.layout.TableLayoutData;
import nextapp.echo.app.table.TableCellRenderer;
import pl.com.stream.echo.lib.component.DoubleTableContainer;
import pl.com.stream.echo.lib.type.column.ILabeledColumn;
import pl.com.stream.echo.lib.type.column.ITableColumn;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnsPane
extends ContentPane {
    private static final long serialVersionUID = -4330321076200649070L;
    private DoubleTableContainer doubleTableContainer;
    @ResourceContainer
    private Res res;

    public ColumnsPane() {
        ResourceManager.bind((Object)((Object)this), (Locale)ClientLocale.getCurrent());
        this.initComponents();
        this.initAvaibleTableRenderer();
    }

    public void addSelectionListener(DoubleTableContainer.SelectionListener selectionListener) {
        this.doubleTableContainer.addSelectionListener(selectionListener);
    }

    public void fillVisibleAndAvailableColumns(ArrayList<?> arrayList, ArrayList<?> arrayList2) {
        ArrayList arrayList3 = (ArrayList)arrayList2.clone();
        arrayList3.removeAll(arrayList);
        this.setVisibleColumnList(arrayList);
        this.setAvailableColumnList(arrayList3);
    }

    public ITableColumn getSelectedColumn() {
        Object object = this.doubleTableContainer.getSelectedObject();
        if (object instanceof ITableColumn) {
            ITableColumn iTableColumn = (ITableColumn)object;
            return iTableColumn;
        }
        return null;
    }

    public List<?> getVisibleColumnList() {
        return this.doubleTableContainer.getSelectedList();
    }

    public void removeSelectionListener(DoubleTableContainer.SelectionListener selectionListener) {
        this.doubleTableContainer.removeSelectionListener(selectionListener);
    }

    private void initAvaibleTableRenderer() {
        TableCellRenderer tableCellRenderer = new TableCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Component getTableCellRendererComponent(Table table, Object object, int n, int n2) {
                Label label = new Label();
                TableLayoutData tableLayoutData = new TableLayoutData();
                tableLayoutData.setInsets(new Insets(2, 2, 2, 2));
                label.setLayoutData((LayoutData)tableLayoutData);
                label.setStyleName("LabelMediumStyle");
                if (object instanceof ILabeledColumn) {
                    ILabeledColumn iLabeledColumn = (ILabeledColumn)object;
                    label.setText(iLabeledColumn.getLabel());
                    label.setToolTipText(MessageFormat.format(ColumnsPane.this.res.columnToolTip, iLabeledColumn.getTableLabel()));
                }
                return label;
            }
        };
        this.doubleTableContainer.setCellRenderer(tableCellRenderer);
    }

    private void initComponents() {
        Column column = new Column();
        column.setInsets(new Insets(new Extent(4, 1)));
        this.add((Component)column);
        this.doubleTableContainer = new DoubleTableContainer();
        this.doubleTableContainer.setAutoSortSelectedTable(false);
        this.doubleTableContainer.setHeight(new Extent(300, 1));
        column.add((Component)this.doubleTableContainer);
    }

    private void setAvailableColumnList(List<?> list) {
        this.doubleTableContainer.setAvailableList(list);
    }

    private void setVisibleColumnList(List<?> list) {
        this.doubleTableContainer.setSelectedList(list);
    }

    private class Res {
        private String columnToolTip;

        private Res() {
        }
    }
}

