/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.window.content;

import java.util.ArrayList;
import java.util.Locale;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Column;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Grid;
import nextapp.echo.app.Insets;
import nextapp.echo.app.LayoutData;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.layout.GridLayoutData;
import pl.com.stream.echo.lib.component.Panel;
import pl.com.stream.echo.lib.component.StrComboBox;
import pl.com.stream.echo.lib.component.StrLabelMedium;
import pl.com.stream.echo.lib.component.StrTextField;
import pl.com.stream.echo.lib.type.column.ITableColumn;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class ColumnPane
extends Panel {
    private static final long serialVersionUID = 3929110940462687375L;
    private StrLabelMedium columnLabel;
    private StrLabelMedium columnSizeLabel;
    private StrTextField columnSizeTextField;
    private StrTextField columnTextField;
    private int oldColumnSize;
    @ResourceContainer
    private Res res;
    private StrLabelMedium unitLabel;
    private StrComboBox unitsSelectField;

    public ColumnPane() {
        ResourceManager.bind((Object)((Object)this), (Locale)ClientLocale.getCurrent());
        this.initComponents();
        this.initResources();
        this.initUnitsModel();
        this.forceFocusOnFirstComponent();
    }

    public void addColumnSizeTextFieldActionListener(ActionListener actionListener) {
        this.columnSizeTextField.addActionListener(actionListener);
    }

    public Extent getColumnSize() {
        Units units = (Units)this.unitsSelectField.getSelectedItem();
        int n = 1;
        try {
            n = Integer.parseInt(this.columnSizeTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n = this.oldColumnSize;
        }
        if (n < 0) {
            n = this.oldColumnSize;
        }
        if (n == 0) {
            n = 1;
        }
        return new Extent(n, units.getExtentUnit());
    }

    public void removeColumnSizeTextFieldActionListener(ActionListener actionListener) {
        this.columnSizeTextField.removeActionListener(actionListener);
    }

    public void setColumn(ITableColumn iTableColumn) {
        this.oldColumnSize = iTableColumn.getSize();
        this.columnTextField.setText(iTableColumn.getLabel());
        this.columnSizeTextField.setText(String.valueOf(iTableColumn.getSize()));
        int n = -1;
        for (int i = 0; i < this.unitsSelectField.getModel().size(); ++i) {
            Units units = (Units)this.unitsSelectField.getModel().get(i);
            if (units.getExtentUnit() != iTableColumn.getSizeUnit().intValue()) continue;
            n = i;
            break;
        }
        this.unitsSelectField.setSelectedIndex(n);
    }

    private void initComponents() {
        Column column = new Column();
        column.setInsets(new Insets(new Extent(8, 1)));
        this.add((Component)column);
        Grid grid = new Grid();
        grid.setInsets(new Insets(new Extent(2, 1)));
        grid.setSize(4);
        column.add((Component)grid);
        this.columnLabel = new StrLabelMedium();
        this.columnLabel.setStyleName("LabelMediumStyle");
        this.columnLabel.setText("column");
        GridLayoutData gridLayoutData = new GridLayoutData();
        gridLayoutData.setAlignment(new Alignment(5, 0));
        this.columnLabel.setLayoutData((LayoutData)gridLayoutData);
        grid.add((Component)this.columnLabel);
        this.columnTextField = new StrTextField();
        this.columnTextField.setStyleName("TextFieldStyle");
        this.columnTextField.setEnabled(false);
        this.columnTextField.setWidth(new Extent(100, 2));
        GridLayoutData gridLayoutData2 = new GridLayoutData();
        gridLayoutData2.setColumnSpan(3);
        this.columnTextField.setLayoutData((LayoutData)gridLayoutData2);
        grid.add((Component)this.columnTextField);
        this.columnSizeLabel = new StrLabelMedium();
        this.columnSizeLabel.setStyleName("LabelMediumStyle");
        this.columnSizeLabel.setText("size");
        GridLayoutData gridLayoutData3 = new GridLayoutData();
        gridLayoutData3.setAlignment(new Alignment(5, 0));
        this.columnSizeLabel.setLayoutData((LayoutData)gridLayoutData3);
        grid.add((Component)this.columnSizeLabel);
        this.columnSizeTextField = new StrTextField();
        this.columnSizeTextField.setStyleName("TextFieldStyle");
        this.columnSizeTextField.setWidth(new Extent(35, 1));
        this.columnSizeTextField.setMaximumLength(4);
        grid.add((Component)this.columnSizeTextField);
        this.unitLabel = new StrLabelMedium();
        this.unitLabel.setStyleName("LabelMediumStyle");
        this.unitLabel.setText("unit");
        grid.add((Component)this.unitLabel);
        this.unitsSelectField = new StrComboBox();
        this.unitsSelectField.setStyleName("SelectFieldStyle");
        this.unitsSelectField.setWidth(new Extent(100, 1));
        grid.add((Component)this.unitsSelectField);
    }

    private void initResources() {
        this.columnLabel.setText(this.res.columnLabelText);
        this.columnSizeLabel.setText(this.res.columnSizeLabelText);
        this.unitLabel.setText(this.res.unitLabelText);
    }

    private void initUnitsModel() {
        ArrayList<Units> arrayList = new ArrayList<Units>();
        arrayList.add(new Units(this.res.unitPixelText, 1));
        this.unitsSelectField.setList(arrayList);
        this.unitsSelectField.setSelectedIndex(0);
    }

    private class Units {
        private final int extentUnit;
        private final String label;

        public Units(String string, int n) {
            this.label = string;
            this.extentUnit = n;
        }

        public int getExtentUnit() {
            return this.extentUnit;
        }

        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return this.getLabel();
        }
    }

    private class Res {
        private String columnLabelText;
        private String columnSizeLabelText;
        private String unitLabelText;
        private String unitPixelText;

        private Res() {
        }
    }
}

