/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.window.content;

import java.util.Locale;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.ContentPane;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Font;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.LayoutData;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.layout.SplitPaneLayoutData;
import nextapp.echo.extras.app.MenuBarPane;
import nextapp.echo.extras.app.menu.DefaultMenuModel;
import nextapp.echo.extras.app.menu.MenuModel;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.StrApplicationInterface;
import pl.com.stream.echo.lib.component.StrSplitPane;
import pl.com.stream.echo.lib.component.panels.IStatusBar;
import pl.com.stream.echo.lib.component.panels.StatusBar;
import pl.com.stream.echo.lib.component.panels.TitleBar;
import pl.com.stream.echo.lib.component.panels.ToolBar;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.echo.lib.util.PropertyManager;
import pl.com.stream.echo.lib.util.XmlSource;
import pl.com.stream.lib.commons.reman.ResourceManager;

public class AbstractPane
extends ContentPane {
    private static Logger log = Logger.getLogger(AbstractPane.class);
    private static final long serialVersionUID = 1770320387156003983L;
    private ToolBar buttonsPane;
    private ContentPane contentPane;
    private DefaultCloseOperation defaultCloseOperation = DefaultCloseOperation.exitOnClose;
    private MenuBarPane menuBarPane;
    private StrSplitPane menuBarSplitPane;
    private PropertyManager propertyManager;
    private StatusBar statusBar;
    private StrSplitPane statusBarSplitPane;
    private TitleBar titleBar;
    private StrSplitPane titleBarSplitPane;
    private StrSplitPane toolBarSplitPane;

    public AbstractPane() {
        this.doBindResources();
        this.initSessionObjects();
        this.initComponents();
        if (ApplicationInstance.getActive() instanceof StrApplicationInterface) {
            StrApplicationInterface strApplicationInterface = (StrApplicationInterface)ApplicationInstance.getActive();
            this.getPropertyManager().setXmlSource(strApplicationInterface.getXmlSource());
        }
        this.loadProperties();
        this.initListeners();
    }

    public void add(Component component) {
        this.getContentPane().add(component);
    }

    public void addButtonsActionListener(ActionListener actionListener) {
        this.getToolBar().addActionListener(actionListener);
    }

    public void addMenuActionListener(ActionListener actionListener) {
        this.getMenuBarPane().addActionListener(actionListener);
    }

    public void addTitleBarListener(ActionListener actionListener) {
        this.getTitleBar().addTitleBarListener(actionListener);
    }

    public void close() {
        this.saveProperties();
        if (DefaultCloseOperation.exitOnClose.equals((Object)this.defaultCloseOperation) && this.getParent() != null) {
            this.getParent().remove((Component)this);
        }
    }

    public DefaultCloseOperation getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public MenuModel getMenuBarModel() {
        return new DefaultMenuModel();
    }

    public String getTitle() {
        return this.getTitleBar().getTitle();
    }

    public boolean isMenuBarVisible() {
        return this.getMenuBarSplitPane().isFirstComponentVisible();
    }

    public boolean isStatusBarVisible() {
        return this.getStatusBarSplitPane().isFirstComponentVisible();
    }

    public boolean isTitleBarVisible() {
        return this.getTitleBarSplitPane().isFirstComponentVisible();
    }

    public boolean isToolBarVisible() {
        return this.getToolBarSplitPane().isFirstComponentVisible();
    }

    public void open() {
        this.open(null);
    }

    public void open(Component component) {
        if (component != null) {
            component.add((Component)this);
        } else {
            ApplicationInstance.getActive().getDefaultWindow().getContent().add((Component)this);
        }
    }

    public void removeButtonsActionListener(ActionListener actionListener) {
        this.getToolBar().removeActionListener(actionListener);
    }

    public void removeMenuActionListener(ActionListener actionListener) {
        this.getMenuBarPane().removeActionListener(actionListener);
    }

    public void removeTitleBarListener(ActionListener actionListener) {
        this.getTitleBar().removeTitleBarListener(actionListener);
    }

    public void setDefaultCloseOperation(DefaultCloseOperation defaultCloseOperation) {
        this.defaultCloseOperation = defaultCloseOperation;
    }

    public void setIcon(ImageReference imageReference) {
        this.getTitleBar().setIcon(imageReference);
    }

    public void setMenuBarVisible(boolean bl) {
        if (bl) {
            this.getMenuBarSplitPane().restoreFirstComponentOrientation();
        } else {
            this.getMenuBarSplitPane().setFirstComponentOrientation(StrSplitPane.SplitPaneFirstComponentOrientation.none);
        }
    }

    public void setStatusBarVisible(boolean bl) {
        if (bl) {
            this.getStatusBarSplitPane().restoreFirstComponentOrientation();
        } else {
            this.getStatusBarSplitPane().setFirstComponentOrientation(StrSplitPane.SplitPaneFirstComponentOrientation.none);
        }
    }

    public void setStatusDrzewa(String string) {
        if (this.getStatusBar() instanceof IStatusBar) {
            IStatusBar iStatusBar = (IStatusBar)this.getStatusBar();
            iStatusBar.setStatusDrzewa(string);
        }
    }

    public void setStatusFiltru(String string) {
        if (this.getStatusBar() instanceof IStatusBar) {
            IStatusBar iStatusBar = (IStatusBar)this.getStatusBar();
            iStatusBar.setStatusFiltru(string);
        }
    }

    public void setStatusSzybkiegoFiltru(String string) {
        if (this.getStatusBar() instanceof IStatusBar) {
            IStatusBar iStatusBar = (IStatusBar)this.getStatusBar();
            iStatusBar.setStatusSzybkiegoFiltru(string);
        }
    }

    public void setStatusUrzadzenia(String string) {
        if (this.getStatusBar() instanceof IStatusBar) {
            IStatusBar iStatusBar = (IStatusBar)this.getStatusBar();
            iStatusBar.setStatusUrzadzenia(string);
        }
    }

    public void setTitle(String string) {
        this.getTitleBar().setTitle(string);
    }

    public void setTitleBarVisible(boolean bl) {
        if (bl) {
            this.getTitleBarSplitPane().restoreFirstComponentOrientation();
        } else {
            this.getTitleBarSplitPane().setFirstComponentOrientation(StrSplitPane.SplitPaneFirstComponentOrientation.none);
        }
    }

    public void setToolBarVisible(boolean bl) {
        if (bl) {
            this.getToolBarSplitPane().restoreFirstComponentOrientation();
        } else {
            this.getToolBarSplitPane().setFirstComponentOrientation(StrSplitPane.SplitPaneFirstComponentOrientation.none);
        }
    }

    public void setXmlSource(XmlSource xmlSource) {
        if (this.propertyManager != null) {
            this.propertyManager.setXmlSource(xmlSource);
        }
    }

    private void doBindResources() {
        ResourceManager.bind((Object)((Object)this), (Locale)ClientLocale.getCurrent());
    }

    private ContentPane getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new ContentPane();
            this.getToolBarSplitPane().add((Component)this.contentPane);
        }
        return this.contentPane;
    }

    private StrSplitPane getMenuBarSplitPane() {
        if (this.menuBarSplitPane == null) {
            this.menuBarSplitPane = new StrSplitPane();
            this.menuBarSplitPane.setStyleName("StrSplitPane");
            this.menuBarSplitPane.setFont(new Font(new Font.Typeface("sans-serif"), 0, new Extent(9, 4)));
            this.menuBarSplitPane.setFirstComponentOrientation(StrSplitPane.SplitPaneFirstComponentOrientation.up);
            this.menuBarSplitPane.setVerticalSeparatorPosition(new Extent(20, 1));
            this.menuBarSplitPane.setSeparatorHeight(new Extent(0));
            this.menuBarSplitPane.add((Component)this.getMenuBarPane());
            this.getTitleBarSplitPane().add((Component)this.menuBarSplitPane);
        }
        return this.menuBarSplitPane;
    }

    private StrSplitPane getStatusBarSplitPane() {
        if (this.statusBarSplitPane == null) {
            this.statusBarSplitPane = new StrSplitPane();
            this.statusBarSplitPane.setStyleName("StrSplitPane");
            this.statusBarSplitPane.setFirstComponentOrientation(StrSplitPane.SplitPaneFirstComponentOrientation.down);
            this.statusBarSplitPane.setVerticalSeparatorPosition(new Extent(19, 1));
            this.statusBarSplitPane.setSeparatorHeight(new Extent(0));
            this.statusBarSplitPane.add((Component)this.getStatusBar());
            this.getMenuBarSplitPane().add((Component)this.statusBarSplitPane);
        }
        return this.statusBarSplitPane;
    }

    private StrSplitPane getTitleBarSplitPane() {
        if (this.titleBarSplitPane == null) {
            this.titleBarSplitPane = new StrSplitPane();
            this.titleBarSplitPane.setStyleName("StrSplitPane");
            this.titleBarSplitPane.setFont(new Font(new Font.Typeface("sans-serif"), 0, new Extent(9, 4)));
            this.titleBarSplitPane.setFirstComponentOrientation(StrSplitPane.SplitPaneFirstComponentOrientation.up);
            this.titleBarSplitPane.setVerticalSeparatorPosition(new Extent(22, 1));
            this.titleBarSplitPane.setSeparatorHeight(new Extent(1));
            this.titleBarSplitPane.add((Component)this.getTitleBar());
            super.add((Component)this.titleBarSplitPane);
        }
        return this.titleBarSplitPane;
    }

    private StrSplitPane getToolBarSplitPane() {
        if (this.toolBarSplitPane == null) {
            this.toolBarSplitPane = new StrSplitPane();
            this.toolBarSplitPane.setStyleName("StrSplitPane");
            this.toolBarSplitPane.setFirstComponentOrientation(StrSplitPane.SplitPaneFirstComponentOrientation.up);
            this.toolBarSplitPane.setVerticalSeparatorPosition(new Extent(33, 1));
            this.toolBarSplitPane.setSeparatorColor(new Color(145, 155, 156));
            this.toolBarSplitPane.setSeparatorHeight(new Extent(1));
            this.toolBarSplitPane.add((Component)this.getToolBar());
            this.getStatusBarSplitPane().add((Component)this.toolBarSplitPane);
        }
        return this.toolBarSplitPane;
    }

    private void initComponents() {
    }

    private void initListeners() {
        this.addTitleBarListener(new ActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand() != null && actionEvent.getActionCommand().equals("close")) {
                    AbstractPane.this.close();
                }
            }
        });
    }

    protected MenuBarPane getMenuBarPane() {
        if (this.menuBarPane == null) {
            this.menuBarPane = new MenuBarPane();
            this.menuBarPane.setStyleName("MenuBarPaneStyle");
            this.menuBarPane.setModel(this.getMenuBarModel());
        }
        return this.menuBarPane;
    }

    protected PropertyManager getPropertyManager() {
        if (this.propertyManager == null) {
            this.propertyManager = new PropertyManager();
        }
        return this.propertyManager;
    }

    protected ContentPane getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new StatusBar();
            this.statusBar.setCornerIconVisible(false);
        }
        return this.statusBar;
    }

    protected TitleBar getTitleBar() {
        if (this.titleBar == null) {
            this.titleBar = new TitleBar();
            this.titleBar.setStyleName("TitleBarStyle");
        }
        return this.titleBar;
    }

    protected ToolBar getToolBar() {
        if (this.buttonsPane == null) {
            this.buttonsPane = new ToolBar();
            SplitPaneLayoutData splitPaneLayoutData = new SplitPaneLayoutData();
            splitPaneLayoutData.setOverflow(1);
            this.buttonsPane.setLayoutData((LayoutData)splitPaneLayoutData);
        }
        return this.buttonsPane;
    }

    protected void initSessionObjects() {
    }

    protected void loadProperties() {
        try {
            this.getPropertyManager().loadProperties((Object)this);
        }
        catch (MessageException messageException) {
            log.error((Object)messageException.getMessage(), (Throwable)messageException);
        }
    }

    protected void saveProperties() {
        try {
            this.getPropertyManager().saveProperties((Object)this);
        }
        catch (MessageException messageException) {
            log.error((Object)messageException.getMessage(), (Throwable)messageException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DefaultCloseOperation {
        doNothing,
        exitOnClose;

    }
}

