/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.window.content;

import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.BaseApplication;
import pl.com.stream.echo.lib.component.window.ColumnsWindow;
import pl.com.stream.echo.lib.component.window.DialogWindow;
import pl.com.stream.echo.lib.component.window.FilterWindow;
import pl.com.stream.echo.lib.component.window.RowsPerPageWindow;
import pl.com.stream.echo.lib.component.window.SortWindow;
import pl.com.stream.echo.lib.component.window.StyleSheetWindow;
import pl.com.stream.echo.lib.component.window.content.AbstractPane;
import pl.com.stream.echo.lib.database.criterion.Criterion;
import pl.com.stream.echo.lib.event.RowsPerPageEvent;
import pl.com.stream.echo.lib.event.RowsPerPageListener;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.type.DefaultBrowserConfiguration;
import pl.com.stream.echo.lib.type.TJoinTable;
import pl.com.stream.echo.lib.type.TSelectedDetailsColumnList;
import pl.com.stream.echo.lib.type.TSelectedTableColumnList;
import pl.com.stream.echo.lib.type.TSelectedTableColumnOrderList;
import pl.com.stream.echo.lib.type.annotanion.LoadProperty;
import pl.com.stream.echo.lib.type.annotanion.SaveProperty;
import pl.com.stream.echo.lib.util.DBXmlSource;
import pl.com.stream.echo.lib.util.TableDataManager;
import pl.com.stream.echo.lib.util.XmlSource;

public class AbstractBrowserPane
extends AbstractPane {
    private static Logger log = Logger.getLogger(AbstractBrowserPane.class);
    private static final long serialVersionUID = 5437317800259546235L;
    private TableDataManager dataManager;
    private Integer rowsPerPage;
    private TSelectedTableColumnOrderList selectedColumnOrderList;
    private TSelectedDetailsColumnList selectedDetailsColumnList;
    private TSelectedTableColumnList selectedTableColumnList;

    public AbstractBrowserPane() {
        this.initComponents();
        this.initDataManager();
    }

    public TableDataManager getDataManager() {
        if (this.dataManager == null) {
            this.dataManager = new TableDataManager();
            this.dataManager.setPageCountingEnabled(this.isPageCountingEnabled());
        }
        return this.dataManager;
    }

    @SaveProperty(propertyName="rowsPerPage")
    public Integer getResRowsPerPage() {
        return this.getDataManager().getRowsPerPage();
    }

    @SaveProperty(propertyName="columnsOrder")
    public TSelectedTableColumnOrderList getResSelectedColumnOrderList() {
        return this.getDataManager().getSelectedColumnOrderList() == null ? new TSelectedTableColumnOrderList() : this.getDataManager().getSelectedColumnOrderList();
    }

    @SaveProperty(propertyName="selectedDetailsColumns")
    public TSelectedDetailsColumnList getResSelectedDetailsColumnList() {
        return this.getDataManager().getSelectedDetailsColumnList() == null ? this.getDefaultSelectedDetailsColumnList() : this.getDataManager().getSelectedDetailsColumnList();
    }

    @SaveProperty(propertyName="selectedColumns")
    public TSelectedTableColumnList getResSelectedTableColumnList() {
        return this.getDataManager().getSelectedTableColumnList() == null ? this.getDefaultSelectedTableColumnList() : this.getDataManager().getSelectedTableColumnList();
    }

    public TJoinTable initTreeAndGetMasterTable() {
        return new TJoinTable("TEST", "t");
    }

    public void refresh() {
        this.getDataManager().refresh();
    }

    public void refreshCurrentPage() {
        this.getDataManager().refreshCurrentPage();
    }

    @LoadProperty(propertyName="rowsPerPage")
    public void setResRowsPerPage(Integer n) {
        this.rowsPerPage = n;
    }

    @LoadProperty(propertyName="columnsOrder")
    public void setResSelectedColumnOrderList(TSelectedTableColumnOrderList tSelectedTableColumnOrderList) {
        this.selectedColumnOrderList = tSelectedTableColumnOrderList;
    }

    @LoadProperty(propertyName="selectedDetailsColumns")
    public void setResSelectedDetailsColumnList(TSelectedDetailsColumnList tSelectedDetailsColumnList) {
        this.selectedDetailsColumnList = tSelectedDetailsColumnList;
    }

    @LoadProperty(propertyName="selectedColumns")
    public void setResSelectedTableColumnList(TSelectedTableColumnList tSelectedTableColumnList) {
        this.selectedTableColumnList = tSelectedTableColumnList;
    }

    private void initComponents() {
    }

    protected DefaultBrowserConfiguration getDefaultBrowserConfiguration() {
        return new DefaultBrowserConfiguration();
    }

    protected TSelectedDetailsColumnList getDefaultSelectedDetailsColumnList() {
        DefaultBrowserConfiguration defaultBrowserConfiguration = this.getDefaultBrowserConfiguration();
        if (defaultBrowserConfiguration == null) {
            return null;
        }
        return defaultBrowserConfiguration.getSelectedDetailsColumnList();
    }

    protected TSelectedTableColumnList getDefaultSelectedTableColumnList() {
        DefaultBrowserConfiguration defaultBrowserConfiguration = this.getDefaultBrowserConfiguration();
        if (defaultBrowserConfiguration == null) {
            return null;
        }
        return defaultBrowserConfiguration.getSelectedTableColumnList();
    }

    protected TSelectedTableColumnOrderList getDefaultSelectedTableColumnOrderList() {
        DefaultBrowserConfiguration defaultBrowserConfiguration = this.getDefaultBrowserConfiguration();
        if (defaultBrowserConfiguration == null) {
            return null;
        }
        return defaultBrowserConfiguration.getSelectedTableColumnOrderList();
    }

    protected int getRowsPerPage() {
        if (this.rowsPerPage == null) {
            this.rowsPerPage = 10;
        }
        return this.rowsPerPage;
    }

    protected TSelectedTableColumnOrderList getSelectedColumnOrderList() {
        if (this.selectedColumnOrderList == null) {
            this.selectedColumnOrderList = this.getDefaultSelectedTableColumnOrderList();
        }
        return this.selectedColumnOrderList;
    }

    protected TSelectedDetailsColumnList getSelectedDetailsColumnList() {
        if (this.selectedDetailsColumnList == null) {
            this.selectedDetailsColumnList = this.getDefaultSelectedDetailsColumnList();
        }
        return this.selectedDetailsColumnList;
    }

    protected TSelectedTableColumnList getSelectedTableColumnList() {
        if (this.selectedTableColumnList == null) {
            this.selectedTableColumnList = this.getDefaultSelectedTableColumnList();
        }
        return this.selectedTableColumnList;
    }

    protected Criterion getSqlWhereProg() {
        return null;
    }

    protected void initDataManager() {
        this.getDataManager().initJoinMaker(this.initTreeAndGetMasterTable(), this.getSelectedTableColumnList(), this.getSelectedDetailsColumnList(), this.getSelectedColumnOrderList(), this.getSqlWhereProg());
        this.getDataManager().setRowsPerPage(this.getRowsPerPage());
    }

    protected boolean isPageCountingEnabled() {
        return false;
    }

    protected DefaultBrowserConfiguration loadDefaultBrowserConfiguration(Integer n) {
        XmlSource xmlSource = this.getPropertyManager().getXmlSource();
        this.getPropertyManager().setXmlSource(new DBXmlSource(0, n));
        DefaultBrowserConfiguration defaultBrowserConfiguration = new DefaultBrowserConfiguration();
        try {
            this.getPropertyManager().loadProperties(defaultBrowserConfiguration, ((Object)((Object)this)).getClass());
        }
        catch (MessageException messageException) {
            log.error((Object)messageException.getMessage(), (Throwable)messageException);
        }
        this.getPropertyManager().setXmlSource(xmlSource);
        return defaultBrowserConfiguration;
    }

    protected DefaultBrowserConfiguration loadDefaultBrowserConfiguration(Integer n, String string, String string2) {
        XmlSource xmlSource = this.getPropertyManager().getXmlSource();
        this.getPropertyManager().setXmlSource(new DBXmlSource(0, n));
        DefaultBrowserConfiguration defaultBrowserConfiguration = new DefaultBrowserConfiguration();
        try {
            this.getPropertyManager().loadProperties(defaultBrowserConfiguration, string, string2);
        }
        catch (MessageException messageException) {
            log.error((Object)messageException.getMessage(), (Throwable)messageException);
        }
        this.getPropertyManager().setXmlSource(xmlSource);
        return defaultBrowserConfiguration;
    }

    protected void openDetailsColumnsWindow() {
        final ColumnsWindow columnsWindow = new ColumnsWindow();
        columnsWindow.open();
        columnsWindow.setColumnWidthButtonVisible(false);
        columnsWindow.fillVisibleAndAvailableColumns(this.getDataManager().getVisibleDetailsColumnList(), this.getDataManager().getAllVisibleColumnList());
        columnsWindow.addActionListener(new ActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals(DialogWindow.ButtonCommand.OK.getActionCommand())) {
                    columnsWindow.close();
                    AbstractBrowserPane.this.getDataManager().setVisibleColumnListForSingleRow(columnsWindow.getVisibleColumnList());
                }
                if (actionEvent.getActionCommand().equals(DialogWindow.ButtonCommand.ANULUJ.getActionCommand())) {
                    columnsWindow.close();
                }
            }
        });
    }

    protected void openFilterWindow() {
        final FilterWindow filterWindow = new FilterWindow();
        filterWindow.setColumnList(this.getDataManager().getVisibleColumnList());
        filterWindow.open();
        filterWindow.addActionListener(new ActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals(DialogWindow.ButtonCommand.FILTRUJ.getActionCommand())) {
                    filterWindow.close();
                    AbstractBrowserPane.this.getDataManager().setWindowFilter(filterWindow.getCriterion());
                }
                if (actionEvent.getActionCommand().equals(DialogWindow.ButtonCommand.ZAMKNIJ.getActionCommand())) {
                    filterWindow.close();
                }
            }
        });
    }

    protected void openRowPerPageWindowContent() {
        final RowsPerPageWindow rowsPerPageWindow = new RowsPerPageWindow();
        rowsPerPageWindow.open();
        rowsPerPageWindow.setRowPerPage(this.getDataManager().getRowsPerPage());
        rowsPerPageWindow.addRowsPerPageListener(new RowsPerPageListener(){

            public void rowsPerPageChanged(RowsPerPageEvent rowsPerPageEvent) {
                AbstractBrowserPane.this.getDataManager().changeRowsPerPage(rowsPerPageWindow.getRowPerPage());
            }
        });
    }

    protected void openSortWindow() {
        final SortWindow sortWindow = new SortWindow();
        sortWindow.setVisibleColumnsAndColumnOrder(this.getDataManager().getSortableColumnList(), this.getDataManager().getSelectedColumnOrderList());
        sortWindow.open();
        sortWindow.addActionListener(new ActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals(DialogWindow.ButtonCommand.OK.getActionCommand())) {
                    sortWindow.close();
                    AbstractBrowserPane.this.getDataManager().setSelectedColumnOrderList(sortWindow.getSelectedColumnsOrder());
                }
                if (actionEvent.getActionCommand().equals(DialogWindow.ButtonCommand.ANULUJ.getActionCommand())) {
                    sortWindow.close();
                }
            }
        });
    }

    protected void openStyleSheetWindow() {
        final StyleSheetWindow styleSheetWindow = new StyleSheetWindow();
        styleSheetWindow.open();
        styleSheetWindow.addActionListener(new ActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals(DialogWindow.ButtonCommand.OK.getActionCommand())) {
                    styleSheetWindow.close();
                    BaseApplication.getApplication().setCurrentStyleSheet(styleSheetWindow.getSelectedStyleSheetName());
                }
                if (actionEvent.getActionCommand().equals(DialogWindow.ButtonCommand.ANULUJ.getActionCommand())) {
                    styleSheetWindow.close();
                }
            }
        });
    }

    protected void openTableColumnsWindow() {
        final ColumnsWindow columnsWindow = new ColumnsWindow();
        columnsWindow.open();
        columnsWindow.fillVisibleAndAvailableColumns(this.getDataManager().getVisibleColumnList(), this.getDataManager().getAllVisibleColumnList());
        columnsWindow.addActionListener(new ActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals(DialogWindow.ButtonCommand.OK.getActionCommand())) {
                    columnsWindow.close();
                    AbstractBrowserPane.this.getDataManager().setVisibleColumnList(columnsWindow.getVisibleColumnList());
                }
                if (actionEvent.getActionCommand().equals(DialogWindow.ButtonCommand.ANULUJ.getActionCommand())) {
                    columnsWindow.close();
                }
            }
        });
    }

    protected void saveDefaultBrowserConfiguration(DefaultBrowserConfiguration defaultBrowserConfiguration, Integer n) {
        XmlSource xmlSource = this.getPropertyManager().getXmlSource();
        this.getPropertyManager().setXmlSource(new DBXmlSource(0, n));
        try {
            this.getPropertyManager().saveProperties(defaultBrowserConfiguration, ((Object)((Object)this)).getClass());
        }
        catch (MessageException messageException) {
            log.error((Object)messageException.getMessage(), (Throwable)messageException);
        }
        this.getPropertyManager().setXmlSource(xmlSource);
    }

    protected void setSelectedColumnOrderList(TSelectedTableColumnOrderList tSelectedTableColumnOrderList) {
        this.getDataManager().setSelectedColumnOrderList(tSelectedTableColumnOrderList);
    }

    protected void setSelectedDetailsColumnList(TSelectedDetailsColumnList tSelectedDetailsColumnList) {
        this.getDataManager().setSelectedDetailsColumnList(tSelectedDetailsColumnList);
    }
}

