/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.window;

import java.util.EventListener;
import java.util.EventObject;
import nextapp.echo.app.Component;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import pl.com.stream.echo.lib.component.window.DialogWindow;
import pl.com.stream.echo.lib.component.window.MessageWindow;
import pl.com.stream.echo.lib.component.window.StrWindow;
import pl.com.stream.echo.lib.component.window.content.EditDialogContentPane;
import pl.com.stream.echo.lib.component.window.content.model.DataObjectProvider;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.exception.DAOException;

public abstract class EditDialogWindow
extends DialogWindow {
    private static final long serialVersionUID = 5849327188553962061L;
    private EditDialogContentPane contentPane;
    @ResourceContainer
    private Res res;

    public EditDialogWindow() {
        this.addActionListener(new InternalActionProcessor());
    }

    public void add(Component component) {
        this.getEditDialogContentPane().add(component);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.getEventListenerList().addListener(ChangeListener.class, (EventListener)changeListener);
    }

    public void close() {
        switch (this.getKlawiszFunkcyjny()) {
            case F3: 
            case F5: {
                if (!this.isModified()) {
                    super.close();
                    break;
                }
                MessageWindow messageWindow = new MessageWindow(this.res.questionTitle, this.res.doYouWantToCancelChanges, DialogWindow.ButtonMask.Tak_Nie);
                messageWindow.open();
                messageWindow.addActionListener(new ActionListener(){
                    private static final long serialVersionUID = 1L;

                    public void actionPerformed(ActionEvent actionEvent) {
                        StrWindow strWindow = (StrWindow)((Object)actionEvent.getSource());
                        if (DialogWindow.ButtonCommand.Tak.getActionCommand().equals(actionEvent.getActionCommand())) {
                            strWindow.close();
                            EditDialogWindow.super.close();
                        }
                    }
                });
                break;
            }
            default: {
                super.close();
            }
        }
    }

    public Object getDataObject() {
        return this.getEditDialogContentPane().getDataObject();
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.getEventListenerList().removeListener(ChangeListener.class, (EventListener)changeListener);
    }

    public void setDataObject(Object object) {
        this.getEditDialogContentPane().setDataObject(object);
    }

    public abstract void setDataObjectFromId(int var1) throws DAOException;

    public void setKlawiszFunkcyjny(DialogWindow.KlawiszFunkcyjny klawiszFunkcyjny) {
        super.setKlawiszFunkcyjny(klawiszFunkcyjny);
        this.getEditDialogContentPane().setEnabled(!klawiszFunkcyjny.equals((Object)DialogWindow.KlawiszFunkcyjny.F2));
    }

    protected void doSave() {
        switch (this.getKlawiszFunkcyjny()) {
            case F2: {
                this.close();
                break;
            }
            case F5: {
                if (this.isModified()) break;
                this.close();
                return;
            }
        }
        try {
            this.validateValues();
        }
        catch (MessageException messageException) {
            MessageWindow messageWindow = new MessageWindow(messageException.getTitle(), messageException.getMessage());
            messageWindow.open();
            return;
        }
        switch (this.getKlawiszFunkcyjny()) {
            case F3: {
                if (!this.getDataObjectProvider().doSave()) break;
                this.setModified(false);
                this.fireCreateObject();
                super.close();
                break;
            }
            case F5: {
                if (!this.getDataObjectProvider().doUpdate()) break;
                this.setModified(false);
                this.fireUpdateObject();
                super.close();
                break;
            }
        }
    }

    protected void fireCreateObject() {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(ChangeListener.class);
        ChangeEvent changeEvent = new ChangeEvent((Object)this, this.getEditDialogContentPane().getDataObject());
        for (EventListener eventListener : eventListenerArray) {
            ((ChangeListener)eventListener).createObject(changeEvent);
        }
    }

    protected void fireUpdateObject() {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(ChangeListener.class);
        ChangeEvent changeEvent = new ChangeEvent((Object)this, this.getEditDialogContentPane().getDataObject());
        for (EventListener eventListener : eventListenerArray) {
            ((ChangeListener)eventListener).updateObject(changeEvent);
        }
    }

    protected abstract DataObjectProvider getDataObjectProvider();

    protected EditDialogContentPane getEditDialogContentPane() {
        if (this.contentPane == null) {
            this.contentPane = this.initContentPane();
            super.add((Component)this.contentPane);
        }
        return this.contentPane;
    }

    protected abstract EditDialogContentPane initContentPane();

    protected boolean isModified() {
        return this.getEditDialogContentPane().isModified();
    }

    protected void setModified(boolean bl) {
        this.getEditDialogContentPane().setModified(bl);
    }

    protected void validateValues() throws MessageException {
        this.getEditDialogContentPane().validateValues();
    }

    private class Res {
        private String doYouWantToCancelChanges;
        private String questionTitle;

        private Res() {
        }
    }

    private class InternalActionProcessor
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        private InternalActionProcessor() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DialogWindow.ButtonCommand.ZAPISZ.getActionCommand().equals(actionEvent.getActionCommand())) {
                EditDialogWindow.this.doSave();
            } else if (DialogWindow.ButtonCommand.ZAMKNIJ.getActionCommand().equals(actionEvent.getActionCommand()) || DialogWindow.ButtonCommand.ANULUJ.getActionCommand().equals(actionEvent.getActionCommand())) {
                EditDialogWindow.this.close();
            }
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void cancel(ChangeEvent var1);

        public void createObject(ChangeEvent var1);

        public void updateObject(ChangeEvent var1);
    }

    public static class ChangeEvent
    extends EventObject {
        private static final long serialVersionUID = 3867852294740631463L;
        private final Object dataObjects;

        public ChangeEvent(Object object, Object object2) {
            super(object);
            this.dataObjects = object2;
        }

        public Object getDataObjects() {
            return this.dataObjects;
        }
    }
}

