/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.window;

import java.util.EventListener;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.ContentPane;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Grid;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.Insets;
import nextapp.echo.app.LayoutData;
import nextapp.echo.app.Row;
import nextapp.echo.app.SplitPane;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.layout.GridLayoutData;
import nextapp.echo.app.layout.RowLayoutData;
import nextapp.echo.app.layout.SplitPaneLayoutData;
import pl.com.stream.echo.lib.component.StrButton;
import pl.com.stream.echo.lib.component.button.StrButtonList;
import pl.com.stream.echo.lib.component.window.StrWindow;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class DialogWindow
extends StrWindow {
    @ResourceContainer
    private Res res;
    private static final long serialVersionUID = 7611449624935969358L;
    public static final String CLOSE_ACTION_COMMAND = "close";
    private Row rightButtonsRow;
    private Row leftButtonsRow;
    private ButtonMask buttonMask;
    private SplitPane splitPane;
    private ContentPane pane;
    private Grid buttonsGrid;
    private KlawiszFunkcyjny klawiszFunkcyjny;
    private final ActionListener actionForwarder = new ActionListener(){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            DialogWindow.this.fireActionPerformed(actionEvent.getActionCommand());
        }
    };

    public DialogWindow() {
        this(ButtonMask.OK_Anuluj);
    }

    public DialogWindow(ButtonMask buttonMask) {
        this(buttonMask, true);
    }

    public DialogWindow(ButtonMask buttonMask, boolean bl) {
        super(bl);
        this.buttonMask = buttonMask;
        this.klawiszFunkcyjny = KlawiszFunkcyjny.F2;
        this.initComponents();
    }

    public DialogWindow(KlawiszFunkcyjny klawiszFunkcyjny) {
        this(klawiszFunkcyjny, true);
    }

    public DialogWindow(KlawiszFunkcyjny klawiszFunkcyjny, boolean bl) {
        super(bl);
        this.klawiszFunkcyjny = klawiszFunkcyjny;
        switch (klawiszFunkcyjny) {
            case F2: {
                this.buttonMask = ButtonMask.Zamknij;
                break;
            }
            case F3: 
            case F5: {
                this.buttonMask = ButtonMask.Zapisz_Zamknij;
                break;
            }
        }
        this.initComponents();
    }

    public void add(Component component) {
        this.getContentPane().add(component);
    }

    public void addActionListener(ActionListener actionListener) {
        this.getEventListenerList().addListener(ActionListener.class, (EventListener)actionListener);
    }

    public void close() {
        super.close();
        this.fireActionPerformed(CLOSE_ACTION_COMMAND);
    }

    public ButtonMask getButtonMask() {
        if (this.buttonMask == null) {
            this.buttonMask = ButtonMask.OK;
        }
        return this.buttonMask;
    }

    public KlawiszFunkcyjny getKlawiszFunkcyjny() {
        if (this.klawiszFunkcyjny == null) {
            this.klawiszFunkcyjny = KlawiszFunkcyjny.F2;
        }
        return this.klawiszFunkcyjny;
    }

    public StrButtonList getLeftSideButtons() {
        return null;
    }

    public StrButtonList getRightSideButtons() {
        StrButtonList strButtonList = new StrButtonList();
        switch (this.buttonMask) {
            case Zaloguj: {
                strButtonList.addButton(this.res.loginButtonText, ButtonCommand.ZALOGUJ, this.res.okSaveIconEnabled, this.res.okSaveIconDisabled);
                break;
            }
            case Zaloguj_Anuluj: {
                strButtonList.addButton(this.res.loginButtonText, ButtonCommand.ZALOGUJ, this.res.okSaveIconEnabled, this.res.okSaveIconDisabled);
                strButtonList.addButton(this.res.cancelButtonText, ButtonCommand.ANULUJ, this.res.cancelIconEnabled, this.res.cancelIconDisabled);
                break;
            }
            case OK: {
                strButtonList.addButton(this.res.okButtonText, ButtonCommand.OK, this.res.okSaveIconEnabled, this.res.okSaveIconDisabled);
                break;
            }
            case Tak_Nie: {
                strButtonList.addButton(this.res.yesButtonText, ButtonCommand.Tak, this.res.okSaveIconEnabled, this.res.okSaveIconDisabled);
                strButtonList.addButton(this.res.noButtonText, ButtonCommand.Nie, this.res.cancelIconEnabled, this.res.cancelIconDisabled);
                break;
            }
            case Filtruj_Zamknij: {
                strButtonList.addButton(this.res.filterButtonText, ButtonCommand.FILTRUJ, this.res.okSaveIconEnabled, this.res.okSaveIconDisabled);
                strButtonList.addButton(this.res.closeButtonText, ButtonCommand.ZAMKNIJ, this.res.cancelIconEnabled, this.res.cancelIconDisabled);
                break;
            }
            case OK_Anuluj: {
                strButtonList.addButton(this.res.okButtonText, ButtonCommand.OK, this.res.okSaveIconEnabled, this.res.okSaveIconDisabled);
                strButtonList.addButton(this.res.cancelButtonText, ButtonCommand.ANULUJ, this.res.cancelIconEnabled, this.res.cancelIconDisabled);
                break;
            }
            case Zapisz_Zamknij: {
                strButtonList.addButton(this.res.saveButtonText, ButtonCommand.ZAPISZ, this.res.okSaveIconEnabled, this.res.okSaveIconDisabled);
                strButtonList.addButton(this.res.closeButtonText, ButtonCommand.ZAMKNIJ, this.res.cancelIconEnabled, this.res.cancelIconDisabled);
                break;
            }
            case Zapisz_Anuluj: {
                strButtonList.addButton(this.res.saveButtonText, ButtonCommand.ZAPISZ, this.res.okSaveIconEnabled, this.res.okSaveIconDisabled);
                strButtonList.addButton(this.res.cancelButtonText, ButtonCommand.ANULUJ, this.res.cancelIconEnabled, this.res.cancelIconDisabled);
                break;
            }
            case Zamknij: {
                strButtonList.addButton(this.res.closeButtonText, ButtonCommand.ZAMKNIJ, this.res.cancelIconEnabled, this.res.cancelIconDisabled);
                break;
            }
            case Przypomnij_haslo_Anuluj: {
                strButtonList.addButton(this.res.remindPasswordButtonText, ButtonCommand.PRZYPOMNIJ_HASLO, this.res.okSaveIconEnabled, this.res.okSaveIconDisabled, new Extent(130), new Extent(23), "StrButton_130x23_Style");
                strButtonList.addButton(this.res.cancelButtonText, ButtonCommand.ANULUJ, this.res.cancelIconEnabled, this.res.cancelIconDisabled);
                break;
            }
            case Dodaj_Zastap_Anuluj: {
                strButtonList.addButton(this.res.addButtonText, ButtonCommand.DODAJ, this.res.okSaveIconEnabled, this.res.okSaveIconDisabled);
                strButtonList.addButton(this.res.replaceButtonText, ButtonCommand.ZASTAP, this.res.cancelIconEnabled, this.res.cancelIconDisabled);
                strButtonList.addButton(this.res.cancelButtonText, ButtonCommand.ANULUJ, this.res.cancelIconEnabled, this.res.cancelIconDisabled);
            }
        }
        return strButtonList;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.getEventListenerList().removeListener(ActionListener.class, (EventListener)actionListener);
    }

    public void setButtonMask(ButtonMask buttonMask) {
        this.buttonMask = buttonMask;
        this.reloadButtons();
    }

    public void setKlawiszFunkcyjny(KlawiszFunkcyjny klawiszFunkcyjny) {
        this.klawiszFunkcyjny = klawiszFunkcyjny;
        switch (klawiszFunkcyjny) {
            case F2: {
                this.buttonMask = ButtonMask.Zamknij;
                break;
            }
            case F3: 
            case F5: {
                this.buttonMask = ButtonMask.Zapisz_Anuluj;
                break;
            }
        }
        this.setButtonMask(this.buttonMask);
    }

    private Grid getButtonsGrid() {
        if (this.buttonsGrid == null) {
            this.buttonsGrid = new Grid();
            this.buttonsGrid.setColumnWidth(0, new Extent(99, 2));
            this.buttonsGrid.setColumnWidth(1, new Extent(1, 2));
            this.buttonsGrid.setOrientation(0);
            this.buttonsGrid.setSize(2);
            SplitPaneLayoutData splitPaneLayoutData = new SplitPaneLayoutData();
            splitPaneLayoutData.setOverflow(1);
            this.buttonsGrid.setLayoutData((LayoutData)splitPaneLayoutData);
            this.buttonsGrid.add((Component)this.getLeftButtonsRow());
            this.buttonsGrid.add((Component)this.getRightButtonsRow());
        }
        return this.buttonsGrid;
    }

    private ContentPane getContentPane() {
        if (this.pane == null) {
            this.pane = new ContentPane();
            this.getSplitPane().add((Component)this.pane);
        }
        return this.pane;
    }

    private Row getLeftButtonsRow() {
        if (this.leftButtonsRow == null) {
            this.leftButtonsRow = new Row();
            this.leftButtonsRow.setInsets(new Insets(new Extent(0, 1), new Extent(3, 1), new Extent(0, 1), new Extent(3, 1)));
            GridLayoutData gridLayoutData = new GridLayoutData();
            gridLayoutData.setAlignment(new Alignment(3, 4));
            this.leftButtonsRow.setLayoutData((LayoutData)gridLayoutData);
            if (this.getLeftSideButtons() != null) {
                RowLayoutData rowLayoutData = new RowLayoutData();
                rowLayoutData.setAlignment(new Alignment(4, 4));
                rowLayoutData.setInsets(new Insets(3, 0, 0, 0));
                for (StrButton strButton : this.getLeftSideButtons()) {
                    if (strButton.getStyleName() == null) {
                        strButton.setStyleName("StrButtonStyle");
                    }
                    strButton.setLayoutData((LayoutData)rowLayoutData);
                    strButton.addActionListener(this.actionForwarder);
                    this.leftButtonsRow.add((Component)strButton);
                }
            }
        }
        return this.leftButtonsRow;
    }

    private Row getRightButtonsRow() {
        if (this.rightButtonsRow == null) {
            this.rightButtonsRow = new Row();
            this.rightButtonsRow.setInsets(new Insets(new Extent(0, 1), new Extent(3, 1), new Extent(3, 1), new Extent(3, 1)));
            GridLayoutData gridLayoutData = new GridLayoutData();
            gridLayoutData.setAlignment(new Alignment(5, 4));
            this.rightButtonsRow.setLayoutData((LayoutData)gridLayoutData);
            if (this.getRightSideButtons() != null) {
                RowLayoutData rowLayoutData = new RowLayoutData();
                rowLayoutData.setAlignment(new Alignment(4, 4));
                rowLayoutData.setInsets(new Insets(3, 0, 0, 0));
                for (StrButton strButton : this.getRightSideButtons()) {
                    if (strButton.getStyleName() == null) {
                        strButton.setStyleName("StrButtonStyle");
                    }
                    strButton.setLayoutData((LayoutData)rowLayoutData);
                    strButton.addActionListener(this.actionForwarder);
                    this.rightButtonsRow.add((Component)strButton);
                }
            }
        }
        return this.rightButtonsRow;
    }

    private SplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new SplitPane();
            this.splitPane.setSeparatorHeight(new Extent(1, 1));
            this.splitPane.setOrientation(5);
            this.splitPane.setSeparatorColor(new Color(11315353));
            this.splitPane.setSeparatorPosition(new Extent(29, 1));
            this.splitPane.add((Component)this.getButtonsGrid());
            super.add((Component)this.splitPane);
        }
        return this.splitPane;
    }

    private void initComponents() {
        this.setModal(true);
    }

    private void reloadButtons() {
        RowLayoutData rowLayoutData;
        this.getLeftButtonsRow().removeAll();
        this.getRightButtonsRow().removeAll();
        if (this.getLeftSideButtons() != null) {
            rowLayoutData = new RowLayoutData();
            rowLayoutData.setAlignment(new Alignment(4, 4));
            rowLayoutData.setInsets(new Insets(3, 0, 0, 0));
            for (StrButton strButton : this.getLeftSideButtons()) {
                if (strButton.getStyleName() == null) {
                    strButton.setStyleName("StrButtonStyle");
                }
                strButton.setLayoutData((LayoutData)rowLayoutData);
                strButton.addActionListener(this.actionForwarder);
                this.leftButtonsRow.add((Component)strButton);
            }
        }
        if (this.getRightSideButtons() != null) {
            rowLayoutData = new RowLayoutData();
            rowLayoutData.setAlignment(new Alignment(4, 4));
            rowLayoutData.setInsets(new Insets(3, 0, 0, 0));
            for (StrButton strButton : this.getRightSideButtons()) {
                if (strButton.getStyleName() == null) {
                    strButton.setStyleName("StrButtonStyle");
                }
                strButton.setLayoutData((LayoutData)rowLayoutData);
                strButton.addActionListener(this.actionForwarder);
                this.rightButtonsRow.add((Component)strButton);
            }
        }
    }

    protected void fireActionPerformed(String string) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(ActionListener.class);
        ActionEvent actionEvent = new ActionEvent((Object)this, string);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((ActionListener)eventListenerArray[i]).actionPerformed(actionEvent);
        }
    }

    protected ActionListener getInternalActionForwarder() {
        return this.actionForwarder;
    }

    private class Res {
        private String addButtonText;
        private String cancelButtonText;
        private String closeButtonText;
        private String filterButtonText;
        private String loginButtonText;
        private String noButtonText;
        private String okButtonText;
        private String remindPasswordButtonText;
        private String replaceButtonText;
        private String saveButtonText;
        private String yesButtonText;
        private ImageReference cancelIconDisabled;
        private ImageReference cancelIconEnabled;
        private ImageReference okSaveIconDisabled;
        private ImageReference okSaveIconEnabled;

        private Res() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KlawiszFunkcyjny {
        F2,
        F3,
        F5,
        F8;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ButtonMask {
        Zaloguj,
        Zaloguj_Anuluj,
        OK,
        OK_Anuluj,
        Tak_Nie,
        Zapisz_Anuluj,
        Zapisz_Zamknij,
        Filtruj_Zamknij,
        Zamknij,
        Przypomnij_haslo_Anuluj,
        Dodaj_Zastap_Anuluj;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ButtonCommand {
        ZALOGUJ("zaloguj"),
        OK("ok"),
        ANULUJ("anuluj"),
        Tak("tak"),
        Nie("nie"),
        FILTRUJ("filtruj"),
        ZAMKNIJ("zamknij"),
        ZAPISZ("zapisz"),
        PRZYPOMNIJ_HASLO("przypomnijHaslo"),
        DODAJ("dodaj"),
        ZASTAP("zastap");

        private String actionCommand;

        private ButtonCommand(String string2) {
            this.actionCommand = string2;
        }

        public String getActionCommand() {
            return this.actionCommand;
        }
    }
}

