/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.window;

import java.util.EventListener;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import pl.com.stream.echo.lib.component.window.DialogWindow;
import pl.com.stream.echo.lib.component.window.content.ColumnPane;
import pl.com.stream.echo.lib.event.ColumnPropertiesEvent;
import pl.com.stream.echo.lib.event.ColumnPropertiesListener;
import pl.com.stream.echo.lib.type.column.ITableColumn;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class ColumnWindow
extends DialogWindow {
    private static final long serialVersionUID = 7493145057516607110L;
    private ColumnPane visibleColumnPane;
    @ResourceContainer
    private Res res;
    private final ActionListener actionProcessor = new ActionListener(){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            ColumnWindow.this.close();
            ColumnWindow.this.fireRowsPerPageChanged(ColumnWindow.this.visibleColumnPane.getColumnSize());
        }
    };

    public ColumnWindow() {
        super(DialogWindow.ButtonMask.OK_Anuluj);
        this.initComponents();
        this.initResources();
        this.initListeners();
    }

    public void addColumnPropertiesListener(ColumnPropertiesListener columnPropertiesListener) {
        this.getEventListenerList().addListener(ColumnPropertiesListener.class, (EventListener)columnPropertiesListener);
    }

    public Extent getDefaultHeight() {
        return new Extent(150);
    }

    public Extent getDefaultMaximumHeight() {
        return this.getDefaultHeight();
    }

    public Extent getDefaultMaximumWidth() {
        return this.getDefaultWidth();
    }

    public Extent getDefaultMinimumHeight() {
        return this.getDefaultHeight();
    }

    public Extent getDefaultMinimumWidth() {
        return this.getDefaultWidth();
    }

    public Extent getDefaultWidth() {
        return new Extent(315);
    }

    public void removeColumnPropertiesListener(ColumnPropertiesListener columnPropertiesListener) {
        this.getEventListenerList().removeListener(ColumnPropertiesListener.class, (EventListener)columnPropertiesListener);
    }

    public void setColumn(ITableColumn iTableColumn) {
        this.visibleColumnPane.setColumn(iTableColumn);
    }

    private void fireRowsPerPageChanged(Extent extent) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(ColumnPropertiesListener.class);
        ColumnPropertiesEvent columnPropertiesEvent = new ColumnPropertiesEvent((Object)this, extent);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((ColumnPropertiesListener)eventListenerArray[i]).columnPropertiesChanged(columnPropertiesEvent);
        }
    }

    private void initComponents() {
        this.setStyleName("StrWindowSmallStyle");
        this.setResizable(false);
        this.visibleColumnPane = new ColumnPane();
        this.add((Component)this.visibleColumnPane);
    }

    private void initListeners() {
        this.visibleColumnPane.addColumnSizeTextFieldActionListener(this.actionProcessor);
        this.addActionListener(new ActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogWindow.ButtonCommand.OK.getActionCommand().equals(actionEvent.getActionCommand())) {
                    ColumnWindow.this.close();
                    ColumnWindow.this.fireRowsPerPageChanged(ColumnWindow.this.visibleColumnPane.getColumnSize());
                }
                if (DialogWindow.ButtonCommand.ANULUJ.getActionCommand().equals(actionEvent.getActionCommand())) {
                    ColumnWindow.this.close();
                }
            }
        });
    }

    private void initResources() {
        this.setTitle(this.res.title);
        this.setIcon(this.res.icon);
    }

    private class Res {
        private String title;
        private ImageReference icon;

        private Res() {
        }
    }
}

