/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import nextapp.echo.app.ImageReference;
import pl.com.stream.echo.lib.component.tree.TreeNode;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeNode
implements TreeNode {
    private List<TreeNode> childrens;
    private final ImageReference folderIcon;
    private ImageReference icon;
    private final String label;
    private final ImageReference leafIcon;
    @ResourceContainer
    private Res res;
    private final Object userObject;

    public DefaultTreeNode(Object object) {
        this(object, null, null);
    }

    public DefaultTreeNode(Object object, ImageReference imageReference) {
        this(object, null, imageReference);
    }

    public DefaultTreeNode(Object object, String string) {
        this(object, string, null);
    }

    public DefaultTreeNode(Object object, String string, ImageReference imageReference) {
        ResourceManager.bind((Object)this, (Locale)ClientLocale.getCurrent());
        this.userObject = object;
        this.label = string;
        this.icon = imageReference;
        this.leafIcon = this.res.treeLeafIcon;
        this.folderIcon = this.res.treeFolderIcon;
    }

    @Override
    public void addChild(TreeNode treeNode) {
        this.getChildrens().add(treeNode);
    }

    @Override
    public TreeNode getChildAt(int n) {
        if (n >= 0 && n < this.getChildCount()) {
            return this.getChildrens().get(n);
        }
        return null;
    }

    @Override
    public int getChildCount() {
        return this.getChildrens().size();
    }

    @Override
    public List<TreeNode> getChildrens() {
        if (this.childrens == null) {
            this.childrens = new ArrayList<TreeNode>();
        }
        return this.childrens;
    }

    @Override
    public ImageReference getIcon() {
        if (this.icon == null) {
            if (this.isLeaf()) {
                return this.leafIcon;
            }
            return this.folderIcon;
        }
        return this.icon;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.getChildrens().indexOf(treeNode);
    }

    @Override
    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.getUserObject() != null) {
            return this.getUserObject().toString();
        }
        return "";
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public void setIcon(ImageReference imageReference) {
        this.icon = imageReference;
    }

    private class Res {
        private ImageReference treeFolderIcon;
        private ImageReference treeLeafIcon;

        private Res() {
        }
    }
}

