/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.table;

import java.util.List;
import java.util.Locale;
import nextapp.echo.app.Button;
import nextapp.echo.app.Component;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.Table;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.table.TableCellRenderer;
import pl.com.stream.echo.lib.component.StrButton;
import pl.com.stream.echo.lib.component.table.SortableTableModel;
import pl.com.stream.echo.lib.type.TSelectedTableColumnOrder;
import pl.com.stream.echo.lib.type.column.ITableColumn;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class SortableTableHeaderRenrerer
implements TableCellRenderer {
    private static final long serialVersionUID = -1080873301892191734L;
    @ResourceContainer
    private Res res;

    public SortableTableHeaderRenrerer() {
        ResourceManager.bind((Object)this, (Locale)ClientLocale.getCurrent());
    }

    public Component getTableCellRendererComponent(Table table, Object object, int n, int n2) {
        if (table.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)table.getModel();
            return this.getSortButton((String)object, n, sortableTableModel);
        }
        return null;
    }

    private Button getSortButton(String string, final int n, final SortableTableModel sortableTableModel) {
        StrButton strButton = new StrButton();
        strButton.setText(string);
        strButton.setStyleName("TableColumnHeaderStyle");
        List<TSelectedTableColumnOrder> list = sortableTableModel.getColumnsOrder();
        final ITableColumn iTableColumn = sortableTableModel.getColumnIdentifier(n);
        if (list != null && iTableColumn != null) {
            for (int i = 0; i < list.size(); ++i) {
                TSelectedTableColumnOrder tSelectedTableColumnOrder = list.get(i);
                if (!tSelectedTableColumnOrder.equals(iTableColumn)) continue;
                ImageReference imageReference = null;
                switch (tSelectedTableColumnOrder.getOrderType()) {
                    case ASC: {
                        imageReference = this.res.arrowUpIcon;
                        break;
                    }
                    case DESC: {
                        imageReference = this.res.arrowDownIcon;
                        break;
                    }
                }
                if (list.size() > 1) {
                    strButton.setText(iTableColumn.getLabel() + " (" + (i + 1) + ")");
                }
                strButton.setIcon(imageReference);
            }
        }
        strButton.addActionListener(new ActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (iTableColumn != null && iTableColumn.getFieldDef() != null && iTableColumn.isSortable()) {
                    boolean bl = sortableTableModel.isCurrentSortAscending();
                    sortableTableModel.sortByColumn(n, !bl);
                }
            }
        });
        return strButton;
    }

    private class Res {
        private ImageReference arrowDownIcon;
        private ImageReference arrowUpIcon;

        private Res() {
        }
    }
}

