/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.table;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import nextapp.echo.app.table.AbstractTableModel;
import nextapp.echo.app.table.DefaultTableColumnModel;
import nextapp.echo.app.table.TableColumn;
import nextapp.echo.app.table.TableColumnModel;
import pl.com.stream.echo.lib.component.table.SortableTableModel;
import pl.com.stream.echo.lib.event.SortEvent;
import pl.com.stream.echo.lib.event.SortListener;
import pl.com.stream.echo.lib.type.TSelectedTableColumnOrder;
import pl.com.stream.echo.lib.type.TTableObject;
import pl.com.stream.echo.lib.type.column.ITableColumn;
import pl.com.stream.echo.lib.type.sql.TSqlOrderByObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSortableTableModel
extends AbstractTableModel
implements SortableTableModel {
    private static final long serialVersionUID = 4669554348328249214L;
    private boolean ascending;
    private TableColumnModel columnModel;
    private List<TSelectedTableColumnOrder> columnsOrder;
    private TTableObject tableObject;

    public DefaultSortableTableModel() {
    }

    public DefaultSortableTableModel(TableColumnModel tableColumnModel) {
        this.setColumnModel(tableColumnModel);
    }

    @Override
    public void addRow(Object object) {
        this.getTableObject().add(object);
        this.fireTableDataChanged();
    }

    @Override
    public void addRows(List<Object> list) {
        this.getTableObject().addAll(list);
        this.fireTableDataChanged();
    }

    @Override
    public void addSortListener(SortListener sortListener) {
        this.getEventListenerList().addListener(SortListener.class, (EventListener)sortListener);
    }

    @Override
    public void clearTable() {
        this.getTableObject().clear();
        this.fireTableDataChanged();
    }

    @Override
    public List<Object> getAllRows() {
        return (List)this.getTableObject().clone();
    }

    public Class<? extends TableColumn> getColumnClass(int n) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        return tableColumn != null ? tableColumn.getClass() : null;
    }

    public int getColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    @Override
    public ITableColumn getColumnIdentifier(int n) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        if (tableColumn.getIdentifier() instanceof ITableColumn) {
            ITableColumn iTableColumn = (ITableColumn)tableColumn.getIdentifier();
            return iTableColumn;
        }
        return null;
    }

    @Override
    public TableColumnModel getColumnModel() {
        if (this.columnModel == null) {
            this.columnModel = new DefaultTableColumnModel();
        }
        return this.columnModel;
    }

    public String getColumnName(int n) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        if (tableColumn != null && tableColumn.getHeaderValue() != null) {
            return tableColumn.getHeaderValue().toString();
        }
        return null;
    }

    @Override
    public List<TSelectedTableColumnOrder> getColumnsOrder() {
        if (this.columnsOrder == null) {
            this.columnsOrder = new ArrayList<TSelectedTableColumnOrder>();
        }
        return this.columnsOrder;
    }

    @Override
    public Object getRow(int n) {
        if (n >= 0 && n < this.getTableObject().size()) {
            return this.getTableObject().get(n);
        }
        return null;
    }

    public int getRowCount() {
        return this.getTableObject() == null ? 0 : this.getTableObject().size();
    }

    @Override
    public TTableObject getTableObject() {
        if (this.tableObject == null) {
            this.tableObject = new TTableObject();
        }
        return this.tableObject;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 < this.getTableObject().size()) {
            Object e = this.getTableObject().get(n2);
            if (e instanceof List) {
                List list = (List)e;
                if (n < list.size()) {
                    return list.get(n);
                }
                return null;
            }
            return e;
        }
        return null;
    }

    @Override
    public int indexOf(Object object) {
        return this.getTableObject().indexOf(object);
    }

    @Override
    public boolean isCurrentSortAscending() {
        return this.ascending;
    }

    @Override
    public int moveRow(int n, int n2) {
        if (n2 >= 0 && n2 < this.getTableObject().size()) {
            Object e = this.getTableObject().get(n);
            this.getTableObject().remove(n);
            this.getTableObject().add(n2, e);
            this.fireTableDataChanged();
            return n2;
        }
        return n;
    }

    @Override
    public void removeRow(int n) {
        if (n >= 0 && n < this.getTableObject().size()) {
            this.getTableObject().remove(n);
            this.fireTableDataChanged();
        }
    }

    @Override
    public int removeRow(Object object) {
        int n = this.getTableObject().indexOf(object);
        if (n > -1) {
            this.getTableObject().remove(object);
            this.fireTableDataChanged();
        }
        return n;
    }

    @Override
    public void removeSortListener(SortListener sortListener) {
        this.getEventListenerList().removeListener(SortListener.class, (EventListener)sortListener);
    }

    @Override
    public void setColumnModel(TableColumnModel tableColumnModel) {
        this.columnModel = tableColumnModel;
    }

    @Override
    public void setColumnsOrder(List<TSelectedTableColumnOrder> list) {
        this.columnsOrder = list;
        if (list.size() > 0) {
            TSqlOrderByObject.OrderTypes orderTypes = list.get(0).getOrderType();
            switch (orderTypes) {
                case ASC: {
                    this.ascending = true;
                    break;
                }
                case DESC: {
                    this.ascending = false;
                    break;
                }
            }
        }
    }

    @Override
    public void setTableObject(TTableObject tTableObject) {
        this.tableObject = tTableObject;
        this.fireTableDataChanged();
    }

    @Override
    public void sortByColumn(int n, boolean bl) {
        EventListener[] eventListenerArray;
        Object object;
        if (this.getColumnsOrder() != null && n >= 0 && n < this.getColumnsOrder().size()) {
            object = this.getColumnsOrder().get(n);
            ((TSelectedTableColumnOrder)object).setOrderType(bl ? TSqlOrderByObject.OrderTypes.DESC : TSqlOrderByObject.OrderTypes.ASC);
        }
        object = new SortEvent(this, n, bl);
        for (EventListener eventListener : eventListenerArray = this.getEventListenerList().getListeners(SortListener.class)) {
            ((SortListener)eventListener).sortPerformed((SortEvent)object);
        }
    }

    @Override
    public void updateRow(Object object, Object object2) {
        if (!object.equals(object2)) {
            int n = this.getTableObject().indexOf(object);
            this.getTableObject().remove(n);
            this.getTableObject().add(n, object2);
            this.fireTableDataChanged();
        }
    }
}

