/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.panels;

import java.util.EventListener;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Column;
import nextapp.echo.app.Component;
import nextapp.echo.app.ContentPane;
import nextapp.echo.app.Extent;
import nextapp.echo.app.LayoutData;
import nextapp.echo.app.Row;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.layout.ColumnLayoutData;
import nextapp.echo.app.layout.RowLayoutData;
import pl.com.stream.echo.lib.component.button.group.StrButtonGroupRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBar
extends ContentPane {
    private static final long serialVersionUID = -2912202434717091656L;
    private final ActionListener actionProcessor = new ActionListener(){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            EventListener[] eventListenerArray = ToolBar.this.getEventListenerList().getListeners(ActionListener.class);
            ActionEvent actionEvent2 = new ActionEvent((Object)this, actionEvent.getActionCommand());
            for (int i = 0; i < eventListenerArray.length; ++i) {
                ((ActionListener)eventListenerArray[i]).actionPerformed(actionEvent2);
            }
        }
    };
    private Row leftButtonsRow;
    private Row rightButtonsRow;

    public ToolBar() {
        this.initComponents();
    }

    public void addActionListener(ActionListener actionListener) {
        this.getEventListenerList().addListener(ActionListener.class, (EventListener)actionListener);
    }

    public void addButtonGroupOnLeftSide(StrButtonGroupRow strButtonGroupRow) {
        if (strButtonGroupRow != null) {
            strButtonGroupRow.addActionListener(this.actionProcessor);
            this.leftButtonsRow.add((Component)strButtonGroupRow);
        }
    }

    public void addButtonGroupOnLeftSide(StrButtonGroupRow strButtonGroupRow, int n) {
        if (strButtonGroupRow != null) {
            strButtonGroupRow.addActionListener(this.actionProcessor);
            this.leftButtonsRow.add((Component)strButtonGroupRow, n);
        }
    }

    public void addButtonGroupOnRightSide(StrButtonGroupRow strButtonGroupRow) {
        if (strButtonGroupRow != null) {
            strButtonGroupRow.addActionListener(this.actionProcessor);
            this.rightButtonsRow.add((Component)strButtonGroupRow);
        }
    }

    public void addButtonGroupOnRightSide(StrButtonGroupRow strButtonGroupRow, int n) {
        if (strButtonGroupRow != null) {
            strButtonGroupRow.addActionListener(this.actionProcessor);
            this.rightButtonsRow.add((Component)strButtonGroupRow, n);
        }
    }

    public StrButtonGroupRow getButtonGroupOnLeftSide(Class<? extends StrButtonGroupRow> clazz) {
        StrButtonGroupRow strButtonGroupRow = null;
        if (this.leftButtonsRow.getComponentCount() > 0) {
            for (int i = 0; i < this.leftButtonsRow.getComponentCount(); ++i) {
                if (!this.leftButtonsRow.getComponent(i).getClass().equals(clazz)) continue;
                strButtonGroupRow = (StrButtonGroupRow)this.leftButtonsRow.getComponent(i);
                break;
            }
        }
        return strButtonGroupRow;
    }

    public StrButtonGroupRow getButtonGroupOnLeftSide(int n) {
        StrButtonGroupRow strButtonGroupRow = null;
        if (n < this.leftButtonsRow.getComponentCount() && n >= 0 && this.leftButtonsRow.getComponent(n) instanceof StrButtonGroupRow) {
            strButtonGroupRow = (StrButtonGroupRow)this.leftButtonsRow.getComponent(n);
        }
        return strButtonGroupRow;
    }

    public StrButtonGroupRow getButtonGroupOnRightSide(Class<? extends StrButtonGroupRow> clazz) {
        StrButtonGroupRow strButtonGroupRow = null;
        if (this.rightButtonsRow.getComponentCount() > 0) {
            for (int i = 0; i < this.rightButtonsRow.getComponentCount(); ++i) {
                if (!this.rightButtonsRow.getComponent(i).getClass().equals(clazz)) continue;
                strButtonGroupRow = (StrButtonGroupRow)this.rightButtonsRow.getComponent(i);
                break;
            }
        }
        return strButtonGroupRow;
    }

    public StrButtonGroupRow getButtonGroupOnRightSide(int n) {
        StrButtonGroupRow strButtonGroupRow = null;
        if (n < this.rightButtonsRow.getComponentCount() && n >= 0 && this.rightButtonsRow.getComponent(n) instanceof StrButtonGroupRow) {
            strButtonGroupRow = (StrButtonGroupRow)this.rightButtonsRow.getComponent(n);
        }
        return strButtonGroupRow;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.getEventListenerList().removeListener(ActionListener.class, (EventListener)actionListener);
    }

    public void removeAllButtonGroups() {
        this.removeAllButtonGroupsOnLeftSide();
        this.removeAllButtonGroupsOnRightSide();
    }

    public void removeAllButtonGroupsOnLeftSide() {
        for (int i = 0; i < this.leftButtonsRow.getComponentCount(); ++i) {
            Component component = this.leftButtonsRow.getComponent(i);
            if (!(component instanceof StrButtonGroupRow)) continue;
            StrButtonGroupRow strButtonGroupRow = (StrButtonGroupRow)component;
            strButtonGroupRow.removeActionListener(this.actionProcessor);
        }
        this.leftButtonsRow.removeAll();
    }

    public void removeAllButtonGroupsOnRightSide() {
        for (int i = 0; i < this.rightButtonsRow.getComponentCount(); ++i) {
            Component component = this.rightButtonsRow.getComponent(i);
            if (!(component instanceof StrButtonGroupRow)) continue;
            StrButtonGroupRow strButtonGroupRow = (StrButtonGroupRow)component;
            strButtonGroupRow.removeActionListener(this.actionProcessor);
        }
        this.rightButtonsRow.removeAll();
    }

    public void removeButtonGroupOnLeftSide(Class<? extends StrButtonGroupRow> clazz) {
        int n = -1;
        if (this.leftButtonsRow.getComponentCount() > 0) {
            for (int i = 0; i < this.leftButtonsRow.getComponentCount(); ++i) {
                if (!this.leftButtonsRow.getComponent(i).getClass().equals(clazz)) continue;
                n = i;
                break;
            }
        }
        this.removeButtonGroupOnLeftSide(n);
    }

    public void removeButtonGroupOnLeftSide(int n) {
        if (n < this.leftButtonsRow.getComponentCount() && n >= 0) {
            Component component = this.leftButtonsRow.getComponent(n);
            if (component instanceof StrButtonGroupRow) {
                StrButtonGroupRow strButtonGroupRow = (StrButtonGroupRow)component;
                strButtonGroupRow.removeActionListener(this.actionProcessor);
            }
            this.leftButtonsRow.remove(n);
        }
    }

    public void removeButtonGroupOnRightSide(Class<? extends StrButtonGroupRow> clazz) {
        int n = -1;
        if (this.rightButtonsRow.getComponentCount() > 0) {
            for (int i = 0; i < this.rightButtonsRow.getComponentCount(); ++i) {
                if (!this.rightButtonsRow.getComponent(i).getClass().equals(clazz)) continue;
                n = i;
                break;
            }
        }
        this.removeButtonGroupOnRightSide(n);
    }

    public void removeButtonGroupOnRightSide(int n) {
        if (n < this.rightButtonsRow.getComponentCount() && n >= 0) {
            Component component = this.rightButtonsRow.getComponent(n);
            if (component instanceof StrButtonGroupRow) {
                StrButtonGroupRow strButtonGroupRow = (StrButtonGroupRow)component;
                strButtonGroupRow.removeActionListener(this.actionProcessor);
            }
            this.rightButtonsRow.remove(n);
        }
    }

    public void replaceButtonGroupOnLeftSide(Class<? extends StrButtonGroupRow> clazz, StrButtonGroupRow strButtonGroupRow) {
        int n = -1;
        if (this.leftButtonsRow.getComponentCount() > 0) {
            for (int i = 0; i < this.leftButtonsRow.getComponentCount(); ++i) {
                if (!clazz.isInstance(this.leftButtonsRow.getComponent(i))) continue;
                n = i;
                break;
            }
        }
        if (n >= 0) {
            this.removeButtonGroupOnLeftSide(n);
            this.addButtonGroupOnLeftSide(strButtonGroupRow, n);
        }
    }

    public void replaceButtonGroupOnRightSide(Class<? extends StrButtonGroupRow> clazz, StrButtonGroupRow strButtonGroupRow) {
        int n = -1;
        if (this.rightButtonsRow.getComponentCount() > 0) {
            for (int i = 0; i < this.rightButtonsRow.getComponentCount(); ++i) {
                if (!clazz.isInstance(this.rightButtonsRow.getComponent(i))) continue;
                n = i;
                break;
            }
        }
        if (n >= 0) {
            this.removeButtonGroupOnRightSide(n);
            this.addButtonGroupOnRightSide(strButtonGroupRow, n);
        }
    }

    private void initComponents() {
        this.setStyleName("ToolBarStyle");
        Row row = new Row();
        this.add((Component)row);
        Column column = new Column();
        RowLayoutData rowLayoutData = new RowLayoutData();
        rowLayoutData.setWidth(new Extent(100, 2));
        column.setLayoutData((LayoutData)rowLayoutData);
        row.add((Component)column);
        this.leftButtonsRow = new Row();
        this.leftButtonsRow.setAlignment(new Alignment(3, 0));
        ColumnLayoutData columnLayoutData = new ColumnLayoutData();
        columnLayoutData.setAlignment(new Alignment(3, 6));
        this.leftButtonsRow.setLayoutData((LayoutData)columnLayoutData);
        column.add((Component)this.leftButtonsRow);
        Column column2 = new Column();
        RowLayoutData rowLayoutData2 = new RowLayoutData();
        rowLayoutData2.setWidth(new Extent(50, 2));
        column2.setLayoutData((LayoutData)rowLayoutData2);
        row.add((Component)column2);
        this.rightButtonsRow = new Row();
        this.rightButtonsRow.setAlignment(new Alignment(5, 0));
        ColumnLayoutData columnLayoutData2 = new ColumnLayoutData();
        columnLayoutData2.setAlignment(new Alignment(5, 6));
        this.rightButtonsRow.setLayoutData((LayoutData)columnLayoutData2);
        column2.add((Component)this.rightButtonsRow);
    }
}

