/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.panels;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import nextapp.echo.app.ContentPane;
import nextapp.echo.app.Extent;
import nextapp.echo.app.FillImage;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.ResourceImageReference;
import nextapp.echo.app.StreamImageReference;
import org.apache.log4j.Logger;

public class LogoImagePane
extends ContentPane {
    public static final Extent DEFAULT_HEIGHT = new Extent(50);
    public static final Extent DEFAULT_WIDTH = new Extent(100);
    public static final String PROPERTY_LOGO_IMAGE = "logoImage";
    private static final Logger log = Logger.getLogger(LogoImagePane.class);
    private static final long serialVersionUID = -7135898219670867456L;
    private Extent height;
    private ImageReference logoImage;
    private Extent width;

    public Extent getHeight() {
        if (this.logoImage != null) {
            return this.height;
        }
        return DEFAULT_HEIGHT;
    }

    public ImageReference getLogoImage() {
        return (ImageReference)this.get(PROPERTY_LOGO_IMAGE);
    }

    public Extent getWidth() {
        if (this.logoImage != null) {
            return this.width;
        }
        return DEFAULT_WIDTH;
    }

    public void setLogoImage(ImageReference imageReference) {
        this.logoImage = imageReference;
        this.initLogoPaneSize(imageReference);
        this.set(PROPERTY_LOGO_IMAGE, imageReference);
        this.setBackgroundImage(new FillImage(imageReference));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLogoPaneSize(ImageReference imageReference) {
        if (imageReference instanceof ResourceImageReference) {
            ResourceImageReference resourceImageReference = (ResourceImageReference)imageReference;
            String string = resourceImageReference.getResource();
            InputStream inputStream = null;
            try {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
                if (inputStream == null) {
                    log.warn((Object)("Specified resource does not exist: " + string + "."));
                }
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                this.height = new Extent(bufferedImage.getHeight());
                this.width = new Extent(bufferedImage.getWidth());
                bufferedImage = null;
            }
            catch (IOException iOException) {
                log.error((Object)("Logo image reading error - " + iOException.getMessage() + "."), (Throwable)iOException);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else if (imageReference instanceof StreamImageReference) {
            StreamImageReference streamImageReference = (StreamImageReference)imageReference;
            this.height = streamImageReference.getHeight();
            this.width = streamImageReference.getWidth();
        }
    }
}

