/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.model;

import java.util.ArrayList;
import pl.com.stream.echo.lib.component.model.ButtonDescription;
import pl.com.stream.echo.lib.type.TSelectedTableColumnOrder;
import pl.com.stream.echo.lib.type.TSelectedTableColumnOrderList;
import pl.com.stream.echo.lib.type.column.ILabeledColumn;
import pl.com.stream.echo.lib.type.sql.TSqlOrderByObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonDescriptionList
extends ArrayList<ButtonDescription> {
    private static final long serialVersionUID = 8987968636330157095L;
    private final TSelectedTableColumnOrderList columnsOrder;
    private final OrderList orderList;
    private TSqlOrderByObject.OrderTypes orderType;
    private boolean singleColumn;

    public ButtonDescriptionList(TSelectedTableColumnOrderList tSelectedTableColumnOrderList) {
        this.columnsOrder = tSelectedTableColumnOrderList;
        this.orderList = new OrderList();
        for (int i = 0; i < tSelectedTableColumnOrderList.size(); ++i) {
            this.orderList.add(-1);
        }
    }

    public void addButton(ILabeledColumn iLabeledColumn) {
        Integer n = null;
        int n2 = super.size();
        for (int i = 0; i < this.columnsOrder.size(); ++i) {
            TSelectedTableColumnOrder tSelectedTableColumnOrder = (TSelectedTableColumnOrder)this.columnsOrder.get(i);
            if (!tSelectedTableColumnOrder.getTableAlias().equals(iLabeledColumn.getTableAlias()) || !tSelectedTableColumnOrder.getColumnName().equals(iLabeledColumn.getName())) continue;
            n = i;
            break;
        }
        if (n != null) {
            this.orderList.set(n, n2);
        }
        super.add(new ButtonDescription(iLabeledColumn, this.orderList.getOrderNumber(n2), n2));
    }

    public TSqlOrderByObject.OrderTypes getOrderType() {
        return this.orderType;
    }

    public TSelectedTableColumnOrderList getSelectedColumnsOrder() {
        TSelectedTableColumnOrderList tSelectedTableColumnOrderList = new TSelectedTableColumnOrderList();
        for (Integer n : this.orderList) {
            ButtonDescription buttonDescription = (ButtonDescription)this.get(n);
            ILabeledColumn iLabeledColumn = buttonDescription.getColumn();
            tSelectedTableColumnOrderList.addColumn(iLabeledColumn.getTableAlias(), iLabeledColumn.getName(), this.orderType);
        }
        return tSelectedTableColumnOrderList;
    }

    public boolean isSingleColumn() {
        return this.singleColumn;
    }

    public void setOrderType(TSqlOrderByObject.OrderTypes orderTypes) {
        this.orderType = orderTypes;
    }

    public void setSingleColumn(boolean bl) {
        this.singleColumn = bl;
        if (bl && this.orderList.size() > 0) {
            int n = (Integer)this.orderList.get(0);
            for (int i = 0; i < this.size(); ++i) {
                ButtonDescription buttonDescription = (ButtonDescription)this.get(i);
                if (i == n) continue;
                buttonDescription.setOrderNumber(null);
                buttonDescription.setSelected(false);
            }
            this.orderList.clear();
            this.orderList.add(n);
        }
    }

    public void updateButton(int n, boolean bl) {
        ButtonDescription buttonDescription = (ButtonDescription)super.get(n);
        if (bl) {
            if (this.singleColumn) {
                this.orderList.clear();
                this.orderList.add(buttonDescription.getModelIndex());
                this.clearButtonsSelection();
            } else {
                this.orderList.add(buttonDescription.getModelIndex());
            }
        } else if (buttonDescription.isSelected()) {
            this.orderList.remove(new Integer(buttonDescription.getModelIndex()));
        }
        buttonDescription.setSelected(bl);
        buttonDescription.setOrderNumber(this.orderList.getOrderNumber(buttonDescription.getModelIndex()));
        this.renumberButtons();
    }

    private void clearButtonsSelection() {
        for (int i = 0; i < this.size(); ++i) {
            ButtonDescription buttonDescription = (ButtonDescription)this.get(i);
            buttonDescription.setOrderNumber(null);
            buttonDescription.setSelected(false);
        }
    }

    private void renumberButtons() {
        for (int i = 0; i < this.size(); ++i) {
            ButtonDescription buttonDescription = (ButtonDescription)this.get(i);
            buttonDescription.setOrderNumber(null);
            for (int j = 0; j < this.orderList.size(); ++j) {
                if (!buttonDescription.isSelected() || i != (Integer)this.orderList.get(j)) continue;
                buttonDescription.setOrderNumber(j);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OrderList
    extends ArrayList<Integer> {
        private static final long serialVersionUID = -4901884664812491395L;

        private OrderList() {
        }

        public Integer getOrderNumber(int n) {
            Integer n2 = null;
            for (int i = 0; i < this.size(); ++i) {
                if ((Integer)this.get(i) != n) continue;
                n2 = i;
                break;
            }
            return n2;
        }
    }
}

