/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.model;

import java.text.MessageFormat;
import java.util.Locale;
import pl.com.stream.echo.lib.type.column.ILabeledColumn;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class ButtonDescription {
    private final ILabeledColumn column;
    private final int modelIndex;
    private Integer orderNumber;
    @ResourceContainer
    private Res res;
    private boolean selected;

    public ButtonDescription(ILabeledColumn iLabeledColumn, Integer n, int n2) {
        ResourceManager.bind((Object)this, (Locale)ClientLocale.getCurrent());
        this.column = iLabeledColumn;
        this.orderNumber = n;
        this.modelIndex = n2;
        this.selected = n != null;
    }

    public ILabeledColumn getColumn() {
        return this.column;
    }

    public String getLabel() {
        if (this.orderNumber == null) {
            return this.column.getLabel();
        }
        return this.column.getLabel() + " (" + (this.orderNumber + 1) + ")";
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public String getTableLabel() {
        return MessageFormat.format(this.res.tableLabel, this.column.getTableLabel());
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setOrderNumber(Integer n) {
        this.orderNumber = n;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public String toString() {
        return this.modelIndex + "." + this.getLabel() + " - " + this.selected;
    }

    private class Res {
        private String tableLabel;

        private Res() {
        }
    }
}

