/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.button.group;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.BitSet;
import java.util.EventListener;
import java.util.Locale;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Insets;
import nextapp.echo.app.LayoutData;
import nextapp.echo.app.Row;
import nextapp.echo.app.button.AbstractButton;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.layout.RowLayoutData;
import pl.com.stream.echo.lib.component.ButtonsSeparator;
import pl.com.stream.echo.lib.component.StrCheckBox;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.commons.reman.ResourceManager;

public class StrButtonGroupRow
extends Row {
    private static final long serialVersionUID = 3837763459198876435L;
    private final ActionListener actionForwarder = new ActionListener(){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            ActionEvent actionEvent2 = new ActionEvent((Object)StrButtonGroupRow.this, actionEvent.getActionCommand());
            StrButtonGroupRow.this.fireActionPerformed(actionEvent2);
        }
    };
    private Row buttonsRow;
    private BitSet enabledBitSet = new BitSet();
    private final PropertyChangeListener propertyChangeForwarder = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            StrButtonGroupRow.this.firePropertyChange(propertyChangeEvent);
        }
    };
    private BitSet selectedBitSet = new BitSet();
    private ButtonsSeparator separator;
    private BitSet visibleBitSet = new BitSet();

    public StrButtonGroupRow() {
        this.doBindResources();
        this.initComponents();
    }

    public void add(Component component) {
        this.getButtonsRow().add(component);
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.addActionListener(this.getActionForwarder());
            abstractButton.addPropertyChangeListener(this.getPropertyChangeForwarder());
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.getEventListenerList().addListener(ActionListener.class, (EventListener)actionListener);
    }

    public AbstractButton getButton(int n) {
        AbstractButton abstractButton = null;
        if (n >= 0 && n < this.getButtonsRow().getComponentCount() && this.getButtonsRow().getComponent(n) instanceof AbstractButton) {
            abstractButton = (AbstractButton)this.getButtonsRow().getComponent(n);
        }
        return abstractButton;
    }

    public BitSet getEnabledBitSet() {
        return this.enabledBitSet;
    }

    public BitSet getSelectedBitSet() {
        return this.selectedBitSet;
    }

    public BitSet getVisibleBitSet() {
        return this.visibleBitSet;
    }

    public void removeActionListener(ActionListener actionListener) {
        if (!this.hasEventListenerList()) {
            return;
        }
        this.getEventListenerList().removeListener(ActionListener.class, (EventListener)actionListener);
    }

    public void setEnabledButtonsBitSet(BitSet bitSet) {
        this.enabledBitSet = bitSet;
        int n = this.getButtonsRow().getComponentCount() - 1;
        if (this.enabledBitSet.length() <= n) {
            for (int i = 0; i < n; ++i) {
                this.getButtonsRow().getComponent(i + 1).setEnabled(this.enabledBitSet.get(i));
            }
        }
    }

    public void setSelectedButtonsBitSet(BitSet bitSet) {
        this.selectedBitSet = bitSet;
        int n = this.getButtonsRow().getComponentCount() - 1;
        if (this.selectedBitSet.length() <= n) {
            for (int i = 0; i < n; ++i) {
                if (!(this.getButtonsRow().getComponent(i + 1) instanceof StrCheckBox)) continue;
                StrCheckBox strCheckBox = (StrCheckBox)this.getButtonsRow().getComponent(i + 1);
                strCheckBox.setSelected(this.selectedBitSet.get(i));
            }
        }
    }

    public void setSeparatorStyleName(String string) {
        this.getButtonsSeparator().setStyleName(string);
    }

    public void setVisibleButtonsBitSet(BitSet bitSet) {
        this.visibleBitSet = bitSet;
        int n = this.getButtonsRow().getComponentCount() - 1;
        if (this.visibleBitSet.length() <= n) {
            for (int i = 0; i < n; ++i) {
                this.getButtonsRow().getComponent(i + 1).setVisible(this.visibleBitSet.get(i));
            }
        }
    }

    private void doBindResources() {
        ResourceManager.bind((Object)((Object)this), (Locale)ClientLocale.getCurrent());
    }

    private ButtonsSeparator getButtonsSeparator() {
        if (this.separator == null) {
            this.separator = new ButtonsSeparator();
        }
        return this.separator;
    }

    private void initComponents() {
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(ActionListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((ActionListener)eventListenerArray[i]).actionPerformed(actionEvent);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(PropertyChangeListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((PropertyChangeListener)eventListenerArray[i]).propertyChange(propertyChangeEvent);
        }
    }

    protected ActionListener getActionForwarder() {
        return this.actionForwarder;
    }

    protected Row getButtonsRow() {
        if (this.buttonsRow == null) {
            this.buttonsRow = new Row();
            RowLayoutData rowLayoutData = new RowLayoutData();
            rowLayoutData.setInsets(new Insets(new Extent(0, 1), new Extent(0, 1), new Extent(5, 1), new Extent(0, 1)));
            this.buttonsRow.setLayoutData((LayoutData)rowLayoutData);
            this.buttonsRow.add((Component)this.getButtonsSeparator());
            super.add((Component)this.buttonsRow);
        }
        return this.buttonsRow;
    }

    protected PropertyChangeListener getPropertyChangeForwarder() {
        return this.propertyChangeForwarder;
    }

    protected void updateEnabledBitSet() {
        int n = this.getButtonsRow().getComponentCount() - 1;
        if (this.enabledBitSet.length() <= n) {
            for (int i = 0; i < n; ++i) {
                this.enabledBitSet.set(i, this.getButtonsRow().getComponent(i + 1).isEnabled());
            }
        }
    }

    protected void updateSelectedBitSet() {
        int n = this.getButtonsRow().getComponentCount() - 1;
        if (this.visibleBitSet.length() <= n) {
            for (int i = 0; i < n; ++i) {
                if (!(this.getButtonsRow().getComponent(i + 1) instanceof StrCheckBox)) continue;
                StrCheckBox strCheckBox = (StrCheckBox)this.getButtonsRow().getComponent(i + 1);
                this.visibleBitSet.set(i, strCheckBox.isSelected());
            }
        }
    }

    protected void updateVisibleBitSet() {
        int n = this.getButtonsRow().getComponentCount() - 1;
        if (this.visibleBitSet.length() <= n) {
            for (int i = 0; i < n; ++i) {
                this.visibleBitSet.set(i, this.getButtonsRow().getComponent(i + 1).isVisible());
            }
        }
    }
}

