/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.button.group;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Column;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.Insets;
import nextapp.echo.app.LayoutData;
import nextapp.echo.app.Row;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.layout.ColumnLayoutData;
import nextapp.echo.app.layout.RowLayoutData;
import pl.com.stream.echo.lib.component.DateTextFieldGrid;
import pl.com.stream.echo.lib.component.StrComboBox;
import pl.com.stream.echo.lib.component.StrLabelMedium;
import pl.com.stream.echo.lib.component.StrSquareButton;
import pl.com.stream.echo.lib.component.StrTextField;
import pl.com.stream.echo.lib.component.button.group.StrButtonGroupRow;
import pl.com.stream.echo.lib.database.criterion.Criterion;
import pl.com.stream.echo.lib.database.criterion.Restrictions;
import pl.com.stream.echo.lib.event.SearchEvent;
import pl.com.stream.echo.lib.event.SearchListener;
import pl.com.stream.echo.lib.type.TFieldDef;
import pl.com.stream.echo.lib.type.column.EverywhereColumn;
import pl.com.stream.echo.lib.type.column.IBasicColumn;
import pl.com.stream.echo.lib.type.column.ILabeledColumn;
import pl.com.stream.echo.lib.type.column.ITableColumn;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchPanelGroup
extends StrButtonGroupRow {
    private static final long serialVersionUID = -7886330997581506677L;
    private final ActionListener actionProcessor = new ActionListener(){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals((Object)SearchPanelGroup.this.poleSelectField) && SearchPanelGroup.this.poleSelectField.getSelectedItem() instanceof ILabeledColumn) {
                ILabeledColumn iLabeledColumn = (ILabeledColumn)SearchPanelGroup.this.poleSelectField.getSelectedItem();
                SearchPanelGroup.this.setWarunekComponent(iLabeledColumn);
            }
            if (actionEvent.getSource().equals((Object)SearchPanelGroup.this.comboBox) && SearchPanelGroup.this.currentFieldDef != null) {
                SearchPanelGroup.this.comboBoxValuesListMap.put(SearchPanelGroup.this.currentFieldDef.getFieldName(), SearchPanelGroup.this.comboBox.getSelectedIndex());
            }
            if ("searchPanel".equals(actionEvent.getActionCommand())) {
                SearchPanelGroup.this.fireSearchPerformed();
            }
            if ("cancelSearchPanel".equals(actionEvent.getActionCommand())) {
                SearchPanelGroup.this.fireSearchCanceled();
            }
        }
    };
    private StrSquareButton cancelSearchButton;
    private List<ILabeledColumn> columnList;
    private StrComboBox comboBox;
    private final HashMap<String, Integer> comboBoxValuesListMap = new HashMap();
    private TFieldDef currentFieldDef;
    private DateTextFieldGrid dateTextFieldGrid;
    private final EverywhereColumn everywhereColumn = new EverywhereColumn();
    private StrComboBox poleSelectField;
    @ResourceContainer
    private Res res;
    private StrSquareButton searchButton;
    private StrLabelMedium searchLabel;
    private String statusMessage;
    private StrTextField textField;
    private Column warunekColumn;

    public SearchPanelGroup() {
        this.initComponents();
        this.initResources();
        this.initListeners();
    }

    public void addSearchListener(SearchListener searchListener) {
        this.getEventListenerList().addListener(SearchListener.class, (EventListener)searchListener);
    }

    public Criterion getCriterion() {
        Criterion criterion = null;
        Object object = this.poleSelectField.getSelectedItem();
        if (object instanceof ILabeledColumn) {
            Object object2;
            Object object3;
            Object object4 = null;
            if (this.warunekColumn.getComponent(0) instanceof StrTextField) {
                object3 = (StrTextField)this.warunekColumn.getComponent(0);
                object4 = object3.getText();
            }
            if (this.warunekColumn.getComponent(0) instanceof DateTextFieldGrid) {
                object3 = (DateTextFieldGrid)this.warunekColumn.getComponent(0);
                object4 = ((DateTextFieldGrid)((Object)object3)).getDateAsString();
            }
            if (this.warunekColumn.getComponent(0) instanceof StrComboBox && (object2 = (object3 = (StrComboBox)this.warunekColumn.getComponent(0)).getSelectedItem()) instanceof TFieldDef.TFieldDefValue) {
                TFieldDef.TFieldDefValue tFieldDefValue = (TFieldDef.TFieldDefValue)object2;
                object4 = tFieldDefValue != null ? tFieldDefValue.getDatabaseValue() : "";
            }
            object3 = (ILabeledColumn)object;
            this.statusMessage = MessageFormat.format(this.res.statusMessage, object3.getLabel(), object4);
            if (this.everywhereColumn.equals(object3)) {
                return this.prepareSearchForAllFields(object4);
            }
            criterion = new Criterion(Restrictions.like((IBasicColumn)object3, object4));
        }
        return criterion;
    }

    public void removeSearchListener(SearchListener searchListener) {
        this.getEventListenerList().removeListener(SearchListener.class, (EventListener)searchListener);
    }

    public void setColumnList(List<ITableColumn> list) {
        this.columnList = new ArrayList<ILabeledColumn>();
        this.columnList.add(this.everywhereColumn);
        for (ITableColumn iTableColumn : list) {
            if (!iTableColumn.isSearchable()) continue;
            this.columnList.add(iTableColumn);
        }
        Collections.sort(this.columnList, new ILabeledColumn.ColumnLabelComparator());
        this.poleSelectField.setList(this.columnList);
        if (this.columnList.size() > 0) {
            this.poleSelectField.setSelectedIndex(0);
            this.setWarunekComponent(this.columnList.get(0));
        }
    }

    public void setFastSearchFilterActive(boolean bl) {
        this.cancelSearchButton.setEnabled(bl);
    }

    public void setSelectedColumn(ILabeledColumn iLabeledColumn) {
        this.poleSelectField.setSelectedItem(iLabeledColumn);
        this.setWarunekComponent(iLabeledColumn);
    }

    private void fireSearchCanceled() {
        EventListener[] eventListenerArray;
        for (EventListener eventListener : eventListenerArray = this.getEventListenerList().getListeners(SearchListener.class)) {
            ((SearchListener)eventListener).searchCanceled();
        }
    }

    private void fireSearchPerformed() {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(SearchListener.class);
        SearchEvent searchEvent = new SearchEvent((Object)this, this.getCriterion(), this.gerStatusMessage());
        for (EventListener eventListener : eventListenerArray) {
            ((SearchListener)eventListener).searchPerformed(searchEvent);
        }
    }

    private String gerStatusMessage() {
        return this.statusMessage;
    }

    private void initComponents() {
        Row row = new Row();
        row.setCellSpacing(new Extent(4, 1));
        RowLayoutData rowLayoutData = new RowLayoutData();
        rowLayoutData.setInsets(new Insets(new Extent(4, 1), new Extent(0, 1)));
        row.setLayoutData((LayoutData)rowLayoutData);
        this.add((Component)row);
        this.searchLabel = new StrLabelMedium();
        this.searchLabel.setText("search");
        row.add((Component)this.searchLabel);
        this.poleSelectField = new StrComboBox();
        this.poleSelectField.setWidth(new Extent(160, 1));
        row.add((Component)this.poleSelectField);
        this.warunekColumn = new Column();
        row.add((Component)this.warunekColumn);
        this.searchButton = new StrSquareButton();
        this.searchButton.setActionCommand("searchPanel");
        RowLayoutData rowLayoutData2 = new RowLayoutData();
        rowLayoutData2.setAlignment(new Alignment(4, 4));
        this.searchButton.setLayoutData((LayoutData)rowLayoutData2);
        row.add((Component)this.searchButton);
        this.cancelSearchButton = new StrSquareButton();
        this.cancelSearchButton.setActionCommand("cancelSearchPanel");
        RowLayoutData rowLayoutData3 = new RowLayoutData();
        rowLayoutData3.setAlignment(new Alignment(4, 4));
        this.cancelSearchButton.setLayoutData((LayoutData)rowLayoutData3);
        row.add((Component)this.cancelSearchButton);
    }

    private void initListeners() {
        this.searchButton.addActionListener(this.actionProcessor);
        this.cancelSearchButton.addActionListener(this.actionProcessor);
        this.poleSelectField.addActionListener(this.actionProcessor);
    }

    private void initResources() {
        this.cancelSearchButton.setToolTipText(this.res.cancelSearchButtonToolTip);
        this.searchButton.setToolTipText(this.res.searchButtonToolTip);
        this.searchLabel.setText(this.res.searchLabelText);
        this.cancelSearchButton.setIcon(this.res.cancelSearchButtonIconEnabled);
        this.cancelSearchButton.setDisabledIcon(this.res.cancelSearchButtonIconDisabled);
        this.searchButton.setIcon(this.res.searchButtonIconEnabled);
        this.searchButton.setDisabledIcon(this.res.searchButtonIconDisabled);
    }

    private Criterion prepareSearchForAllFields(Object object) {
        Criterion criterion = null;
        for (int i = 0; i < this.columnList.size(); ++i) {
            ILabeledColumn iLabeledColumn = this.columnList.get(i);
            if (this.everywhereColumn.equals(iLabeledColumn)) continue;
            if (criterion == null) {
                criterion = new Criterion(Restrictions.like(iLabeledColumn, object));
                continue;
            }
            criterion.or(Restrictions.like(iLabeledColumn, object));
        }
        return criterion;
    }

    private void setWarunekComponent(ILabeledColumn iLabeledColumn) {
        Object object;
        int n;
        if (this.everywhereColumn.equals(iLabeledColumn)) {
            this.currentFieldDef = null;
            n = 12;
        } else {
            this.currentFieldDef = iLabeledColumn.getFieldDef();
            n = this.currentFieldDef.getFieldType();
        }
        Object object2 = null;
        if (this.currentFieldDef != null && TFieldDef.RodzajPola.rpDataSet.equals((Object)this.currentFieldDef.getRodzajPola())) {
            if (this.comboBox == null) {
                this.comboBox = new StrComboBox();
                this.comboBox.setWidth(new Extent(200, 1));
                this.comboBox.addActionListener(this.actionProcessor);
            }
            if ((object = this.currentFieldDef.getFieldDefValues()) != null && ((ArrayList)object).size() > 0) {
                this.comboBox.setList((List<?>)object);
                Integer n2 = this.comboBoxValuesListMap.get(this.currentFieldDef.getFieldName());
                if (n2 == null) {
                    n2 = 0;
                    this.comboBoxValuesListMap.put(this.currentFieldDef.getFieldName(), n2);
                }
                this.comboBox.setSelectedIndex(n2);
            }
            object2 = this.comboBox;
        } else {
            switch (n) {
                case 93: {
                    if (this.dateTextFieldGrid == null) {
                        this.dateTextFieldGrid = new DateTextFieldGrid();
                        this.dateTextFieldGrid.setWidth(new Extent(200, 1));
                    }
                    object2 = this.dateTextFieldGrid;
                    break;
                }
                default: {
                    if (this.textField == null) {
                        this.textField = new StrTextField();
                        this.textField.setWidth(new Extent(196, 1));
                        this.textField.setActionCommand("searchPanel");
                        this.textField.addActionListener(this.actionProcessor);
                    }
                    object2 = this.textField;
                }
            }
        }
        object = new ColumnLayoutData();
        object.setInsets(new Insets(0));
        object2.setLayoutData((LayoutData)object);
        this.warunekColumn.removeAll();
        this.warunekColumn.add((Component)object2);
    }

    private class Res {
        private ImageReference cancelSearchButtonIconDisabled;
        private ImageReference cancelSearchButtonIconEnabled;
        private String cancelSearchButtonToolTip;
        private ImageReference searchButtonIconDisabled;
        private ImageReference searchButtonIconEnabled;
        private String searchButtonToolTip;
        private String searchLabelText;
        private String statusMessage;

        private Res() {
        }
    }
}

