/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component.button.group;

import java.util.EventListener;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.Insets;
import nextapp.echo.app.LayoutData;
import nextapp.echo.app.Row;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.layout.RowLayoutData;
import pl.com.stream.echo.lib.component.StrLabelMedium;
import pl.com.stream.echo.lib.component.StrNumericTextField;
import pl.com.stream.echo.lib.component.StrToolButton;
import pl.com.stream.echo.lib.component.button.group.StrButtonGroupRow;
import pl.com.stream.echo.lib.event.PageIndexChangeEvent;
import pl.com.stream.echo.lib.event.PageIndexChangeListener;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class PageNavigatorButtonGroup
extends StrButtonGroupRow {
    private static final long serialVersionUID = -7993964146184412211L;
    private final ActionListener actionProcessor = new ActionListener(){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(PageNavigatorButtonGroup.this.firstPageButton)) {
                PageNavigatorButtonGroup.this.firePageIndexChanged(0);
            }
            if (actionEvent.getSource().equals(PageNavigatorButtonGroup.this.previewPageButton)) {
                PageNavigatorButtonGroup.this.firePageIndexChanged(PageNavigatorButtonGroup.this.getPageIndex() - 1);
            }
            if (actionEvent.getSource().equals(PageNavigatorButtonGroup.this.nextPageButton)) {
                PageNavigatorButtonGroup.this.firePageIndexChanged(PageNavigatorButtonGroup.this.getPageIndex() + 1);
            }
            if (actionEvent.getSource().equals(PageNavigatorButtonGroup.this.lastPageButton)) {
                PageNavigatorButtonGroup.this.firePageIndexChanged(PageNavigatorButtonGroup.this.getTotalPages() - 1);
            }
            if (actionEvent.getSource().equals((Object)PageNavigatorButtonGroup.this.pageNumberTextField)) {
                int n = 0;
                try {
                    n = Integer.parseInt(PageNavigatorButtonGroup.this.pageNumberTextField.getText()) - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    n = PageNavigatorButtonGroup.this.getPageIndex();
                }
                if (n > PageNavigatorButtonGroup.this.totalPages - 1) {
                    n = PageNavigatorButtonGroup.this.totalPages - 1;
                }
                if (n < 0) {
                    n = 0;
                }
                PageNavigatorButtonGroup.this.firePageIndexChanged(n);
            }
        }
    };
    private int currentPageIndex = 0;
    private StrToolButton firstPageButton;
    private StrToolButton lastPageButton;
    private StrToolButton nextPageButton;
    private StrNumericTextField pageNumberTextField;
    private StrToolButton previewPageButton;
    @ResourceContainer
    private Res res;
    private int totalPages = 1;
    private StrLabelMedium totalPagesLabel;
    private StrLabelMedium separatorLabel;
    private boolean pageCountingEnabled;

    public PageNavigatorButtonGroup() {
        this.initComponents();
        this.initResources();
        this.initListeners();
        this.setPageCountingEnabled(true);
    }

    public void addPageIndexChangeListener(PageIndexChangeListener pageIndexChangeListener) {
        this.getEventListenerList().addListener(PageIndexChangeListener.class, (EventListener)pageIndexChangeListener);
    }

    public int getPageIndex() {
        return this.currentPageIndex;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public boolean isPageCountingEnabled() {
        return this.pageCountingEnabled;
    }

    public void removePageIndexChangeListener(PageIndexChangeListener pageIndexChangeListener) {
        this.getEventListenerList().removeListener(PageIndexChangeListener.class, (EventListener)pageIndexChangeListener);
    }

    public void setNextPageAvailable(boolean bl) {
        this.nextPageButton.setEnabled(bl);
        this.lastPageButton.setEnabled(bl);
    }

    public void setPageCountingEnabled(boolean bl) {
        boolean bl2 = this.pageCountingEnabled;
        this.pageCountingEnabled = bl;
        if (bl2 != this.pageCountingEnabled) {
            this.separatorLabel.setVisible(bl);
            this.totalPagesLabel.setVisible(bl);
            this.lastPageButton.setVisible(bl);
            this.pageNumberTextField.setEnabled(bl);
        }
    }

    public void setPageIndex(int n) {
        this.currentPageIndex = n;
        this.firstPageButton.setEnabled(n > 0);
        this.previewPageButton.setEnabled(n > 0);
        this.pageNumberTextField.setText(Integer.toString(n + 1));
    }

    public void setTotalPages(int n) {
        this.totalPages = n;
        if (n == 0) {
            this.totalPagesLabel.setText("1");
        } else {
            this.totalPagesLabel.setText(Integer.toString(n));
        }
    }

    private void firePageIndexChanged(int n) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(PageIndexChangeListener.class);
        PageIndexChangeEvent pageIndexChangeEvent = new PageIndexChangeEvent((Object)this, n);
        for (EventListener eventListener : eventListenerArray) {
            ((PageIndexChangeListener)eventListener).pageIndexChanged(pageIndexChangeEvent);
        }
    }

    private void initComponents() {
        this.firstPageButton = new StrToolButton();
        this.firstPageButton.setActionCommand("first");
        this.add((Component)this.firstPageButton);
        this.previewPageButton = new StrToolButton();
        this.previewPageButton.setActionCommand("preview");
        this.add((Component)this.previewPageButton);
        Row row = new Row();
        RowLayoutData rowLayoutData = new RowLayoutData();
        rowLayoutData.setInsets(new Insets(new Extent(4, 1), new Extent(0, 1)));
        row.setLayoutData((LayoutData)rowLayoutData);
        this.add((Component)row);
        this.pageNumberTextField = new StrNumericTextField();
        this.pageNumberTextField.setAlignment(new Alignment(5, 0));
        this.pageNumberTextField.setWidth(new Extent(30, 1));
        RowLayoutData rowLayoutData2 = new RowLayoutData();
        rowLayoutData2.setInsets(new Insets(new Extent(0, 1), new Extent(0, 1), new Extent(2, 1), new Extent(0, 1)));
        this.pageNumberTextField.setLayoutData((LayoutData)rowLayoutData2);
        row.add((Component)this.pageNumberTextField);
        this.separatorLabel = new StrLabelMedium();
        this.separatorLabel.setText("/");
        RowLayoutData rowLayoutData3 = new RowLayoutData();
        rowLayoutData3.setInsets(new Insets(new Extent(2, 1), new Extent(0, 1)));
        this.separatorLabel.setLayoutData((LayoutData)rowLayoutData3);
        row.add((Component)this.separatorLabel);
        this.totalPagesLabel = new StrLabelMedium();
        this.totalPagesLabel.setText("...");
        RowLayoutData rowLayoutData4 = new RowLayoutData();
        rowLayoutData4.setInsets(new Insets(new Extent(2, 1), new Extent(0, 1), new Extent(0, 1), new Extent(0, 1)));
        this.totalPagesLabel.setLayoutData((LayoutData)rowLayoutData4);
        row.add((Component)this.totalPagesLabel);
        this.nextPageButton = new StrToolButton();
        this.nextPageButton.setActionCommand("next");
        this.add((Component)this.nextPageButton);
        this.lastPageButton = new StrToolButton();
        this.lastPageButton.setActionCommand("last");
        this.add((Component)this.lastPageButton);
    }

    private void initListeners() {
        this.firstPageButton.addActionListener(this.actionProcessor);
        this.previewPageButton.addActionListener(this.actionProcessor);
        this.nextPageButton.addActionListener(this.actionProcessor);
        this.lastPageButton.addActionListener(this.actionProcessor);
        this.pageNumberTextField.addActionListener(this.actionProcessor);
    }

    private void initResources() {
        this.firstPageButton.setToolTipText(this.res.firstPageButtonToolTip);
        this.lastPageButton.setToolTipText(this.res.lastPageButtonToolTip);
        this.nextPageButton.setToolTipText(this.res.nextPageButtonToolTip);
        this.pageNumberTextField.setToolTipText(this.res.pageNumberTextFieldToolTip);
        this.previewPageButton.setToolTipText(this.res.previewPageButtonToolTip);
        this.totalPagesLabel.setToolTipText(this.res.totalPagesLabelToolTip);
        this.firstPageButton.setIcon(this.res.firstPageButtonIconEnabled);
        this.firstPageButton.setDisabledIcon(this.res.firstPageButtonIconDisabled);
        this.previewPageButton.setIcon(this.res.previewPageButtonIconEnabled);
        this.previewPageButton.setDisabledIcon(this.res.previewPageButtonIconDisabled);
        this.nextPageButton.setIcon(this.res.nextPageButtonIconEnabled);
        this.nextPageButton.setDisabledIcon(this.res.nextPageButtonIconDisabled);
        this.lastPageButton.setIcon(this.res.lastPageButtonIconEnabled);
        this.lastPageButton.setDisabledIcon(this.res.lastPageButtonIconDisabled);
    }

    private class Res {
        private ImageReference firstPageButtonIconDisabled;
        private ImageReference firstPageButtonIconEnabled;
        private String firstPageButtonToolTip;
        private ImageReference lastPageButtonIconDisabled;
        private ImageReference lastPageButtonIconEnabled;
        private String lastPageButtonToolTip;
        private ImageReference nextPageButtonIconDisabled;
        private ImageReference nextPageButtonIconEnabled;
        private String nextPageButtonToolTip;
        private String pageNumberTextFieldToolTip;
        private ImageReference previewPageButtonIconDisabled;
        private ImageReference previewPageButtonIconEnabled;
        private String previewPageButtonToolTip;
        private String totalPagesLabelToolTip;

        private Res() {
        }
    }
}

