/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Component;
import nextapp.echo.app.ContentPane;
import nextapp.echo.app.Extent;
import nextapp.echo.app.SplitPane;
import nextapp.echo.app.Style;
import pl.com.stream.echo.lib.event.ComponentOrientationEvent;
import pl.com.stream.echo.lib.event.ComponentOrientationListener;
import pl.com.stream.echo.lib.type.SplitPaneOrientationProperties;

public class StrSplitPane
extends SplitPane {
    public static final String PROPERTY_FIRST_COMPONENT_ORIENTATION = "firstComponentOrientation";
    private static final long serialVersionUID = -5384676000749056439L;
    private ContentPane emptyContentPane;
    private Component firstComponent;
    private SplitPaneFirstComponentOrientation firstComponentOrientation;
    private Extent horizontalSeparatorPosition;
    private SplitPaneFirstComponentOrientation oldFirstComponentOrientation;
    private Component secondComponent;
    private Extent verticalSeparatorPosition;

    public StrSplitPane() {
        this.initComponents();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Extent extent;
                if (propertyChangeEvent.getPropertyName().equals("separatorVisible")) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    StrSplitPane.this.fireSeparatorVisible(bl);
                }
                if (propertyChangeEvent.getPropertyName().equals("separatorPosition") && StrSplitPane.this.isSeparatorVisible(true) && (extent = (Extent)propertyChangeEvent.getNewValue()) != null) {
                    if (StrSplitPane.this.isSeparatorHorizontal()) {
                        StrSplitPane.this.horizontalSeparatorPosition = new Extent(extent.getValue());
                    } else {
                        StrSplitPane.this.verticalSeparatorPosition = new Extent(extent.getValue());
                    }
                }
                if (propertyChangeEvent.getPropertyName().equals(StrSplitPane.PROPERTY_FIRST_COMPONENT_ORIENTATION)) {
                    SplitPaneFirstComponentOrientation splitPaneFirstComponentOrientation = (SplitPaneFirstComponentOrientation)((Object)propertyChangeEvent.getOldValue());
                    SplitPaneFirstComponentOrientation splitPaneFirstComponentOrientation2 = (SplitPaneFirstComponentOrientation)((Object)propertyChangeEvent.getNewValue());
                    if (splitPaneFirstComponentOrientation == null) {
                        splitPaneFirstComponentOrientation = splitPaneFirstComponentOrientation2;
                    }
                    StrSplitPane.this.oldFirstComponentOrientation = splitPaneFirstComponentOrientation;
                    StrSplitPane.this.firstComponentOrientation = splitPaneFirstComponentOrientation2;
                    StrSplitPane.this.fireInternalFirstComponentOrientation(StrSplitPane.this.firstComponentOrientation);
                    StrSplitPane.this.fireExternalFirstComponentOrientationChanged(StrSplitPane.this.firstComponentOrientation);
                }
            }
        });
    }

    public void add(Component component) {
        if (this.getComponentCount() == 0) {
            if (this.firstComponent == null) {
                this.firstComponent = component;
            }
        } else if (this.getComponentCount() == 1 && this.secondComponent == null) {
            this.secondComponent = component;
        }
        super.add(component);
    }

    public void addComponentOrientationListener(ComponentOrientationListener componentOrientationListener) {
        this.getEventListenerList().addListener(ComponentOrientationListener.class, (EventListener)componentOrientationListener);
    }

    public SplitPaneFirstComponentOrientation getFirstComponentOrientation() {
        return this.firstComponentOrientation;
    }

    public String getFirstComponentOrientationStringRepresentation() {
        return this.firstComponentOrientation.toString();
    }

    public Extent getHorizontalSeparatorPosition() {
        return this.horizontalSeparatorPosition;
    }

    public SplitPaneOrientationProperties getSplitPaneOrientationProperties() {
        SplitPaneOrientationProperties splitPaneOrientationProperties = new SplitPaneOrientationProperties(this.firstComponentOrientation, this.horizontalSeparatorPosition, this.verticalSeparatorPosition);
        return splitPaneOrientationProperties;
    }

    public Extent getVerticalSeparatorPosition() {
        return this.verticalSeparatorPosition;
    }

    public boolean isFirstComponentVisible() {
        if (this.getComponentCount() > 1) {
            return this.getComponent(0).equals(this.firstComponent);
        }
        return false;
    }

    public void removeComponentOrientationListener(ComponentOrientationListener componentOrientationListener) {
        this.getEventListenerList().removeListener(ComponentOrientationListener.class, (EventListener)componentOrientationListener);
    }

    public void restoreFirstComponentOrientation() {
        this.firstComponentOrientation = this.oldFirstComponentOrientation;
        this.fireInternalFirstComponentOrientation(this.firstComponentOrientation);
    }

    public void setComponent(Component component, int n) {
        if ((n == 0 || n == 1) && component != null && this.getComponentCount() == 2) {
            if (n == 0) {
                this.firstComponent = component;
            }
            if (n == 1) {
                this.secondComponent = component;
            }
            super.remove(n);
            super.add(component, n);
        }
    }

    public void setFirstComponentOrientation(SplitPaneFirstComponentOrientation splitPaneFirstComponentOrientation) {
        this.firePropertyChange(PROPERTY_FIRST_COMPONENT_ORIENTATION, (Object)this.firstComponentOrientation, (Object)splitPaneFirstComponentOrientation);
    }

    public void setFirstComponentOrientationStringRepresentation(String string) {
        SplitPaneFirstComponentOrientation splitPaneFirstComponentOrientation = SplitPaneFirstComponentOrientation.valueOf(string);
        if (splitPaneFirstComponentOrientation == null) {
            throw new IllegalArgumentException("Wrong argument: " + string + ", correct is: right, left, down, up, none");
        }
        this.firePropertyChange(PROPERTY_FIRST_COMPONENT_ORIENTATION, (Object)this.firstComponentOrientation, (Object)splitPaneFirstComponentOrientation);
    }

    public void setHorizontalSeparatorPosition(Extent extent) {
        this.horizontalSeparatorPosition = extent;
        this.setSeparatorPosition(extent);
    }

    public void setSplitPaneOrientationProperties(SplitPaneOrientationProperties splitPaneOrientationProperties) {
        if (splitPaneOrientationProperties != null) {
            this.firstComponentOrientation = splitPaneOrientationProperties.getFirstComponentOrientation();
            this.horizontalSeparatorPosition = splitPaneOrientationProperties.getHorizontalSeparatorPosition();
            this.verticalSeparatorPosition = splitPaneOrientationProperties.getVerticalSeparatorPosition();
            this.fireInternalFirstComponentOrientation(this.firstComponentOrientation);
        }
    }

    public void setVerticalSeparatorPosition(Extent extent) {
        this.verticalSeparatorPosition = extent;
        this.setSeparatorPosition(extent);
    }

    private void fireExternalFirstComponentOrientationChanged(SplitPaneFirstComponentOrientation splitPaneFirstComponentOrientation) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(ComponentOrientationListener.class);
        ComponentOrientationEvent componentOrientationEvent = new ComponentOrientationEvent((Object)this, splitPaneFirstComponentOrientation);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((ComponentOrientationListener)eventListenerArray[i]).orientationChanged(componentOrientationEvent);
        }
    }

    private void fireInternalFirstComponentOrientation(SplitPaneFirstComponentOrientation splitPaneFirstComponentOrientation) {
        if (splitPaneFirstComponentOrientation != null) {
            switch (splitPaneFirstComponentOrientation) {
                case none: {
                    this.setFirstComponentVisible(false);
                    this.fireSeparatorPosition(new Extent(0));
                    break;
                }
                case up: {
                    this.setOrientation(4);
                    this.setFirstComponentVisible(true);
                    this.restoreSeparatorPosition();
                    break;
                }
                case down: {
                    this.setOrientation(5);
                    this.setFirstComponentVisible(true);
                    this.restoreSeparatorPosition();
                    break;
                }
                case left: {
                    this.setOrientation(2);
                    this.setFirstComponentVisible(true);
                    this.restoreSeparatorPosition();
                    break;
                }
                case right: {
                    this.setOrientation(3);
                    this.setFirstComponentVisible(true);
                    this.restoreSeparatorPosition();
                    break;
                }
            }
        }
    }

    private void fireSeparatorPosition(Extent extent) {
        this.setSeparatorPosition(extent);
    }

    private void fireSeparatorVisible(boolean bl) {
        if (bl) {
            Style style = ApplicationInstance.getActive().getStyle(StrSplitPane.class, this.getStyleName());
            if (style != null) {
                Extent extent;
                if (style.get("separatorHeight") instanceof Extent) {
                    extent = (Extent)style.get("separatorHeight");
                    this.setSeparatorHeight(extent);
                }
                if (style.get("separatorWidth") instanceof Extent) {
                    extent = (Extent)style.get("separatorWidth");
                    this.setSeparatorWidth(extent);
                }
            } else {
                this.setSeparatorHeight(new Extent(1));
                this.setSeparatorWidth(new Extent(1));
            }
        } else {
            this.setSeparatorHeight(new Extent(0));
            this.setSeparatorWidth(new Extent(0));
        }
    }

    private ContentPane getEmptyContentPane() {
        if (this.emptyContentPane == null) {
            this.emptyContentPane = new ContentPane();
        }
        return this.emptyContentPane;
    }

    private void initComponents() {
    }

    private boolean isSeparatorHorizontal() {
        switch (this.getOrientation()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case 4: 
            case 5: {
                return false;
            }
        }
        return false;
    }

    private void restoreSeparatorPosition() {
        if (this.isSeparatorHorizontal()) {
            this.fireSeparatorPosition(this.horizontalSeparatorPosition);
        } else {
            this.fireSeparatorPosition(this.verticalSeparatorPosition);
        }
    }

    private void setFirstComponentVisible(boolean bl) {
        if (this.firstComponent != null && this.secondComponent != null) {
            this.removeAll();
            if (bl) {
                this.add(this.firstComponent);
                this.add(this.secondComponent);
            } else {
                this.add((Component)this.getEmptyContentPane());
                this.add(this.secondComponent);
            }
            this.setSeparatorVisible(bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SplitPaneFirstComponentOrientation {
        down,
        left,
        none,
        right,
        up;

    }
}

