/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component;

import java.util.EventListener;
import java.util.List;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Table;
import nextapp.echo.app.list.DefaultListSelectionModel;
import nextapp.echo.app.list.ListSelectionModel;
import nextapp.echo.app.table.DefaultTableColumnModel;
import nextapp.echo.app.table.TableCellRenderer;
import nextapp.echo.app.table.TableColumn;
import nextapp.echo.app.table.TableColumnModel;
import pl.com.stream.echo.lib.component.table.DefaultSortableTableModel;
import pl.com.stream.echo.lib.component.table.DefaultTableCellRenderer;
import pl.com.stream.echo.lib.component.table.SortableTableColumn;
import pl.com.stream.echo.lib.component.table.SortableTableModel;
import pl.com.stream.echo.lib.event.MouseEvent;
import pl.com.stream.echo.lib.event.MouseListener;
import pl.com.stream.echo.lib.event.SortListener;
import pl.com.stream.echo.lib.type.TSelectedTableColumnOrder;
import pl.com.stream.echo.lib.type.TTableObject;
import pl.com.stream.echo.lib.type.column.ITableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortTable
extends Table {
    public static final String MOUSE_LISTENERS_CHANGED_PROPERTY = "mouseListeners";
    private static final long serialVersionUID = 1L;
    private TableCellRenderer cellRenderer;

    public SortTable() {
        this.initComponents();
        this.setModel(new DefaultSortableTableModel());
        this.setColumnModel((TableColumnModel)new DefaultTableColumnModel());
        this.setSelectionModel((ListSelectionModel)new DefaultListSelectionModel());
        this.setCellRenderer(new DefaultTableCellRenderer());
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.getEventListenerList().addListener(MouseListener.class, (EventListener)mouseListener);
        this.firePropertyChange(MOUSE_LISTENERS_CHANGED_PROPERTY, null, mouseListener);
    }

    public void addRow(Object object) {
        if (object == null) {
            return;
        }
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            sortableTableModel.addRow(object);
        }
    }

    public void addRows(List<Object> list) {
        if (list == null) {
            return;
        }
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            sortableTableModel.addRows(list);
        }
    }

    public void addSortListener(SortListener sortListener) {
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            sortableTableModel.addSortListener(sortListener);
        }
    }

    public void clearSelection() {
        this.refreshSelection(-1);
    }

    public void clearTable() {
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            sortableTableModel.clearTable();
            this.refreshSelection(-1);
        }
    }

    public List<Object> getAllRows() {
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            return sortableTableModel.getAllRows();
        }
        return null;
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public List<TSelectedTableColumnOrder> getColumnsOrder() {
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            return sortableTableModel.getColumnsOrder();
        }
        return null;
    }

    public Object getSelectedRow() {
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            int n = this.getSelectionModel().getMinSelectedIndex();
            return sortableTableModel.getRow(n);
        }
        return null;
    }

    public boolean hasActionListeners() {
        return super.hasActionListeners() || this.getEventListenerList().getListenerCount(MouseListener.class) != 0;
    }

    public void moveRow(int n, int n2) {
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            int n3 = sortableTableModel.moveRow(n, n2);
            this.getSelectionModel().setSelectedIndex(n3, true);
        }
    }

    public void processInput(String string, Object object) {
        if ("action".equals(string)) {
            if (object != null) {
                if (object.equals("single")) {
                    this.fireMouseEvent(MouseEvent.MouseEventType.singleClick);
                }
                if (object.equals("double")) {
                    this.fireMouseEvent(MouseEvent.MouseEventType.doubleClick);
                }
            } else {
                this.fireMouseEvent(MouseEvent.MouseEventType.singleClick);
            }
        } else {
            super.processInput(string, object);
        }
    }

    public void refreshCellRenderer() {
        this.setCellRenderer(this.cellRenderer);
    }

    public void refreshSelection(int n) {
        int n2;
        int n3 = n2 = this.getModel().getRowCount() <= 0 ? 0 : this.getModel().getRowCount() - 1;
        if (n >= n2) {
            this.getSelectionModel().setSelectedIndex(n2, false);
            this.getSelectionModel().setSelectedIndex(n2, true);
        } else if (n >= 0 && n < n2) {
            this.getSelectionModel().setSelectedIndex(n, false);
            this.getSelectionModel().setSelectedIndex(n, true);
        } else if (this.getModel().getRowCount() == 0 || n < 0) {
            this.getSelectionModel().clearSelection();
        }
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.getEventListenerList().removeListener(MouseListener.class, (EventListener)mouseListener);
        this.firePropertyChange(MOUSE_LISTENERS_CHANGED_PROPERTY, mouseListener, null);
    }

    public void removeRow(int n) {
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            sortableTableModel.removeRow(n);
            this.refreshSelection(n);
        }
    }

    public void removeRow(Object object) {
        if (object == null) {
            return;
        }
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            int n = sortableTableModel.removeRow(object);
            this.refreshSelection(n);
        }
    }

    public void removeSortListener(SortListener sortListener) {
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            sortableTableModel.removeSortListener(sortListener);
        }
    }

    public void setCellRenderer(TableCellRenderer tableCellRenderer) {
        if (tableCellRenderer == null) {
            return;
        }
        this.invalidate();
        this.cellRenderer = tableCellRenderer;
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setCellRenderer(tableCellRenderer);
        }
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        super.setColumnModel(tableColumnModel);
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            sortableTableModel.setColumnModel(tableColumnModel);
        }
        this.refreshCellRenderer();
    }

    public void setColumnModelFromTVisibleColumns(List<? extends ITableColumn> list) {
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        if (list != null && list.size() > 0) {
            int n = 0;
            for (ITableColumn iTableColumn : list) {
                Integer n2 = iTableColumn.getSize();
                Integer n3 = iTableColumn.getSizeUnit();
                if (n3 == null) {
                    n3 = 1;
                }
                SortableTableColumn sortableTableColumn = new SortableTableColumn(n++);
                sortableTableColumn.setHeaderValue(iTableColumn.getLabel());
                sortableTableColumn.setIdentifier(iTableColumn);
                if (this.getCellRenderer() != null) {
                    sortableTableColumn.setCellRenderer(this.getCellRenderer());
                }
                if (n3 == 1 && (n2 == null || n2 < 20)) {
                    n2 = 20;
                }
                Extent extent = new Extent(n2.intValue(), n3.intValue());
                sortableTableColumn.setWidth(extent);
                defaultTableColumnModel.addColumn((TableColumn)sortableTableColumn);
            }
        }
        this.setColumnModel((TableColumnModel)defaultTableColumnModel);
        this.firePropertyChange("columnWidth", false, true);
        this.invalidate();
    }

    public void setColumnsOrder(List<TSelectedTableColumnOrder> list) {
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            sortableTableModel.setColumnsOrder(list);
        }
    }

    public void setHeight(Extent extent) {
    }

    public void setTableObject(TTableObject tTableObject) {
        if (tTableObject == null) {
            throw new IllegalArgumentException("Table object can not be null!");
        }
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            sortableTableModel.setTableObject(tTableObject);
            if (tTableObject.size() > 0) {
                this.getSelectionModel().setSelectedIndex(0, true);
            } else {
                this.getSelectionModel().clearSelection();
            }
        }
    }

    public void sortRows(int n, boolean bl) {
        if (this.getModel() instanceof SortableTableModel) {
            SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
            sortableTableModel.sortByColumn(n, bl);
            this.invalidate();
        }
    }

    private void fireMouseEvent(MouseEvent.MouseEventType mouseEventType) {
        if (!this.hasEventListenerList()) {
            return;
        }
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(MouseListener.class);
        MouseEvent mouseEvent = null;
        for (int i = 0; i < eventListenerArray.length; ++i) {
            if (mouseEvent == null) {
                mouseEvent = new MouseEvent((Object)this, mouseEventType);
            }
            ((MouseListener)eventListenerArray[i]).mouseClicked(mouseEvent);
        }
    }

    private void initComponents() {
        this.setStyleName("TableStyle");
        this.setAutoCreateColumnsFromModel(false);
    }
}

