/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Border;
import nextapp.echo.app.Button;
import nextapp.echo.app.Color;
import nextapp.echo.app.Column;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Font;
import nextapp.echo.app.Grid;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.Insets;
import nextapp.echo.app.LayoutData;
import nextapp.echo.app.Row;
import nextapp.echo.app.Table;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.event.ChangeEvent;
import nextapp.echo.app.event.ChangeListener;
import nextapp.echo.app.layout.GridLayoutData;
import nextapp.echo.app.layout.RowLayoutData;
import nextapp.echo.app.layout.TableLayoutData;
import nextapp.echo.app.list.DefaultListSelectionModel;
import nextapp.echo.app.table.DefaultTableColumnModel;
import nextapp.echo.app.table.TableCellRenderer;
import nextapp.echo.app.table.TableColumn;
import nextapp.echo.app.table.TableColumnModel;
import pl.com.stream.echo.lib.component.ContainerEx;
import pl.com.stream.echo.lib.component.ScrollPanel;
import pl.com.stream.echo.lib.component.SortTable;
import pl.com.stream.echo.lib.component.StrButton;
import pl.com.stream.echo.lib.component.StrLabelMedium;
import pl.com.stream.echo.lib.component.table.SortableTableColumn;
import pl.com.stream.echo.lib.component.table.SortableTableModel;
import pl.com.stream.echo.lib.event.MouseEvent;
import pl.com.stream.echo.lib.event.MouseListener;
import pl.com.stream.echo.lib.event.SortEvent;
import pl.com.stream.echo.lib.event.SortListener;
import pl.com.stream.echo.lib.type.TTableObject;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleTableContainer
extends ScrollPanel {
    public static final String TABLE_SELECTION_CHANGED = "selection";
    private static final Extent MINIMUM_SIZE = new Extent(142);
    private static final Extent NORMAL_SIZE = new Extent(230);
    private static final long serialVersionUID = 4687564065300979166L;
    private boolean autoSortSelectedTable = true;
    private ContainerEx availableContainer;
    private StrLabelMedium availableLabel;
    private SortTable availableTable;
    private TableColumnModel columnModel;
    private StrButton downButton;
    private ScrollPanel emptyPanel;
    private final ActionListener internalActionProcessor = new ActionListener(){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if ("left".equals(actionEvent.getActionCommand()) && (object = DoubleTableContainer.this.availableTable.getSelectedRow()) != null) {
                DoubleTableContainer.this.availableTable.removeRow(object);
                DoubleTableContainer.this.selectedTable.addRow(object);
                if (DoubleTableContainer.this.isAutoSortSelectedTable()) {
                    DoubleTableContainer.this.sortSelectedTable();
                }
                DoubleTableContainer.this.fireTablePropertyChanged();
            }
            if ("leftAll".equals(actionEvent.getActionCommand()) && DoubleTableContainer.this.availableTable.getAllRows().size() > 0) {
                DoubleTableContainer.this.selectedTable.addRows(DoubleTableContainer.this.availableTable.getAllRows());
                DoubleTableContainer.this.availableTable.clearTable();
                if (DoubleTableContainer.this.isAutoSortSelectedTable()) {
                    DoubleTableContainer.this.sortSelectedTable();
                }
                DoubleTableContainer.this.fireTablePropertyChanged();
            }
            if ("right".equals(actionEvent.getActionCommand()) && (object = DoubleTableContainer.this.selectedTable.getSelectedRow()) != null) {
                DoubleTableContainer.this.selectedTable.removeRow(object);
                DoubleTableContainer.this.availableTable.addRow(object);
                DoubleTableContainer.this.sortAvailableTable();
                DoubleTableContainer.this.fireTablePropertyChanged();
            }
            if ("rightAll".equals(actionEvent.getActionCommand()) && DoubleTableContainer.this.selectedTable.getAllRows().size() > 0) {
                DoubleTableContainer.this.availableTable.addRows(DoubleTableContainer.this.selectedTable.getAllRows());
                DoubleTableContainer.this.sortAvailableTable();
                DoubleTableContainer.this.selectedTable.clearTable();
                DoubleTableContainer.this.fireTablePropertyChanged();
            }
            if ("sort".equals(actionEvent.getActionCommand()) && DoubleTableContainer.this.selectedTable.getAllRows().size() > 0) {
                DoubleTableContainer.this.sortSelectedTable();
                DoubleTableContainer.this.fireTablePropertyChanged();
            }
            if ("up".equals(actionEvent.getActionCommand()) && !DoubleTableContainer.this.selectedTable.getSelectionModel().isSelectionEmpty()) {
                int n = DoubleTableContainer.this.selectedTable.getSelectionModel().getMinSelectedIndex();
                DoubleTableContainer.this.selectedTable.moveRow(n--, n);
                DoubleTableContainer.this.fireTablePropertyChanged();
            }
            if ("down".equals(actionEvent.getActionCommand())) {
                int n = -1;
                if (!DoubleTableContainer.this.selectedTable.getSelectionModel().isSelectionEmpty()) {
                    n = DoubleTableContainer.this.selectedTable.getSelectionModel().getMinSelectedIndex();
                } else {
                    n = 0;
                    DoubleTableContainer.this.selectedTable.getSelectionModel().setSelectedIndex(n, true);
                }
                DoubleTableContainer.this.selectedTable.moveRow(n++, n);
                DoubleTableContainer.this.fireTablePropertyChanged();
            }
        }
    };
    private StrButton leftAllButton;
    private StrButton leftButton;
    private Column leftRightButtons;
    private Grid mainGrid;
    private final MouseListener mouseProcessor = new MouseListener(){
        private static final long serialVersionUID = 1L;

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getEventType().equals((Object)MouseEvent.MouseEventType.doubleClick)) {
                Object object;
                if (mouseEvent.getSource().equals((Object)DoubleTableContainer.this.availableTable) && (object = DoubleTableContainer.this.availableTable.getSelectedRow()) != null) {
                    DoubleTableContainer.this.availableTable.removeRow(object);
                    DoubleTableContainer.this.selectedTable.addRow(object);
                    if (DoubleTableContainer.this.isAutoSortSelectedTable()) {
                        DoubleTableContainer.this.sortSelectedTable();
                    }
                    DoubleTableContainer.this.fireTablePropertyChanged();
                }
                if (mouseEvent.getSource().equals((Object)DoubleTableContainer.this.selectedTable) && (object = DoubleTableContainer.this.selectedTable.getSelectedRow()) != null) {
                    DoubleTableContainer.this.selectedTable.removeRow(object);
                    DoubleTableContainer.this.availableTable.addRow(object);
                    DoubleTableContainer.this.sortAvailableTable();
                    DoubleTableContainer.this.fireTablePropertyChanged();
                }
            }
        }
    };
    private final PropertyChangeListener propertyProcessor = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("repaint")) {
                // empty if block
            }
        }
    };
    @ResourceContainer
    private Res res;
    private StrButton rightAllButton;
    private StrButton rightButton;
    private ContainerEx selectedContainer;
    private StrLabelMedium selectedLabel;
    private SortTable selectedTable;
    private boolean smallHeight = true;
    private StrButton sortButton;
    private SortListener sortProcessor;
    private StrButton upButton;
    private Row upDownButtons;
    private Column upDownButtonsColumn;
    private boolean upDownButtonsVisible;

    public DoubleTableContainer() {
        ResourceManager.bind((Object)((Object)this), (Locale)ClientLocale.getCurrent());
        this.initComponents();
        this.initResources();
        this.initListeners();
        GridLayoutData gridLayoutData = new GridLayoutData();
        gridLayoutData.setAlignment(new Alignment(4, 6));
        this.leftRightButtons.setLayoutData((LayoutData)gridLayoutData);
        gridLayoutData = new GridLayoutData();
        gridLayoutData.setAlignment(new Alignment(3, 7));
        this.upDownButtons.setLayoutData((LayoutData)gridLayoutData);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.getEventListenerList().addListener(SelectionListener.class, (EventListener)selectionListener);
    }

    public List<?> getAvailableList() {
        return this.availableTable.getAllRows();
    }

    public List<?> getSelectedList() {
        return this.selectedTable.getAllRows();
    }

    public Object getSelectedObject() {
        return this.selectedTable.getSelectedRow();
    }

    public boolean isAutoSortSelectedTable() {
        return this.autoSortSelectedTable;
    }

    public boolean isSmallHeight() {
        return this.smallHeight;
    }

    public boolean isUpDownButtonsVisible() {
        return this.upDownButtonsVisible;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.getEventListenerList().removeListener(SelectionListener.class, (EventListener)selectionListener);
    }

    public void setAutoSortSelectedTable(boolean bl) {
        this.autoSortSelectedTable = bl;
    }

    public void setAvailableList(List<?> list) {
        TTableObject tTableObject = list == null ? new TTableObject() : new TTableObject(list);
        this.availableTable.setColumnModel(this.getTableColumnModel());
        this.availableTable.setTableObject(tTableObject);
    }

    public void setCellRenderer(TableCellRenderer tableCellRenderer) {
        this.selectedTable.setCellRenderer(tableCellRenderer);
        this.availableTable.setCellRenderer(tableCellRenderer);
    }

    public void setHeight(Extent extent) {
        super.setHeight(extent);
        if (this.mainGrid != null) {
            this.mainGrid.setHeight(extent);
            Extent extent2 = this.calculateTableHeight(extent);
            this.selectedContainer.setHeight(extent2);
            this.availableContainer.setHeight(extent2);
        }
    }

    public void setSelectedList(List<?> list) {
        TTableObject tTableObject = list == null ? new TTableObject() : new TTableObject(list);
        this.selectedTable.setColumnModel(this.getTableColumnModel());
        this.selectedTable.setTableObject(tTableObject);
    }

    public void setSmallHeight(boolean bl) {
        this.smallHeight = bl;
        Extent extent = bl ? MINIMUM_SIZE : NORMAL_SIZE;
        this.setHeight(extent);
        Extent extent2 = this.calculateTableHeight(extent);
        this.selectedContainer.setHeight(extent2);
        this.availableContainer.setHeight(extent2);
    }

    public void setUpDownButtonsVisible(boolean bl) {
        this.upDownButtonsVisible = bl;
        this.upDownButtons.setVisible(this.upDownButtonsVisible);
    }

    public void sortAvailableTable() {
        this.availableTable.sortRows(0, true);
    }

    public void sortSelectedTable() {
        this.selectedTable.sortRows(0, true);
    }

    private Extent calculateTableHeight(Extent extent) {
        return new Extent(extent.getValue() - this.emptyPanel.getHeight().getValue() - 2);
    }

    private TableColumnModel getTableColumnModel() {
        if (this.columnModel == null) {
            this.columnModel = new DefaultTableColumnModel();
            SortableTableColumn sortableTableColumn = new SortableTableColumn(0, new Extent(225, 1));
            sortableTableColumn.setHeaderValue("");
            this.columnModel.addColumn((TableColumn)sortableTableColumn);
            sortableTableColumn.setHeaderRenderer(new TableCellRenderer(){
                private static final long serialVersionUID = 1L;

                public Component getTableCellRendererComponent(Table table, Object object, int n, int n2) {
                    Button button = new Button("a");
                    button.setHeight(new Extent(1));
                    button.setWidth(new Extent(1));
                    TableLayoutData tableLayoutData = new TableLayoutData();
                    tableLayoutData.setInsets(new Insets(0));
                    button.setLayoutData((LayoutData)tableLayoutData);
                    return button;
                }
            });
        }
        return this.columnModel;
    }

    private void initComponents() {
        this.setHeight(new Extent(230, 1));
        this.setScrollVisible(false);
        this.mainGrid = new Grid();
        this.mainGrid.setHeight(new Extent(230, 1));
        this.mainGrid.setColumnWidth(0, new Extent(50, 2));
        this.mainGrid.setColumnWidth(1, new Extent(51, 1));
        this.mainGrid.setColumnWidth(2, new Extent(50, 2));
        this.mainGrid.setSize(3);
        this.add((Component)this.mainGrid);
        this.selectedLabel = new StrLabelMedium();
        this.selectedLabel.setText("selected");
        GridLayoutData gridLayoutData = new GridLayoutData();
        gridLayoutData.setAlignment(new Alignment(4, 0));
        this.selectedLabel.setLayoutData((LayoutData)gridLayoutData);
        this.mainGrid.add((Component)this.selectedLabel);
        this.emptyPanel = new ScrollPanel();
        this.emptyPanel.setHeight(new Extent(20, 1));
        this.emptyPanel.setScrollVisible(false);
        this.emptyPanel.setWidth(new Extent(49, 1));
        this.mainGrid.add((Component)this.emptyPanel);
        this.availableLabel = new StrLabelMedium();
        this.availableLabel.setText("available");
        GridLayoutData gridLayoutData2 = new GridLayoutData();
        gridLayoutData2.setAlignment(new Alignment(4, 0));
        this.availableLabel.setLayoutData((LayoutData)gridLayoutData2);
        this.mainGrid.add((Component)this.availableLabel);
        this.selectedContainer = new ContainerEx();
        this.selectedContainer.setHeight(new Extent(208, 1));
        GridLayoutData gridLayoutData3 = new GridLayoutData();
        gridLayoutData3.setAlignment(new Alignment(0, 6));
        gridLayoutData3.setRowSpan(2);
        this.selectedContainer.setLayoutData((LayoutData)gridLayoutData3);
        this.mainGrid.add((Component)this.selectedContainer);
        this.selectedTable = new SortTable();
        this.selectedTable.setHeaderVisible(false);
        this.selectedTable.setFont(new Font(new Font.Typeface("sans-serif"), 0, new Extent(9, 4)));
        this.selectedTable.setWidth(new Extent(100, 2));
        this.selectedTable.setBorder(new Border(new Extent(0, 1), Color.BLACK, 1));
        this.selectedContainer.add((Component)this.selectedTable);
        this.leftRightButtons = new Column();
        GridLayoutData gridLayoutData4 = new GridLayoutData();
        gridLayoutData4.setAlignment(new Alignment(0, 6));
        this.leftRightButtons.setLayoutData((LayoutData)gridLayoutData4);
        this.mainGrid.add((Component)this.leftRightButtons);
        this.leftButton = new StrButton();
        this.leftButton.setStyleName("StrToggleButtonForColumn_45x30_Style");
        this.leftButton.setActionCommand("left");
        this.leftRightButtons.add((Component)this.leftButton);
        this.leftAllButton = new StrButton();
        this.leftAllButton.setStyleName("StrToggleButtonForColumn_45x30_Style");
        this.leftAllButton.setActionCommand("leftAll");
        this.leftRightButtons.add((Component)this.leftAllButton);
        this.rightButton = new StrButton();
        this.rightButton.setStyleName("StrToggleButtonForColumn_45x30_Style");
        this.rightButton.setActionCommand("right");
        this.leftRightButtons.add((Component)this.rightButton);
        this.rightAllButton = new StrButton();
        this.rightAllButton.setStyleName("StrToggleButtonForColumn_45x30_Style");
        this.rightAllButton.setActionCommand("rightAll");
        this.leftRightButtons.add((Component)this.rightAllButton);
        this.availableContainer = new ContainerEx();
        this.availableContainer.setHeight(new Extent(208, 1));
        GridLayoutData gridLayoutData5 = new GridLayoutData();
        gridLayoutData5.setAlignment(new Alignment(0, 6));
        gridLayoutData5.setRowSpan(2);
        this.availableContainer.setLayoutData((LayoutData)gridLayoutData5);
        this.mainGrid.add((Component)this.availableContainer);
        this.availableTable = new SortTable();
        this.availableTable.setHeaderVisible(false);
        this.availableTable.setFont(new Font(new Font.Typeface("sans-serif"), 0, new Extent(9, 4)));
        this.availableTable.setWidth(new Extent(100, 2));
        this.availableTable.setBorder(new Border(new Extent(0, 1), Color.BLACK, 1));
        this.availableContainer.add((Component)this.availableTable);
        this.upDownButtons = new Row();
        GridLayoutData gridLayoutData6 = new GridLayoutData();
        gridLayoutData6.setAlignment(new Alignment(0, 7));
        this.upDownButtons.setLayoutData((LayoutData)gridLayoutData6);
        this.mainGrid.add((Component)this.upDownButtons);
        this.upDownButtonsColumn = new Column();
        RowLayoutData rowLayoutData = new RowLayoutData();
        rowLayoutData.setInsets(new Insets(new Extent(2, 1), new Extent(0, 1), new Extent(0, 1), new Extent(0, 1)));
        this.upDownButtonsColumn.setLayoutData((LayoutData)rowLayoutData);
        this.upDownButtons.add((Component)this.upDownButtonsColumn);
        this.sortButton = new StrButton();
        this.sortButton.setStyleName("StrToggleButtonForColumn_32x30_Style");
        this.sortButton.setActionCommand("sort");
        this.upDownButtonsColumn.add((Component)this.sortButton);
        this.upButton = new StrButton();
        this.upButton.setStyleName("StrToggleButtonForColumn_32x30_Style");
        this.upButton.setActionCommand("up");
        this.upDownButtonsColumn.add((Component)this.upButton);
        this.downButton = new StrButton();
        this.downButton.setStyleName("StrToggleButtonForColumn_32x30_Style");
        this.downButton.setActionCommand("down");
        this.upDownButtonsColumn.add((Component)this.downButton);
    }

    private void initListeners() {
        this.sortProcessor = new SortProcessor();
        this.leftButton.addActionListener(this.internalActionProcessor);
        this.leftAllButton.addActionListener(this.internalActionProcessor);
        this.rightButton.addActionListener(this.internalActionProcessor);
        this.rightAllButton.addActionListener(this.internalActionProcessor);
        this.sortButton.addActionListener(this.internalActionProcessor);
        this.upButton.addActionListener(this.internalActionProcessor);
        this.downButton.addActionListener(this.internalActionProcessor);
        this.availableTable.addMouseListener(this.mouseProcessor);
        this.selectedTable.addMouseListener(this.mouseProcessor);
        this.availableTable.addPropertyChangeListener(this.propertyProcessor);
        this.selectedTable.addPropertyChangeListener(this.propertyProcessor);
        this.selectedTable.getSelectionModel().addChangeListener((ChangeListener)new ChangeProcessor());
        this.availableTable.addSortListener(this.sortProcessor);
        this.selectedTable.addSortListener(this.sortProcessor);
    }

    private void initResources() {
        this.selectedLabel.setText(this.res.selectedLabelText);
        this.availableLabel.setText(this.res.availableLabelText);
        this.leftButton.setToolTipText(this.res.leftButtonToolTip);
        this.leftAllButton.setToolTipText(this.res.leftAllButtonToolTip);
        this.rightButton.setToolTipText(this.res.rightButtonToolTip);
        this.rightAllButton.setToolTipText(this.res.rightAllButtonToolTip);
        this.sortButton.setToolTipText(this.res.sortButtonToolTip);
        this.upButton.setToolTipText(this.res.upButtonToolTip);
        this.downButton.setToolTipText(this.res.downButtonToolTip);
        this.leftButton.setIcon(this.res.leftButtonIconEnabled);
        this.leftButton.setDisabledIcon(this.res.leftButtonIconDisabled);
        this.leftAllButton.setIcon(this.res.leftAllButtonIconEnabled);
        this.leftAllButton.setDisabledIcon(this.res.leftAllButtonIconDisabled);
        this.rightButton.setIcon(this.res.rightButtonIconEnabled);
        this.rightButton.setDisabledIcon(this.res.rightButtonIconDisabled);
        this.rightAllButton.setIcon(this.res.rightAllButtonIconEnabled);
        this.rightAllButton.setDisabledIcon(this.res.rightAllButtonIconDisabled);
        this.sortButton.setIcon(this.res.sortButtonIconEnabled);
        this.sortButton.setDisabledIcon(this.res.sortButtonIconDisabled);
        this.upButton.setIcon(this.res.upButtonIconEnabled);
        this.upButton.setDisabledIcon(this.res.upButtonIconDisabled);
        this.downButton.setIcon(this.res.downButtonIconEnabled);
        this.downButton.setDisabledIcon(this.res.downButtonIconDisabled);
    }

    protected void fireSelectionChanged(Object object) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(SelectionListener.class);
        SelectionEvent selectionEvent = new SelectionEvent((Object)this, object);
        for (EventListener eventListener : eventListenerArray) {
            ((SelectionListener)eventListener).selectionChanged(selectionEvent);
        }
    }

    protected void fireTablePropertyChanged() {
        this.firePropertyChange(TABLE_SELECTION_CHANGED, false, true);
    }

    private class SortProcessor
    implements SortListener {
        private SortProcessor() {
        }

        public void sortPerformed(SortEvent sortEvent) {
            SortableTableModel sortableTableModel = (SortableTableModel)sortEvent.getSource();
            sortableTableModel.getTableObject().sortTable(sortEvent.getColumnNumber(), sortEvent.isAscending());
        }
    }

    private class Res {
        private String availableLabelText;
        private String downButtonToolTip;
        private String leftAllButtonToolTip;
        private String leftButtonToolTip;
        private String rightAllButtonToolTip;
        private String rightButtonToolTip;
        private String selectedLabelText;
        private String sortButtonToolTip;
        private String upButtonToolTip;
        private ImageReference downButtonIconDisabled;
        private ImageReference downButtonIconEnabled;
        private ImageReference leftAllButtonIconDisabled;
        private ImageReference leftAllButtonIconEnabled;
        private ImageReference leftButtonIconDisabled;
        private ImageReference leftButtonIconEnabled;
        private ImageReference rightAllButtonIconDisabled;
        private ImageReference rightAllButtonIconEnabled;
        private ImageReference rightButtonIconDisabled;
        private ImageReference rightButtonIconEnabled;
        private ImageReference sortButtonIconDisabled;
        private ImageReference sortButtonIconEnabled;
        private ImageReference upButtonIconDisabled;
        private ImageReference upButtonIconEnabled;

        private Res() {
        }
    }

    private class ChangeProcessor
    implements ChangeListener {
        private static final long serialVersionUID = 3903495947932125364L;

        private ChangeProcessor() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() instanceof DefaultListSelectionModel) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)changeEvent.getSource();
                if (defaultListSelectionModel.getMinSelectedIndex() != -1) {
                    DoubleTableContainer.this.fireSelectionChanged(DoubleTableContainer.this.selectedTable.getSelectedRow());
                } else {
                    DoubleTableContainer.this.fireSelectionChanged(null);
                }
            }
        }
    }

    public static interface SelectionListener
    extends EventListener {
        public void selectionChanged(SelectionEvent var1);
    }

    public static class SelectionEvent
    extends EventObject {
        private static final long serialVersionUID = 3569304630753355656L;
        private final Object selectedObject;

        public SelectionEvent(Object object, Object object2) {
            super(object);
            this.selectedObject = object2;
        }

        public Object getSelectedObject() {
            return this.selectedObject;
        }
    }
}

