/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Color;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Grid;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.Insets;
import nextapp.echo.app.Label;
import nextapp.echo.app.LayoutData;
import nextapp.echo.app.Table;
import nextapp.echo.app.event.TableModelListener;
import nextapp.echo.app.layout.GridLayoutData;
import nextapp.echo.app.layout.TableLayoutData;
import nextapp.echo.app.table.DefaultTableColumnModel;
import nextapp.echo.app.table.TableCellRenderer;
import nextapp.echo.app.table.TableColumn;
import nextapp.echo.app.table.TableColumnModel;
import nextapp.echo.app.table.TableModel;
import pl.com.stream.echo.lib.type.TDetailsTableObject;
import pl.com.stream.echo.lib.type.column.ITableColumn;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.echo.lib.util.IImageReferenceFactory;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetailsTable
extends Table {
    public static String PROPERTY_LABEL_COLUMN_WIDTH = "labelColumnWidth";
    public static String PROPERTY_VALUE_COLUMN_WIDTH = "valueColumnWidth";
    private static final long serialVersionUID = 1764365549793786489L;
    private ColumnsCount columnsCount;
    private IImageReferenceFactory factory;
    private DefaultTableColumnModel fourColumnsModel;
    private Extent labelColumnWidth;
    private final DetailsTableModel model;
    @ResourceContainer
    private Res res;
    private DefaultTableColumnModel twoColumnsModel;
    private Extent valueColumnWidth;

    public DetailsTable() {
        ResourceManager.bind((Object)((Object)this), (Locale)ClientLocale.getCurrent());
        this.initSessionObjects();
        this.initComponents();
        this.setDefaultRenderer(TableColumn.class, new DetailsCellRenderer());
        this.setAutoCreateColumnsFromModel(false);
        this.setHeaderVisible(false);
        this.model = new DetailsTableModel();
        this.setColumnsCount(ColumnsCount.four);
        this.setModel(this.model);
    }

    public ColumnsCount getColumnsCount() {
        return this.columnsCount;
    }

    public Extent getLabelColumnWidth() {
        return this.labelColumnWidth;
    }

    public Extent getValueColumnWidth() {
        return this.valueColumnWidth;
    }

    public void removeAllRows() {
        this.model.removeAllRows();
    }

    public void setColumnsCount(ColumnsCount columnsCount) {
        this.columnsCount = columnsCount;
        this.model.setColumnsCount(columnsCount);
        switch (columnsCount) {
            case two: {
                this.setColumnModel((TableColumnModel)this.getTwoColumnsModel());
                break;
            }
            case four: {
                this.setColumnModel((TableColumnModel)this.getFourColumnsModel());
            }
        }
    }

    public void setLabelColumnWidth(Extent extent) {
        this.labelColumnWidth = extent;
        this.set(PROPERTY_LABEL_COLUMN_WIDTH, extent);
    }

    public void setTableObject(Integer n, List<TDetailsTableObject> list) {
        this.model.setRowId(n);
        this.model.setDetails(list);
    }

    public void setValueColumnWidth(Extent extent) {
        this.valueColumnWidth = extent;
        this.set(PROPERTY_VALUE_COLUMN_WIDTH, extent);
    }

    private DefaultTableColumnModel getFourColumnsModel() {
        if (this.fourColumnsModel == null) {
            this.fourColumnsModel = new DefaultTableColumnModel();
            TableColumn tableColumn = new TableColumn(0);
            tableColumn.setWidth(null);
            tableColumn.setHeaderValue((Object)this.res.fieldHeaderText);
            TableColumn tableColumn2 = new TableColumn(1);
            tableColumn2.setWidth(new Extent(30, 2));
            tableColumn2.setHeaderValue((Object)this.res.valueHeaderText);
            TableColumn tableColumn3 = new TableColumn(2);
            tableColumn3.setWidth(null);
            tableColumn3.setHeaderValue((Object)this.res.fieldHeaderText);
            TableColumn tableColumn4 = new TableColumn(3);
            tableColumn4.setWidth(new Extent(30, 2));
            tableColumn4.setHeaderValue((Object)this.res.valueHeaderText);
            this.fourColumnsModel.addColumn(tableColumn);
            this.fourColumnsModel.addColumn(tableColumn2);
            this.fourColumnsModel.addColumn(tableColumn3);
            this.fourColumnsModel.addColumn(tableColumn4);
        }
        return this.fourColumnsModel;
    }

    private DefaultTableColumnModel getTwoColumnsModel() {
        if (this.twoColumnsModel == null) {
            this.twoColumnsModel = new DefaultTableColumnModel();
            TableColumn tableColumn = new TableColumn(0);
            tableColumn.setWidth(null);
            tableColumn.setHeaderValue((Object)this.res.fieldHeaderText);
            TableColumn tableColumn2 = new TableColumn(1);
            tableColumn2.setWidth(null);
            tableColumn2.setHeaderValue((Object)this.res.valueHeaderText);
            this.twoColumnsModel.addColumn(tableColumn);
            this.twoColumnsModel.addColumn(tableColumn2);
        }
        return this.twoColumnsModel;
    }

    private void initComponents() {
    }

    protected void initSessionObjects() {
        this.factory = null;
    }

    private class Res {
        private String fieldHeaderText;
        private String lack;
        private String valueHeaderText;

        private Res() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DetailsTableModel
    implements TableModel {
        private static final long serialVersionUID = 8218559947961725063L;
        private ColumnsCount columnsCount;
        private List<TDetailsTableObject> details;
        private Integer rowId;

        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        public Class<TableColumn> getColumnClass(int n) {
            return TableColumn.class;
        }

        public int getColumnCount() {
            return this.getColumnsCount().getColumnCount();
        }

        public String getColumnName(int n) {
            return "";
        }

        public ColumnsCount getColumnsCount() {
            return this.columnsCount;
        }

        public int getRowCount() {
            switch (this.getColumnsCount()) {
                case two: {
                    return this.details == null ? 1 : this.details.size();
                }
                case four: {
                    return this.details == null ? 1 : new BigDecimal(this.details.size()).divide(new BigDecimal(2), RoundingMode.UP).intValue();
                }
            }
            return this.details == null ? 1 : this.details.size();
        }

        public Integer getRowId() {
            return this.rowId;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Object getValueAt(int n, int n2) {
            if (this.details == null) {
                return null;
            }
            switch (this.getColumnsCount()) {
                case two: {
                    if (n == 0) {
                        return this.details.get(n2).getColumnLabel();
                    }
                    if (n != 1) return null;
                    return this.details.get(n2);
                }
                case four: {
                    int n3 = new BigDecimal(this.details.size()).divide(new BigDecimal(2), RoundingMode.UP).intValue();
                    int n4 = n3 + n2;
                    switch (n) {
                        case 0: {
                            return this.details.get(n2).getColumnLabel();
                        }
                        case 1: {
                            return this.details.get(n2);
                        }
                        case 2: {
                            if (n4 < this.details.size()) {
                                return this.details.get(n4).getColumnLabel();
                            }
                        }
                        case 3: {
                            if (n4 >= this.details.size()) return null;
                            return this.details.get(n4);
                        }
                    }
                    return null;
                }
            }
            return null;
        }

        public void removeAllRows() {
            if (this.details != null) {
                this.details.clear();
                DetailsTable.this.invalidate();
            }
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
        }

        public void setColumnsCount(ColumnsCount columnsCount) {
            this.columnsCount = columnsCount;
        }

        public void setDetails(List<TDetailsTableObject> list) {
            this.details = list;
            DetailsTable.this.invalidate();
        }

        public void setRowId(Integer n) {
            this.rowId = n;
        }
    }

    public class DetailsCellRenderer
    implements TableCellRenderer {
        private static final long serialVersionUID = -1214243802326069249L;
        private final SimpleDateFormat longDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
        private final SimpleDateFormat shortDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DecimalFormat decimalFormat = new DecimalFormat(",##0.00");

        public Component getTableCellRendererComponent(Table table, Object object, int n, int n2) {
            Label label;
            block26: {
                Object object2;
                block27: {
                    if (object == null) {
                        return null;
                    }
                    label = new Label();
                    TableLayoutData tableLayoutData = new TableLayoutData();
                    tableLayoutData.setInsets(new Insets(5, 5, 15, 0));
                    label.setLayoutData((LayoutData)tableLayoutData);
                    switch (DetailsTable.this.getColumnsCount()) {
                        case two: {
                            if (n == 0) {
                                label.setStyleName("DetailsLabelStyle");
                                label.setText(object.toString());
                            }
                            if (n != 1) break;
                            label.setStyleName("DetailsValueStyle");
                            break;
                        }
                        case four: {
                            if (n == 0) {
                                label.setStyleName("DetailsLabelStyle");
                                label.setText(object.toString());
                            }
                            if (n == 1) {
                                label.setStyleName("DetailsValueStyle");
                            }
                            if (n == 2) {
                                label.setStyleName("DetailsLabelStyle");
                                label.setText(object.toString());
                            }
                            if (n != 3) break;
                            label.setStyleName("DetailsValueStyle");
                        }
                    }
                    if (n != 1 && n != 3 || !(object instanceof TDetailsTableObject)) break block26;
                    TDetailsTableObject tDetailsTableObject = (TDetailsTableObject)object;
                    ITableColumn iTableColumn = tDetailsTableObject.getColumnIdentifier();
                    object2 = tDetailsTableObject.getColumnValue();
                    if (iTableColumn == null) break block27;
                    switch (iTableColumn.getRodzajWysw()) {
                        case rwIloscGM: {
                            if (object2 instanceof BigDecimal) {
                                BigDecimal bigDecimal = (BigDecimal)object2;
                                BigDecimal bigDecimal2 = bigDecimal.setScale(2, RoundingMode.HALF_UP);
                                if (bigDecimal2.equals(new BigDecimal(0).setScale(2, RoundingMode.HALF_UP))) {
                                    label.setText(DetailsTable.this.res.lack);
                                    label.setForeground(new Color(255, 0, 0));
                                    break;
                                }
                                label.setText(this.decimalFormat.format(bigDecimal.doubleValue()));
                                break;
                            }
                            break block26;
                        }
                        case rwCenaBezWal: 
                        case rwCenaNetto: 
                        case rwCenaBrutto: {
                            if (object2 instanceof BigDecimal) {
                                BigDecimal bigDecimal = (BigDecimal)object2;
                                DecimalFormat decimalFormat = new DecimalFormat(",##0.00");
                                label.setText(decimalFormat.format(bigDecimal.doubleValue()));
                                break;
                            }
                            break block26;
                        }
                        case rwDataCzasGodzMin: {
                            if (object2 instanceof Timestamp) {
                                Timestamp timestamp = (Timestamp)object2;
                                label.setText(this.longDateFormat.format(timestamp));
                                break;
                            }
                            break block26;
                        }
                        case rwData: {
                            if (object2 instanceof Timestamp) {
                                Timestamp timestamp = (Timestamp)object2;
                                label.setText(this.shortDateFormat.format(timestamp));
                                break;
                            }
                            break block26;
                        }
                        case rwProcent: {
                            if (object2 instanceof Integer) {
                                Integer n3 = (Integer)object2;
                                label.setText(n3 == null ? "0%" : n3 + "%");
                                break;
                            }
                            break block26;
                        }
                        case rwZdjecie: {
                            GridLayoutData gridLayoutData = new GridLayoutData();
                            gridLayoutData.setAlignment(new Alignment(4, 4));
                            gridLayoutData.setInsets(new Insets(1));
                            label.setLayoutData((LayoutData)gridLayoutData);
                            TableLayoutData tableLayoutData2 = new TableLayoutData();
                            tableLayoutData2.setInsets(new Insets(1));
                            Grid grid = new Grid(1);
                            grid.setLayoutData((LayoutData)tableLayoutData2);
                            grid.add((Component)label);
                            if (DetailsTable.this.factory == null) {
                                return grid;
                            }
                            IImageReferenceFactory.RozmiarZdjecia rozmiarZdjecia = IImageReferenceFactory.RozmiarZdjecia.min;
                            ImageReference imageReference = DetailsTable.this.factory.getImageReference(object2, rozmiarZdjecia);
                            if (imageReference == null) {
                                return grid;
                            }
                            grid.setColumnWidth(0, new Extent(rozmiarZdjecia.getWidth().intValue()));
                            grid.setRowHeight(0, new Extent(rozmiarZdjecia.getHeight().intValue()));
                            label.setIcon(imageReference);
                            return grid;
                        }
                        case rwInne: {
                            label.setText(object2 == null ? (String)null : object2.toString());
                            break;
                        }
                        default: {
                            label.setText(object2 == null ? (String)null : object2.toString());
                        }
                    }
                    break block26;
                }
                label.setText(object2 == null ? (String)null : object2.toString());
            }
            return label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColumnsCount {
        four(4),
        two(2);

        private int columnCount;

        private ColumnsCount(int n2) {
            this.columnCount = n2;
        }

        public int getColumnCount() {
            return this.columnCount;
        }
    }
}

