/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.Locale;
import nextapp.echo.app.Alignment;
import nextapp.echo.app.Component;
import nextapp.echo.app.Extent;
import nextapp.echo.app.Grid;
import nextapp.echo.app.ImageReference;
import nextapp.echo.app.LayoutData;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import nextapp.echo.app.layout.GridLayoutData;
import pl.com.stream.echo.lib.component.StrSquareButton;
import pl.com.stream.echo.lib.component.StrTextField;
import pl.com.stream.echo.lib.component.window.CalendarWindow;
import pl.com.stream.echo.lib.component.window.DialogWindow;
import pl.com.stream.echo.lib.event.DateChangeListener;
import pl.com.stream.echo.lib.event.DateChangedEvent;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class DateTextFieldGrid
extends Grid {
    private static final long serialVersionUID = -6433085773654706690L;
    private final ActionListener actionProcessor = new ActionListener(){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            final CalendarWindow calendarWindow = new CalendarWindow();
            calendarWindow.setDate(DateTextFieldGrid.this.selectedDate);
            calendarWindow.open();
            calendarWindow.addActionListener(new ActionListener(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (DialogWindow.ButtonCommand.OK.getActionCommand().equals(actionEvent.getActionCommand())) {
                        calendarWindow.close();
                        Date date = calendarWindow.getDate();
                        DateTextFieldGrid.this.setDate(date);
                        DateTextFieldGrid.this.fireDateChanged(date);
                    }
                }
            });
        }
    };
    private StrSquareButton dateButton;
    private final SimpleDateFormat longDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    @ResourceContainer
    private Res res;
    private Date selectedDate;
    private final SimpleDateFormat shortDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private StrTextField textField;

    public DateTextFieldGrid() {
        this(Calendar.getInstance());
    }

    public DateTextFieldGrid(Calendar calendar) {
        this(calendar.getTime());
    }

    public DateTextFieldGrid(Date date) {
        ResourceManager.bind((Object)((Object)this), (Locale)ClientLocale.getCurrent());
        this.initComponents();
        this.initResources();
        this.initActionListeners();
        this.setDate(date);
    }

    public void addDateChangeListener(DateChangeListener dateChangeListener) {
        this.getEventListenerList().addListener(DateChangeListener.class, (EventListener)dateChangeListener);
    }

    public Date getDate() {
        return this.selectedDate;
    }

    public String getDateAsLongString() {
        return this.longDateFormat.format(this.selectedDate);
    }

    public String getDateAsString() {
        return this.shortDateFormat.format(this.selectedDate);
    }

    public void removeDateChangeListener(DateChangeListener dateChangeListener) {
        this.getEventListenerList().removeListener(DateChangeListener.class, (EventListener)dateChangeListener);
    }

    public void setDate(Date date) {
        this.selectedDate = date;
        this.textField.setText(this.getDateAsString());
    }

    public void setWidth(Extent extent) {
        super.setWidth(extent);
        if (this.textField != null && this.dateButton != null) {
            Extent extent2 = new Extent(extent.getValue() - 25, extent.getUnits());
            Extent extent3 = new Extent(25);
            this.textField.setWidth(extent2);
            this.dateButton.setWidth(extent3);
            this.setColumnWidth(0, extent2);
            this.setColumnWidth(1, extent3);
        }
    }

    private void fireDateChanged(Date date) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(DateChangeListener.class);
        DateChangedEvent dateChangedEvent = new DateChangedEvent((Object)this, date);
        for (EventListener eventListener : eventListenerArray) {
            ((DateChangeListener)eventListener).dateChanged(dateChangedEvent);
        }
    }

    private void initActionListeners() {
        this.dateButton.addActionListener(this.actionProcessor);
    }

    private void initComponents() {
        this.setWidth(new Extent(125, 1));
        this.setColumnWidth(0, new Extent(100, 1));
        this.setColumnWidth(1, new Extent(25, 1));
        this.textField = new StrTextField();
        this.textField.setEnabled(false);
        this.textField.setWidth(new Extent(100, 1));
        this.add((Component)this.textField);
        this.dateButton = new StrSquareButton();
        this.dateButton.setStyleName("StrSquareButtonStyle");
        this.dateButton.setActionCommand("date");
        GridLayoutData gridLayoutData = new GridLayoutData();
        gridLayoutData.setAlignment(new Alignment(4, 4));
        this.dateButton.setLayoutData((LayoutData)gridLayoutData);
        this.add((Component)this.dateButton);
    }

    private void initResources() {
        this.dateButton.setToolTipText(this.res.dateButtonToolTip);
        this.dateButton.setIcon(this.res.dateButtonIconEnabled);
        this.dateButton.setDisabledIcon(this.res.dateButtonIconDisabled);
    }

    private class Res {
        private ImageReference dateButtonIconDisabled;
        private ImageReference dateButtonIconEnabled;
        private String dateButtonToolTip;

        private Res() {
        }
    }
}

