/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.component;

import java.util.EventListener;
import java.util.EventObject;
import java.util.Locale;
import nextapp.echo.app.event.ActionEvent;
import nextapp.echo.app.event.ActionListener;
import pl.com.stream.echo.lib.component.SortTable;
import pl.com.stream.echo.lib.component.table.SortableTableColumn;
import pl.com.stream.echo.lib.component.table.SortableTableModel;
import pl.com.stream.echo.lib.component.window.DialogWindow;
import pl.com.stream.echo.lib.component.window.MessageWindow;
import pl.com.stream.echo.lib.database.criterion.Criterion;
import pl.com.stream.echo.lib.event.SortEvent;
import pl.com.stream.echo.lib.event.SortListener;
import pl.com.stream.echo.lib.event.SortTableEvent;
import pl.com.stream.echo.lib.event.SortTableListener;
import pl.com.stream.echo.lib.type.TJoinTable;
import pl.com.stream.echo.lib.type.TSelectedTableColumnList;
import pl.com.stream.echo.lib.type.TSelectedTableColumnOrderList;
import pl.com.stream.echo.lib.type.TTableRowObject;
import pl.com.stream.echo.lib.type.column.ITableColumn;
import pl.com.stream.echo.lib.type.sql.TSqlOrderByObject;
import pl.com.stream.echo.lib.util.ClientLocale;
import pl.com.stream.echo.lib.util.TableDataManager;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class BrowserTable
extends SortTable {
    private static final long serialVersionUID = -3070780216842658427L;
    private TSelectedTableColumnOrderList columnOrderList;
    private Criterion criterion;
    private TableDataManager dataManager;
    private final boolean loaded = false;
    private TJoinTable masterTable;
    @ResourceContainer
    private Res res;
    private TSelectedTableColumnList tableColumnList;

    public BrowserTable() {
        ResourceManager.bind((Object)((Object)this), (Locale)ClientLocale.getCurrent());
        this.initListeners();
    }

    public void addTableChangeListener(TableChangeListener tableChangeListener) {
        this.getEventListenerList().addListener(TableChangeListener.class, (EventListener)tableChangeListener);
    }

    public void doRemove() {
        if (this.getSelectedRow() == null) {
            return;
        }
        final MessageWindow messageWindow = new MessageWindow(this.res.questionTitle, this.res.removeItem, DialogWindow.ButtonMask.Tak_Nie);
        messageWindow.open();
        messageWindow.addActionListener(new ActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogWindow.ButtonCommand.Tak.getActionCommand().equals(actionEvent.getActionCommand())) {
                    messageWindow.close();
                    BrowserTable.this.removeRow((TTableRowObject)BrowserTable.this.getSelectedRow());
                }
            }
        });
    }

    public void refresh() {
        this.doLoad();
        this.getDataManager().refresh();
    }

    public void removeTableChangeListener(TableChangeListener tableChangeListener) {
        this.getEventListenerList().removeListener(TableChangeListener.class, (EventListener)tableChangeListener);
    }

    public void selectRowWithId(Integer n) {
        SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
        int n2 = 0;
        for (int i = 0; i < sortableTableModel.getRowCount(); ++i) {
            TTableRowObject tTableRowObject;
            Object object = sortableTableModel.getRow(i);
            if (!(object instanceof TTableRowObject) || !(tTableRowObject = (TTableRowObject)object).getId().equals(n)) continue;
            n2 = i;
            break;
        }
        this.refreshRowSelection(n2);
    }

    public void setColumnOrderList(TSelectedTableColumnOrderList tSelectedTableColumnOrderList) {
        this.columnOrderList = tSelectedTableColumnOrderList;
    }

    public void setCriterion(Criterion criterion) {
        this.criterion = criterion;
    }

    public void setMasterTable(TJoinTable tJoinTable) {
        this.masterTable = tJoinTable;
    }

    public void setTableColumnList(TSelectedTableColumnList tSelectedTableColumnList) {
        this.tableColumnList = tSelectedTableColumnList;
    }

    private TableDataManager getDataManager() {
        if (this.dataManager == null) {
            this.dataManager = new TableDataManager();
            this.dataManager.setLockExecuteQuery(true);
            this.dataManager.setFormatSQLQuery(true);
            this.dataManager.setPartialResult(false);
            this.dataManager.addSortTableListener(new SortTableListener(){

                public void columnOrderChanged(SortTableEvent sortTableEvent) {
                    BrowserTable.this.setColumnsOrder(sortTableEvent.getColumnOrderList());
                }

                public void tableObjectChanged(SortTableEvent sortTableEvent) {
                    BrowserTable.this.setTableObject(sortTableEvent.getTableObject());
                    TTableRowObject tTableRowObject = (TTableRowObject)BrowserTable.this.getSelectedRow();
                    BrowserTable.this.fireTableModelChanged(tTableRowObject != null);
                }

                public void tableVisibleColumnsChanged(SortTableEvent sortTableEvent) {
                }
            });
        }
        return this.dataManager;
    }

    private void initListeners() {
        this.addSortListener(new SortListener(){

            public void sortPerformed(SortEvent sortEvent) {
                SortableTableColumn sortableTableColumn = (SortableTableColumn)BrowserTable.this.getColumnModel().getColumn(sortEvent.getColumnNumber());
                if (sortableTableColumn.getIdentifier() instanceof ITableColumn) {
                    ITableColumn iTableColumn = (ITableColumn)sortableTableColumn.getIdentifier();
                    TSelectedTableColumnOrderList tSelectedTableColumnOrderList = new TSelectedTableColumnOrderList();
                    tSelectedTableColumnOrderList.addColumn(iTableColumn.getTableAlias(), iTableColumn.getName(), sortEvent.isAscending() ? TSqlOrderByObject.OrderTypes.ASC : TSqlOrderByObject.OrderTypes.DESC);
                    BrowserTable.this.getDataManager().setSelectedColumnOrderList(tSelectedTableColumnOrderList);
                }
            }
        });
    }

    private void refreshRowSelection(int n) {
        this.refreshSelection(n);
        TTableRowObject tTableRowObject = (TTableRowObject)this.getSelectedRow();
        this.getDataManager().setSelectedRowId(tTableRowObject != null ? tTableRowObject.getId() : null);
    }

    private void removeRow(TTableRowObject tTableRowObject) {
        if (tTableRowObject == null) {
            return;
        }
        this.removeRowFromDB(tTableRowObject.getId());
        this.removeRowFromTable(tTableRowObject);
    }

    private void removeRowFromDB(Integer n) {
        this.fireRowDeleted(n);
    }

    private void removeRowFromTable(TTableRowObject tTableRowObject) {
        SortableTableModel sortableTableModel = (SortableTableModel)this.getModel();
        int n = sortableTableModel.indexOf(tTableRowObject);
        sortableTableModel.removeRow(n);
        this.getDataManager().refresh();
        this.refreshRowSelection(n);
    }

    protected void doLoad() {
        this.getDataManager().setLockExecuteQuery(true);
        this.getDataManager().setProgramFilter(this.criterion);
        this.getDataManager().setMasterTable(this.masterTable);
        this.getDataManager().setSelectedTableColumnList(this.tableColumnList);
        this.getDataManager().setSelectedColumnOrderList(this.columnOrderList);
        this.getDataManager().setLockExecuteQuery(false);
        this.setColumnModelFromTVisibleColumns(this.getDataManager().getVisibleColumnList());
        this.setColumnsOrder(this.getDataManager().getSelectedColumnOrderList());
    }

    protected void fireRowDeleted(Integer n) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(TableChangeListener.class);
        DeleteEvent deleteEvent = new DeleteEvent((Object)this, n);
        for (EventListener eventListener : eventListenerArray) {
            ((TableChangeListener)eventListener).rowDeleted(deleteEvent);
        }
    }

    protected void fireTableModelChanged(boolean bl) {
        EventListener[] eventListenerArray = this.getEventListenerList().getListeners(TableChangeListener.class);
        SelectionEvent selectionEvent = new SelectionEvent((Object)this, bl);
        for (EventListener eventListener : eventListenerArray) {
            ((TableChangeListener)eventListener).selectionChanged(selectionEvent);
        }
    }

    private class Res {
        private String questionTitle;
        private String removeItem;

        private Res() {
        }
    }

    public static interface TableChangeListener
    extends EventListener {
        public void rowDeleted(DeleteEvent var1);

        public void selectionChanged(SelectionEvent var1);
    }

    public static class SelectionEvent
    extends EventObject {
        private static final long serialVersionUID = -1674989006229721340L;
        private final boolean rowSelected;

        public SelectionEvent(Object object, boolean bl) {
            super(object);
            this.rowSelected = bl;
        }

        public boolean isRowSelected() {
            return this.rowSelected;
        }
    }

    public static class DeleteEvent
    extends EventObject {
        private static final long serialVersionUID = -8111369459041922529L;
        private final Integer id;

        public DeleteEvent(Object object, Integer n) {
            super(object);
            this.id = n;
        }

        public Integer getId() {
            return this.id;
        }
    }
}

