/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pl.com.stream.echo.lib.action.Action;
import pl.com.stream.echo.lib.action.ActionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractActionGroup
implements ActionGroup {
    private List<Action> actionList;
    private PropertyChangeForwarder changeForwarder;
    private PropertyChangeSupport changeSupport;
    private boolean enabled = true;
    private boolean visible = true;

    @Override
    public void addAction(Action action) {
        this.getActionList().add(action);
        action.addPropertyChangeListener(this.getChangeForwarder());
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public Action getAction(int n) {
        return this.getActionList().get(n);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public Iterator<Action> iterator() {
        return this.getActionList().iterator();
    }

    @Override
    public void removeAction(Action action) {
        this.getActionList().remove(action);
        action.removePropertyChangeListener(this.getChangeForwarder());
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void requestActivation() {
        this.firePropertyChange("groupActivated", false, true);
    }

    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        if (bl2 != bl) {
            this.firePropertyChange("groupEnabled", bl2, bl);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        boolean bl2 = this.visible;
        this.visible = bl;
        if (bl2 != bl) {
            this.firePropertyChange("groupVisible", bl2, bl);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport == null || object != null && object2 != null && object.equals(object2)) {
            return;
        }
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    protected List<Action> getActionList() {
        if (this.actionList == null) {
            this.actionList = new ArrayList<Action>();
        }
        return this.actionList;
    }

    protected PropertyChangeForwarder getChangeForwarder() {
        if (this.changeForwarder == null) {
            this.changeForwarder = new PropertyChangeForwarder();
        }
        return this.changeForwarder;
    }

    private class PropertyChangeForwarder
    implements PropertyChangeListener {
        private PropertyChangeForwarder() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractActionGroup.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }
}

