/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.echo.lib;

import java.util.Locale;
import javax.servlet.http.HttpSession;
import nextapp.echo.app.ApplicationInstance;
import nextapp.echo.app.Component;
import nextapp.echo.app.ContentPane;
import nextapp.echo.app.Window;
import nextapp.echo.webcontainer.ClientProperties;
import nextapp.echo.webcontainer.Connection;
import nextapp.echo.webcontainer.ContainerContext;
import nextapp.echo.webcontainer.WebContainerServlet;
import org.apache.log4j.Logger;
import pl.com.stream.echo.lib.StrApplicationInterface;
import pl.com.stream.echo.lib.component.window.StrWindow;
import pl.com.stream.echo.lib.exception.MessageException;
import pl.com.stream.echo.lib.resource.styles.StyleSheetMap;
import pl.com.stream.echo.lib.type.annotanion.LoadProperty;
import pl.com.stream.echo.lib.type.annotanion.SaveProperty;
import pl.com.stream.echo.lib.util.PropertyManager;
import pl.com.stream.echo.lib.util.XmlSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseApplication
extends ApplicationInstance
implements StrApplicationInterface {
    private static Logger log = Logger.getLogger(BaseApplication.class);
    private static final long serialVersionUID = -2262389959064658140L;
    private String currentStyleSheetName;
    private PropertyManager propertyManager;
    private XmlSource xmlSource;

    public static BaseApplication getApplication() {
        return (BaseApplication)BaseApplication.getActive();
    }

    public BaseApplication() {
        this(true);
    }

    public BaseApplication(boolean bl) {
        if (bl) {
            this.loadProperties();
        }
        this.setStyleSheet(StyleSheetMap.getInstance().getStyleSheet(this.getCurrentStyleSheet()));
    }

    @Override
    public String getCurrentStyleSheet() {
        if (this.currentStyleSheetName == null) {
            this.currentStyleSheetName = StyleSheetMap.getDefaultStyleSheetName();
        }
        return this.currentStyleSheetName;
    }

    @SaveProperty(propertyName="currentStyle")
    public String getResCurrentStyleSheet() {
        return this.currentStyleSheetName;
    }

    @Override
    @SaveProperty(propertyName="screenHeight")
    public Integer getScreenHeight() {
        ContainerContext containerContext = (ContainerContext)this.getContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME);
        ClientProperties clientProperties = containerContext.getClientProperties();
        return (Integer)clientProperties.get("screenHeight");
    }

    @Override
    @SaveProperty(propertyName="screenWidth")
    public Integer getScreenWidth() {
        ContainerContext containerContext = (ContainerContext)this.getContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME);
        ClientProperties clientProperties = containerContext.getClientProperties();
        return (Integer)clientProperties.get("screenWidth");
    }

    @Override
    public Component getSingleComponentInstance(Class<? extends Component> clazz) {
        String string;
        Connection connection = WebContainerServlet.getActiveConnection();
        HttpSession httpSession = connection.getRequest().getSession();
        if (httpSession.getAttribute(string = clazz.getName()) == null) {
            try {
                Component component = clazz.newInstance();
                httpSession.setAttribute(string, (Object)component);
            }
            catch (InstantiationException instantiationException) {
                log.error((Object)instantiationException.getMessage(), (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error((Object)illegalAccessException.getMessage(), (Throwable)illegalAccessException);
            }
        }
        return (Component)httpSession.getAttribute(string);
    }

    @Override
    public StrWindow getSingleWindowInstance(Class<? extends StrWindow> clazz) {
        String string;
        Connection connection = WebContainerServlet.getActiveConnection();
        HttpSession httpSession = connection.getRequest().getSession();
        if (httpSession.getAttribute(string = clazz.getName()) == null) {
            try {
                StrWindow strWindow = clazz.newInstance();
                httpSession.setAttribute(string, (Object)strWindow);
            }
            catch (InstantiationException instantiationException) {
                log.error((Object)instantiationException.getMessage(), (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error((Object)illegalAccessException.getMessage(), (Throwable)illegalAccessException);
            }
        }
        return (StrWindow)((Object)httpSession.getAttribute(string));
    }

    @Override
    public XmlSource getXmlSource() {
        return this.xmlSource;
    }

    public Window init() {
        this.initClientLocale();
        Window window = new Window();
        ContentPane contentPane = new ContentPane();
        window.setContent(contentPane);
        return window;
    }

    @Override
    public void loadProperties() {
        if (this.propertyManager == null) {
            this.propertyManager = new PropertyManager(this.getXmlSource());
        }
        try {
            this.propertyManager.loadProperties(this);
        }
        catch (MessageException messageException) {
            log.error((Object)messageException.getMessage(), (Throwable)messageException);
        }
    }

    @Override
    public void saveProperties() {
        if (this.propertyManager == null) {
            this.propertyManager = new PropertyManager(this.getXmlSource());
        }
        try {
            this.propertyManager.saveProperties(this);
        }
        catch (MessageException messageException) {
            log.error((Object)messageException.getMessage(), (Throwable)messageException);
        }
    }

    @Override
    public void setCurrentStyleSheet(String string) {
        if (string == null) {
            string = StyleSheetMap.getDefaultStyleSheetName();
        }
        this.currentStyleSheetName = string;
        this.setStyleSheet(StyleSheetMap.getInstance().getStyleSheet(string));
    }

    @LoadProperty(propertyName="currentStyle")
    public void setResCurrentStyleSheet(String string) {
        this.currentStyleSheetName = string;
    }

    public void setXmlSource(XmlSource xmlSource) {
        this.xmlSource = xmlSource;
    }

    protected void initClientLocale() {
        if (WebContainerServlet.getActiveConnection() != null) {
            Locale locale = WebContainerServlet.getActiveConnection().getRequest().getLocale();
            this.setLocale(locale);
        }
    }
}

