/*
 * Decompiled with CFR 0.152.
 */
package org.informagen.echo.app;

import org.informagen.echo.app.ActiveTextField;

public class NumericTextField
extends ActiveTextField {
    private static final long serialVersionUID = 3835078323133011364L;
    private static final double MIN_VALUE = new Integer(Integer.MIN_VALUE).doubleValue();
    private static final double MAX_VALUE = new Integer(Integer.MAX_VALUE).doubleValue();
    public static final String PROPERTY_MINIMUM_VALUE = "minimumValue";
    public static final String PROPERTY_MAXIMUM_VALUE = "maximumValue";
    private double minimumValue = MIN_VALUE;
    private double maximumValue = MAX_VALUE;

    public NumericTextField() {
        this(MIN_VALUE, MAX_VALUE);
    }

    public NumericTextField(double d, double d2) {
        if (d < d2) {
            this.setMinimumValue(d);
            this.setMaximumValue(d2);
        } else {
            this.setMinimumValue(d2);
            this.setMaximumValue(d);
        }
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    public double getMinimumValue() {
        return this.minimumValue;
    }

    public double getValue() {
        double d;
        try {
            d = Double.parseDouble(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        return d;
    }

    public boolean isInRange() {
        double d = this.getValue();
        double d2 = this.getMinimumValue();
        double d3 = this.getMaximumValue();
        return d2 <= d && d <= d3;
    }

    public boolean isValid() {
        return !NumericTextField.isEmpty(this.getText()) && this.isInRange();
    }

    public void setMaximumValue(double d) {
        double d2 = this.maximumValue;
        this.maximumValue = d;
        this.firePropertyChange(PROPERTY_MAXIMUM_VALUE, d2, d);
    }

    public void setMinimumValue(double d) {
        double d2 = this.minimumValue;
        this.minimumValue = d;
        this.firePropertyChange(PROPERTY_MINIMUM_VALUE, d2, d);
    }

    public void setValue(double d) {
        this.setText(Double.toString(d));
    }
}

