/*
 * Decompiled with CFR 0.152.
 */
package org.informagen.echo.app;

import org.informagen.echo.app.ActiveTextField;

public class IntegerTextField
extends ActiveTextField {
    private static final long serialVersionUID = -1852964237087971605L;
    public static final String PROPERTY_MINIMUM_VALUE = "minimumValue";
    public static final String PROPERTY_MAXIMUM_VALUE = "maximumValue";
    private int minimumValue = Integer.MIN_VALUE;
    private int maximumValue = Integer.MAX_VALUE;

    public IntegerTextField() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerTextField(int n, int n2) {
        if (n < n2) {
            this.setMinimumValue(n);
            this.setMaximumValue(n2);
        } else {
            this.setMinimumValue(n2);
            this.setMaximumValue(n);
        }
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getValue() {
        int n;
        try {
            n = Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public boolean isInRange() {
        int n = this.getValue();
        int n2 = this.getMinimumValue();
        int n3 = this.getMaximumValue();
        return n2 <= n && n <= n3;
    }

    public boolean isValid() {
        return !IntegerTextField.isEmpty(this.getText()) && this.isInRange();
    }

    public void setMaximumValue(int n) {
        int n2 = this.maximumValue;
        this.maximumValue = n;
        this.firePropertyChange(PROPERTY_MAXIMUM_VALUE, n2, n);
    }

    public void setMinimumValue(int n) {
        int n2 = this.minimumValue;
        this.minimumValue = n;
        this.firePropertyChange(PROPERTY_MINIMUM_VALUE, n2, n);
    }

    public void setValue(int n) {
        this.setText(Integer.toString(n));
    }
}

