/*
 * Decompiled with CFR 0.152.
 */
package org.informagen.echo.app;

import nextapp.echo.app.Alignment;
import nextapp.echo.app.Color;
import nextapp.echo.app.TextField;
import org.informagen.echo.app.ActiveTextFieldIcon;

public abstract class ActiveTextField
extends TextField {
    private static final long serialVersionUID = 1723912884962980949L;
    public static final String PROPERTY_MESSAGE = "message";
    public static final String PROPERTY_VALID_MESSAGE = "validMessage";
    public static final String PROPERTY_INVALID_MESSAGE = "invalidMessage";
    public static final String PROPERTY_MESSAGE_POSITION = "messagePosition";
    public static final String PROPERTY_EMPTY_ICON = "emptyIcon";
    public static final String PROPERTY_VALID_ICON = "validIcon";
    public static final String PROPERTY_INVALID_ICON = "invalidIcon";
    public static final String PROPERTY_ICON_POSITION = "iconPosition";
    public static final String PROPERTY_INVALID_FOREGROUND_COLOR = "invalidForegroundColor";
    public static final String PROPERTY_INVALID_BACKGROUND_COLOR = "invalidBackgroundColor";
    private boolean required = false;
    private String message = null;
    private String validMessage = null;
    private String invalidMessage = null;

    protected static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public int getIconPosition() {
        Alignment alignment = (Alignment)this.get(PROPERTY_ICON_POSITION);
        return alignment != null ? alignment.getHorizontal() : 2;
    }

    public Color getInvalidBackgroundColor() {
        return (Color)this.get(PROPERTY_INVALID_BACKGROUND_COLOR);
    }

    public Color getInvalidForegroundColor() {
        return (Color)this.get(PROPERTY_INVALID_FOREGROUND_COLOR);
    }

    public String getInvalidMessage() {
        return this.invalidMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public int getMessagePosition() {
        Alignment alignment = (Alignment)this.get(PROPERTY_MESSAGE_POSITION);
        return alignment != null ? alignment.getVertical() : 7;
    }

    public String getValidMessage() {
        return this.validMessage;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setEmptyIcon(ActiveTextFieldIcon activeTextFieldIcon) {
        this.set(PROPERTY_EMPTY_ICON, activeTextFieldIcon != null ? activeTextFieldIcon.getName() : ActiveTextFieldIcon.EMPTY.getName());
    }

    public void setIconPosition(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 0: {
                n = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Icon must be positioned on the RIGHT, LEFT, LEADING, TRAILING or DEFAULT");
            }
        }
        this.set(PROPERTY_ICON_POSITION, new Alignment(n, 0));
    }

    public void setInvalidBackgroundColor(Color color) {
        this.set(PROPERTY_INVALID_BACKGROUND_COLOR, color);
    }

    public void setInvalidForegroundColor(Color color) {
        this.set(PROPERTY_INVALID_FOREGROUND_COLOR, color);
    }

    public void setInvalidIcon(ActiveTextFieldIcon activeTextFieldIcon) {
        this.set(PROPERTY_INVALID_ICON, activeTextFieldIcon != null ? activeTextFieldIcon.getName() : ActiveTextFieldIcon.ERROR.getName());
    }

    public void setInvalidMessage(String string) {
        String string2 = this.invalidMessage;
        this.invalidMessage = string;
        this.firePropertyChange(PROPERTY_INVALID_MESSAGE, string2, string);
    }

    public void setMessage(String string) {
        String string2 = this.message;
        this.message = string;
        this.firePropertyChange(PROPERTY_MESSAGE, string2, string);
    }

    public void setMessagePosition(int n) {
        switch (n) {
            case 6: 
            case 7: {
                break;
            }
            case 0: {
                n = 7;
                break;
            }
            default: {
                throw new IllegalArgumentException("Message must be positioned on the TOP, BOTTOM or DEFAULT");
            }
        }
        this.set(PROPERTY_MESSAGE_POSITION, new Alignment(0, n));
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setValidIcon(ActiveTextFieldIcon activeTextFieldIcon) {
        this.set(PROPERTY_VALID_ICON, activeTextFieldIcon != null ? activeTextFieldIcon.getName() : ActiveTextFieldIcon.GOOD.getName());
    }

    public void setValidMessage(String string) {
        String string2 = this.validMessage;
        this.validMessage = string;
        this.firePropertyChange(PROPERTY_VALID_MESSAGE, string2, string);
    }

    abstract boolean isValid();
}

