/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.hibernate.exception;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.exception.GenericJDBCException;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;

public class DAOException
extends Exception {
    private static Map<String, String> knownFBErrorsMap = new HashMap<String, String>();
    private static final long serialVersionUID = 3363569445427796285L;
    private String message;
    private String title;

    public DAOException(String string, String string2) {
        this.title = string;
        this.message = string2;
    }

    public DAOException(String string, Throwable throwable) {
        super(string, throwable);
        this.message = string;
        if (throwable instanceof GenericJDBCException) {
            GenericJDBCException genericJDBCException = (GenericJDBCException)throwable;
            String string2 = genericJDBCException.getCause().getMessage();
            switch (genericJDBCException.getErrorCode()) {
                case 335544721: {
                    this.title = Res.databaseConnectionErrorTitle;
                    this.message = Res.canNotConnectToRemoteHost;
                    break;
                }
                case 335544344: {
                    this.title = Res.databaseConnectionErrorTitle;
                    this.message = Res.canNotReadDatabaseFile;
                    break;
                }
                case 335544472: {
                    this.title = Res.databaseConnectionErrorTitle;
                    this.message = Res.wrongLoginOrPassword;
                    break;
                }
                case 0x14000010: {
                    this.title = Res.databaseErrorTitle;
                    this.message = Res.deadlockError;
                    break;
                }
                default: {
                    this.title = MessageFormat.format(Res.databaseErrorNuberTitle, genericJDBCException.getErrorCode());
                    String string3 = knownFBErrorsMap.get(string2);
                    this.message = string3 == null ? string2 : string3;
                    break;
                }
            }
        } else if (throwable instanceof HibernateException) {
            HibernateException hibernateException = (HibernateException)throwable;
            this.title = Res.hibernateErrorTitle;
            String string4 = hibernateException.getMessage();
            String string5 = knownFBErrorsMap.get(string4);
            this.message = string5 == null ? string4 : string5;
        } else if (throwable instanceof DAOException) {
            DAOException dAOException = (DAOException)throwable;
            this.title = dAOException.getTitle();
            this.message = dAOException.getMessage();
        } else if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            switch (sQLException.getErrorCode()) {
                case 335544721: {
                    this.title = Res.databaseConnectionErrorTitle;
                    this.message = Res.canNotConnectToRemoteHost;
                    break;
                }
                case 335544344: {
                    this.title = Res.databaseConnectionErrorTitle;
                    this.message = Res.canNotReadDatabaseFile;
                    break;
                }
                case 335544472: {
                    this.title = Res.databaseConnectionErrorTitle;
                    this.message = Res.wrongLoginOrPassword;
                    break;
                }
                default: {
                    this.title = Res.databaseErrorTitle;
                    this.message = sQLException.getMessage();
                    break;
                }
            }
        } else {
            this.title = MessageFormat.format(Res.unknownErrorTitle, throwable.getClass().getSimpleName());
        }
    }

    public DAOException(Throwable throwable) {
        this(throwable.getMessage(), throwable);
    }

    public String getMessage() {
        return this.message;
    }

    public String getTitle() {
        return this.title;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    static {
        ResourceManager.bind(DAOException.class);
        knownFBErrorsMap.put("Connections could not be acquired from the underlying database!", Res.canNotConnectToDatabase);
        knownFBErrorsMap.put("Illegal attempt to associate a collection with two open sessions", Res.associateCollectionWithTwoSessions);
    }

    @ResourceContainer
    private static class Res {
        static String associateCollectionWithTwoSessions;
        static String canNotConnectToDatabase;
        static String canNotConnectToRemoteHost;
        static String canNotReadDatabaseFile;
        static String databaseConnectionErrorTitle;
        static String databaseErrorNuberTitle;
        static String databaseErrorTitle;
        static String deadlockError;
        static String hibernateErrorTitle;
        static String unknownErrorTitle;
        static String wrongLoginOrPassword;

        private Res() {
        }
    }
}

