/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.hibernate.dao;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.exception.DAOException;

public class HibernateSessionProvider
implements Serializable {
    private static Map<String, Configuration> configurationMap = new HashMap<String, Configuration>();
    private static String defaultConnectionName;
    private static Logger log;
    private static final long serialVersionUID = -4941201343180655539L;
    private static Map<String, SessionFactory> sessionFactoryMap;
    private String currentConnectionName;
    private final ThreadLocal<Map<String, org.hibernate.Session>> threadSessionMap = new ThreadLocal();

    public static void dispose() {
        log.debug((Object)"Closing session factories.");
        Set<String> set = sessionFactoryMap.keySet();
        for (String string : set) {
            SessionFactory sessionFactory = sessionFactoryMap.get(string);
            sessionFactory.close();
        }
        sessionFactoryMap.clear();
        configurationMap.clear();
    }

    public static Configuration getConfiguration() {
        return configurationMap.get(HibernateSessionProvider.getDefaultConnectionName());
    }

    public static Configuration getConfiguration(String string) {
        return configurationMap.get(string);
    }

    public static String getDefaultConnectionName() {
        return defaultConnectionName;
    }

    public static boolean isConnectedToDB() throws DAOException {
        return HibernateSessionProvider.isConnectedToDB(HibernateSessionProvider.getDefaultConnectionName());
    }

    public static boolean isConnectedToDB(String string) throws DAOException {
        SessionFactory sessionFactory = sessionFactoryMap.get(string);
        if (sessionFactory == null) {
            return false;
        }
        Session session = null;
        try {
            if (sessionFactory.isClosed()) {
                sessionFactory = HibernateSessionProvider.reconnect(string);
            }
            if ((session = sessionFactory.openSession()).isConnected()) {
                session.beginTransaction().begin();
                if (session.getTransaction().isActive()) {
                    session.getTransaction().commit();
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (HibernateException hibernateException) {
            sessionFactory.close();
            String string2 = MessageFormat.format(Res.connectingToDatabaseFailed, string, hibernateException.getMessage());
            throw new DAOException(string2, hibernateException);
        }
        finally {
            if (session != null && session.isConnected()) {
                session.close();
            }
        }
        return false;
    }

    public static SessionFactory reconnect(String string) throws DAOException {
        Configuration configuration = configurationMap.get(string);
        if (configuration == null) {
            return null;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.reconnectingToDatabase, string));
            SessionFactory sessionFactory = configuration.buildSessionFactory();
            sessionFactoryMap.put(string, sessionFactory);
            return sessionFactory;
        }
        catch (HibernateException hibernateException) {
            log.debug((Object)MessageFormat.format(Res.reconnectingToDatabaseFailed, string, hibernateException.getMessage()));
            throw new DAOException(hibernateException);
        }
    }

    public static SessionFactory registerSessionFactory(String string, Configuration configuration, boolean bl) throws DAOException {
        if (bl) {
            defaultConnectionName = string;
        }
        if (!configurationMap.containsKey(string) || configurationMap.get(string) == null) {
            configurationMap.put(string, configuration);
        }
        if (!sessionFactoryMap.containsKey(string) || sessionFactoryMap.get(string) == null) {
            try {
                log.debug((Object)MessageFormat.format(Res.creatingSessionFactory, string));
                Configuration configuration2 = configurationMap.get(string);
                SessionFactory sessionFactory = configuration2.buildSessionFactory();
                sessionFactoryMap.put(string, sessionFactory);
                return sessionFactory;
            }
            catch (Exception exception) {
                String string2 = MessageFormat.format(Res.creatingSessionFactoryFailed, string, exception.getMessage());
                log.error((Object)string2, (Throwable)exception);
                throw new DAOException(string2, exception);
            }
        }
        return sessionFactoryMap.get(string);
    }

    public static void setDefaultConnectionName(String string) {
        defaultConnectionName = string;
    }

    public static SessionFactory setSessionFactory(String string, Configuration configuration, boolean bl) throws DAOException {
        String string2;
        SessionFactory sessionFactory = sessionFactoryMap.get(string);
        if (sessionFactory != null) {
            try {
                sessionFactory.close();
            }
            catch (HibernateException hibernateException) {
                string2 = MessageFormat.format(Res.closingSessionFactoryFailed, string, hibernateException.getMessage());
                log.error((Object)string2, (Throwable)hibernateException);
            }
        }
        if (bl) {
            defaultConnectionName = string;
        }
        configurationMap.put(string, configuration);
        try {
            log.debug((Object)MessageFormat.format(Res.creatingSessionFactory, string));
            SessionFactory sessionFactory2 = configuration.buildSessionFactory();
            sessionFactoryMap.put(string, sessionFactory2);
            return sessionFactory2;
        }
        catch (HibernateException hibernateException) {
            string2 = MessageFormat.format(Res.creatingSessionFactoryFailed, string, hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            throw new DAOException(string2, hibernateException);
        }
    }

    public void closeSession() {
        this.closeSession(this.getCurrentConnectionName());
    }

    public void closeSession(String string) {
        block4: {
            org.hibernate.Session session = null;
            try {
                session = this.getSession(string, false);
                if (session == null) break block4;
                log.debug((Object)MessageFormat.format(Res.closingSession, string));
                try {
                    session.close();
                }
                catch (HibernateException hibernateException) {
                    String string2 = MessageFormat.format(Res.closingSessionFailed, string, hibernateException.getMessage());
                    log.error((Object)string2, (Throwable)hibernateException);
                }
                Map<String, org.hibernate.Session> map = this.threadSessionMap.get();
                map.put(string, null);
            }
            catch (DAOException dAOException) {
                // empty catch block
            }
        }
    }

    public String getCurrentConnectionName() {
        return this.currentConnectionName == null ? HibernateSessionProvider.getDefaultConnectionName() : this.currentConnectionName;
    }

    public org.hibernate.Session getSession() throws DAOException {
        return this.getSession(this.getCurrentConnectionName(), true);
    }

    public org.hibernate.Session getSession(String string) throws DAOException {
        return this.getSession(string, true);
    }

    public org.hibernate.Session getSession(String string, boolean bl) throws DAOException {
        org.hibernate.Session session;
        Map<String, org.hibernate.Session> map = this.threadSessionMap.get();
        if (map == null) {
            map = new HashMap<String, org.hibernate.Session>();
            this.threadSessionMap.set(map);
        }
        if ((session = map.get(string)) == null && bl) {
            SessionFactory sessionFactory = sessionFactoryMap.get(string);
            if (sessionFactory == null) {
                throw new DAOException(Res.informationTitle, Res.sessionFactoryNotConfigured);
            }
            log.debug((Object)MessageFormat.format(Res.openingNewSession, string));
            try {
                session = sessionFactory.openSession();
                map.put(string, session);
            }
            catch (HibernateException hibernateException) {
                sessionFactory.close();
                String string2 = MessageFormat.format(Res.openingNewSessionFailed, string, hibernateException.getMessage());
                log.error((Object)string2, (Throwable)hibernateException);
                throw new DAOException(string2, hibernateException);
            }
        }
        this.currentConnectionName = string;
        return session;
    }

    public void setCurrentConnectionName(String string) {
        this.currentConnectionName = string;
    }

    protected Transaction beginTransaction() {
        String string = this.getCurrentConnectionName();
        org.hibernate.Session session = null;
        try {
            session = this.getSession(string);
            if (session != null) {
                log.debug((Object)MessageFormat.format(Res.startingNewTransaction, string));
                try {
                    Transaction transaction = session.beginTransaction();
                    return transaction;
                }
                catch (HibernateException hibernateException) {
                    log.debug((Object)MessageFormat.format(Res.startingNewTransactionFailed, string));
                    throw hibernateException;
                }
            }
        }
        catch (DAOException dAOException) {
            // empty catch block
        }
        return null;
    }

    protected void commitTransaction() {
        block4: {
            String string = this.getCurrentConnectionName();
            org.hibernate.Session session = null;
            try {
                session = this.getSession(string, false);
                if (session == null) break block4;
                log.debug((Object)MessageFormat.format(Res.commitingTransaction, string));
                try {
                    session.getTransaction().commit();
                }
                catch (HibernateException hibernateException) {
                    String string2 = MessageFormat.format(Res.commitingTransactionFailed, string, hibernateException.getMessage());
                    log.error((Object)string2, (Throwable)hibernateException);
                    throw hibernateException;
                }
            }
            catch (DAOException dAOException) {
                // empty catch block
            }
        }
    }

    protected void rollbackTransaction() {
        block4: {
            String string = this.getCurrentConnectionName();
            try {
                org.hibernate.Session session = this.getSession(string, false);
                if (session == null) break block4;
                try {
                    log.debug((Object)MessageFormat.format(Res.rollbackingTransaction, string));
                    session.getTransaction().rollback();
                }
                catch (HibernateException hibernateException) {
                    log.error((Object)MessageFormat.format(Res.rollbackingTransactionFailed, string, hibernateException.getMessage()), (Throwable)hibernateException);
                }
                this.closeSession(string);
            }
            catch (DAOException dAOException) {
                // empty catch block
            }
        }
    }

    static {
        log = Logger.getLogger(HibernateSessionProvider.class);
        sessionFactoryMap = new HashMap<String, SessionFactory>();
        ResourceManager.bind(HibernateSessionProvider.class);
    }

    @ResourceContainer
    private static class Res {
        private static String closingSession;
        private static String closingSessionFactoryFailed;
        private static String closingSessionFailed;
        private static String commitingTransaction;
        private static String commitingTransactionFailed;
        private static String connectingToDatabaseFailed;
        private static String creatingSessionFactory;
        private static String creatingSessionFactoryFailed;
        private static String informationTitle;
        private static String openingNewSession;
        private static String openingNewSessionFailed;
        private static String reconnectingToDatabase;
        private static String reconnectingToDatabaseFailed;
        private static String rollbackingTransaction;
        private static String rollbackingTransactionFailed;
        private static String sessionFactoryNotConfigured;
        private static String startingNewTransaction;
        private static String startingNewTransactionFailed;

        private Res() {
        }
    }
}

