/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.hibernate.dao;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Property;
import pl.com.stream.lib.commons.reman.ResourceManager;
import pl.com.stream.lib.commons.reman.annotations.ResourceContainer;
import pl.com.stream.lib.hibernate.dao.HibernateSessionProvider;
import pl.com.stream.lib.hibernate.exception.DAOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateDAO<T>
extends HibernateSessionProvider {
    private static Logger log = Logger.getLogger(HibernateDAO.class);
    private static final long serialVersionUID = -2410265503055209359L;
    private Class<T> persistentClass;

    protected HibernateDAO() {
    }

    public void delete(T t) throws DAOException {
        if (t == null) {
            return;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.deletingEntity, this.getPersistentClass().getName()));
            this.beginTransaction();
            this.getSession().delete(t);
            this.commitTransaction();
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.deletingEntityFailed, this.getPersistentClass().getName(), hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, hibernateException);
        }
    }

    public void deleteFromSession(T t) throws DAOException {
        if (t == null) {
            return;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.deletingEntityFromSession, this.getPersistentClass().getName()));
            this.beginTransaction();
            this.getSession().evict(t);
            this.commitTransaction();
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.deletingEntityFromSessionFailed, this.getPersistentClass().getName(), hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, hibernateException);
        }
    }

    public T get(Integer n) throws DAOException {
        Object object = null;
        try {
            log.debug((Object)MessageFormat.format(Res.gettingEntity, this.getPersistentClass().getName(), n));
            this.beginTransaction();
            object = this.getSession().get(this.getPersistentClass(), (Serializable)n);
            this.commitTransaction();
            return (T)object;
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.gettingEntityFailed, this.getPersistentClass().getName(), hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, hibernateException);
        }
    }

    public List<T> getList(Integer ... integerArray) throws DAOException {
        return this.getList(null, "id", null, integerArray);
    }

    public List<T> getList(Order order, Integer ... integerArray) throws DAOException {
        return this.getList(new Order[]{order}, "id", null, integerArray);
    }

    public List<T> getList(Order[] orderArray, Integer ... integerArray) throws DAOException {
        return this.getList(orderArray, "id", null, integerArray);
    }

    public List<T> getList(Order[] orderArray, String string, Criterion criterion, Integer ... integerArray) throws DAOException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (integerArray != null && integerArray.length > 0 && orderArray != null && orderArray.length > 0) {
                stringBuffer.append(MessageFormat.format(Res.gettingEntityListWithIdsAndOrders, this.getPersistentClass().getName(), integerArray, orderArray));
            } else if (integerArray != null && integerArray.length > 0 && (orderArray == null || orderArray.length == 0)) {
                stringBuffer.append(MessageFormat.format(Res.gettingEntityListWithIds, this.getPersistentClass().getName(), integerArray));
            } else if ((integerArray == null || integerArray.length > 0) && orderArray != null && orderArray.length > 0) {
                stringBuffer.append(MessageFormat.format(Res.gettingEntityListWithOrders, this.getPersistentClass().getName(), orderArray));
            } else {
                stringBuffer.append(MessageFormat.format(Res.gettingEntityList, this.getPersistentClass().getName()));
            }
            log.debug((Object)stringBuffer);
            this.beginTransaction();
            Criteria criteria = this.getSession().createCriteria(this.getPersistentClass());
            if (integerArray != null && integerArray.length > 0) {
                criteria.add(Property.forName((String)string).in((Object[])integerArray));
            }
            if (criterion != null) {
                criteria.add(criterion);
            }
            if (orderArray != null && orderArray.length > 0) {
                for (Order order : orderArray) {
                    criteria.addOrder(order);
                }
            }
            Order[] orderArray2 = criteria.list();
            this.commitTransaction();
            return orderArray2;
        }
        catch (HibernateException hibernateException) {
            String string2 = MessageFormat.format(Res.gettingEntityListFailed, this.getPersistentClass().getName(), hibernateException.getMessage());
            log.error((Object)string2, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string2, hibernateException);
        }
    }

    public List<T> getList(String string, Integer ... integerArray) throws DAOException {
        return this.getList(null, string, null, integerArray);
    }

    public Class<T> getPersistentClass() {
        this.persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return this.persistentClass;
    }

    public void refresh(T t) throws DAOException {
        if (t == null) {
            return;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.refreshingEntity, this.getPersistentClass().getName()));
            this.beginTransaction();
            this.getSession().refresh(t);
            this.commitTransaction();
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.refreshingEntityFailed, this.getPersistentClass().getName(), hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, hibernateException);
        }
    }

    public void save(T t) throws DAOException {
        if (t == null) {
            return;
        }
        try {
            log.debug((Object)MessageFormat.format(Res.updatingEntity, this.getPersistentClass().getName()));
            this.beginTransaction();
            this.getSession().update(t);
            this.commitTransaction();
        }
        catch (HibernateException hibernateException) {
            String string = MessageFormat.format(Res.updatingEntityFailed, this.getPersistentClass().getName(), hibernateException.getMessage());
            log.error((Object)string, (Throwable)hibernateException);
            this.rollbackTransaction();
            throw new DAOException(string, hibernateException);
        }
    }

    static {
        ResourceManager.bind(HibernateDAO.class);
    }

    @ResourceContainer
    private static class Res {
        private static String deletingEntity;
        private static String deletingEntityFailed;
        private static String deletingEntityFromSession;
        private static String deletingEntityFromSessionFailed;
        private static String gettingEntity;
        private static String gettingEntityFailed;
        private static String gettingEntityList;
        private static String gettingEntityListFailed;
        private static String gettingEntityListWithIds;
        private static String gettingEntityListWithIdsAndOrders;
        private static String gettingEntityListWithOrders;
        private static String refreshingEntity;
        private static String refreshingEntityFailed;
        private static String updatingEntity;
        private static String updatingEntityFailed;

        private Res() {
        }
    }
}

