/*
 * Decompiled with CFR 0.152.
 */
package pl.com.stream.lib.commons.reman.repository;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RepositoryDescription {
    private static Logger log = Logger.getLogger(RepositoryDescription.class);
    private ClassLoader classLoader;
    private String name;
    private ResourceBundleDescription packageBundleDesc;
    private String path;

    public RepositoryDescription() {
    }

    public RepositoryDescription(String string, String string2, ClassLoader classLoader) {
        this.name = string;
        this.path = string2;
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getName() {
        return this.name;
    }

    public ResourceBundleDescription getPackageBundle() {
        if (this.packageBundleDesc == null) {
            String string = this.path;
            if (!string.endsWith("/")) {
                string = string + '/';
            }
            string = string + "Package";
            if ((string = string.replace('/', '.')).startsWith(".")) {
                string = string.substring(1);
            }
            this.packageBundleDesc = this.createPackageBundle(string, this.classLoader);
        }
        return this.packageBundleDesc;
    }

    public String getPath() {
        return this.path;
    }

    protected ResourceBundleDescription createPackageBundle(String string, ClassLoader classLoader) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
            return new ResourceBundleDescription(string, resourceBundle);
        }
        catch (MissingResourceException missingResourceException) {
            log.warn("Repository package bundle: " + string + " not found.");
            return null;
        }
    }

    protected void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected void setPath(String string) {
        this.path = string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceBundleDescription {
        private static final String LOGICAL_NAME_EDN_MARK = ".";
        private static final String NAME_EQUALS_LOGICAL_MARK = "*";
        private static final String ALIAS_PREFIX = "alias.";
        private static final String ALIAS_KEYS_REGEX = "\\[.+?\\]";
        private static final String ALIAS_EMPTY_REGEX = "\\[\\]";
        private static final Pattern patternAliasKeys = Pattern.compile("\\[.+?\\]");
        private static final Pattern patternAliasEmpty = Pattern.compile("\\[\\]");
        private final ResourceBundle bundle;
        private final String file;
        private final Map<String, String> resourceMap = new HashMap<String, String>();

        public ResourceBundleDescription(String string, ResourceBundle resourceBundle) {
            this.file = string;
            this.bundle = resourceBundle;
            this.prepareResourceMap();
        }

        public String getFile() {
            return this.file;
        }

        public Set<String> getKeySet() {
            return this.resourceMap.keySet();
        }

        public String getString(String string) {
            return this.resourceMap.get(string);
        }

        private void prepareResourceMap() {
            Object object;
            String string;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Enumeration<String> enumeration = this.bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                if (!string.startsWith(ALIAS_PREFIX)) continue;
                object = string.substring(ALIAS_PREFIX.length());
                hashMap.put((String)object, this.bundle.getString(string));
            }
            enumeration = this.bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                object = patternAliasKeys.matcher(string);
                if (((Matcher)object).find()) {
                    Object object2;
                    String string2 = ((Matcher)object).group();
                    String[] stringArray = string2.substring(1, string2.length() - 1).split(",");
                    String string3 = this.bundle.getString(string);
                    if (string3.contains(NAME_EQUALS_LOGICAL_MARK)) {
                        object2 = string.substring(0, string.indexOf(LOGICAL_NAME_EDN_MARK));
                        string3 = string3.replace(NAME_EQUALS_LOGICAL_MARK, (CharSequence)object2);
                    }
                    if (!((Matcher)(object2 = patternAliasEmpty.matcher(string3))).find()) continue;
                    for (String string4 : stringArray) {
                        String string5 = string.replaceFirst(ALIAS_KEYS_REGEX, string4);
                        String string6 = this.getAliasReplacement(hashMap, string4);
                        String string7 = string3.replaceFirst(ALIAS_EMPTY_REGEX, string6);
                        this.resourceMap.put(string5, string7);
                    }
                    continue;
                }
                this.resourceMap.put(string, this.bundle.getString(string));
            }
        }

        private String getAliasReplacement(Map<String, String> map, String string) {
            String string2 = map.get(string);
            if (string2 == null) {
                if (log.isTraceEnabled()) {
                    log.trace("Alias '" + string + "' is not implicity defined in " + this.file);
                }
                string2 = string;
            }
            return string2;
        }
    }
}

